/*------------------------------------------------------------------------------*
 * File Name:	fu_utils.c			 											*
 * Creation: 	Sim 08-17-2006													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Cheney 2006-12-27															*
 * Hong 01/15/07 FIX_TREE_NODE_NOT_EXIST										*
 * Hong 01/17/07 SHOULD_NOT_RESET_STORAGE_TREE_EVENT_WKS_CLEARED				*
 * Hong 01/17/07 RESET_USER_VARIABLES											*
 * Hong 02/12/07 MAKE_READONLY_FOR_FILE_BINARY_STORAGE							*
 *	ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES				*
 *	AW 02/27/06 GET_VALID_TEMPLATE_FILE											*
 * Hong 02/28/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF					*
 * Hong 03/06/07 CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE						*
 * Hong 03/12/07 QA80-9418-S1 ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT				*		
 * Sim 03-17-2007 CHECK_ERROR_FOR_INVALID_RANGE									*
 * Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE							*
 * Sim 03-19-2007 NEED_WAY_TO_CLEAR_SCRIPT										*
 * Sim 03-19-2007 ADD_OPTION_TO_PARTIAL_COLUMN									*
 * Sim 03-20-2007 FIX_APPEND_COMMENT_WHEN_REIMPORT								*
 * Sim 03-20-2007 FIX_BUG_OF_RANGE_FOR_REIMPORT									*
 * Sim 03-23-2007 FIX_LT_SCRIPT_PASS_TO_XF										*
 * Sim 03-23-2007 QA80-P10-L3 FIX_LACK_OF_ONE_ROW								*
 * Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE								*
 * Hong 03/27/07 QA80-9542 v8.0590 FIX_BINERY_FAIL_GET_VARIBLE					*
 * Hong 03/27/07 v8.0590 FIX_DUPLICATE_VARIABLE_BY_LAOD_FIILTER					*
 * Sim 04-06-2007 MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT							*
 * Hong 04/10/07 QA80-9595-P1 ROLLBACK_CODE_AS_9345_FIXED						*
 * Sim 04-11-2007 FIX_SKIP_DATA_POINTS											*
 *	Hong 04/14/07 v8.0600 SHOULD_NOT_CHANGE_PAGE_HIDDEN_STATUA					*
 *	Hong 04/16/07 FIX_FAIL_LOAD_75_USER_DEFINE_TYPE_FILTER						*
 *	Hong 04/16/07 v8.0601b CLEAN_SPARKLINE_IF_NOT_ADD_WHEN_REPLACE_MODE			*
 *	Hong 04/17/07 v8.0602b DEFAULT_SELECT_WHOLE_SHEET							*
 *	Hong 04/28/07 QA9702 CLEARLY_NEW_OBJECT_NEEDED								*
 *	Sim 04-30-2007 TEMP_FIX_IMPORT_MODE_FOR_SINGLE_FILE							*
 *	AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT			*
 *	Sim 05-08-2007 FIX_DEFAULT_SHOULD_NOT_CHAGNE_DESIGNATIONS					*
 *	Sim 05-08-2007 ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE						*
 *	Hong 05/09/07 v8.0614 FIX_AUTO_FAIL_WORKS_AFTER_EDIT						*
 *	Sim 05-09-2007 QA80-9476 FIX_SET_FULL_PATH_TO_COL_COMM						*
 *	CPY 5/17/07 QA70-9793 ADD_UNDERSCORE_BEFORE_ENUM_IF_END_WITH_NUMBERS		*
 *	Sim 05-23-2007 FIX_RUNTIME_ERROR_WHEN_TEMPLATE_INVALID						*
 *	Sim 05-24-2007 FIX_HEADER_LINE_ON_CONVERT_FILTER_75_TO_80					*
 *	Sim 05-30-2007 QA80-9476-P8 DEFAULT_NOT_OPEN_TIME_PARTIAL					*
 *	Sim 05-31-2007 IMPROVE_REIMPORT_CONTEXT_MENUE								*
 *	Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE							*
 *	Sim 06-04-2007 SOME_PAGES_TO_BE_EXCLUDED_FROM_MANAGER						*
 *	Sim 06-05-2007 WARNING_EXPORT_TO_EXISTING_FILE								*
 *	Sim 06-06-2007 CHANGE_FILTER_TAGNAME_ISSUE									*
 *	Sim 06-07-2007 FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES						*
 *	Sim 06-08-2007 FIX_LOAD_75_FILTER											*
 *	Sim 06-08-2007 DEFAULT_VALUE_FOR_BIN_IMPORT 								*
 *	Sim 06-12-2007 DROP_VERSION_INFO_WHEN_CONVERT_FILTER						*
 *  Justin 06-13-2007 RENAME_TAGNAME_OF_IMPORT_OPTION_TREE (not add code mark)	*
 *	Sim 06-19-2007 NOT_CREATE_LAYER_FOR_USER_DEFINED_IF_TARGET_TYPE_IS_NODE		*
 *	Sim 06-25-2007 UPDATE_ORGANIZER												*
 *	Sim 06-26-2007 ADD_LOAD_DATA_FOLDER_FILTER									*
 *	Folger 06/26/07 CHANGE_UPDATE_TO_NOTIFY										*
 *	Sim 07-11-2007 FIX_ADD_MAT_OBJ_MODE											*
 *	AW 07/11/07 SHOULD_NOT_AUTO_SIZE_IN_EXCEL_IMPORT							*
 *	Sim 07-13-2007 IMPORT_TO_GRAPH_SHOULD_KEEP_WORKSHEET_IN_SIGHT				*
 *	Hong v8.0671 FIX_75_FILTER_WITH_VARIABLE_FAIL_WORK_IN_80					*
 *	Sim 08-03-2007 FIX_D_AND_D_TO_GRAPH											*
 *	Sim 08-06-2007 SUPPORT_SMART_SPARKLINE										*
 *	Hong 08/07/07 v8.0676 FIX_PCLAMP_REIMPORT_RUNTIME_ERROR_BY_DELETE_SOME_COLS	*
 *	Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP	*
 *	Hong 08/15/07 v8.0682 ROLLBACK_CODE_TO_CENTRALIZE_CODE						*
 *	Hong 08/15/07 v8.0682 CENTRALIZE_CODE_FOR_SEARCH_FILTER_FILE				*
 *	Hong 09/08/07 v8.0698b FIX_FAIL_DUMP_OUTPUT_RANGE_ORNG						*	
 *	ML 9/11/2007 RUNTIME_ERROR_WHEN_IMPORTING_INTO_MATRIX						*
 *	CPY 9/16/2007 QA70-10383 SPARKLINE_LAST_USED_THEME							*
 *	Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE					*
 *	Sim 11-01-2007 CLEAN_RANGE_ID_CODE											*
 *	Sim 11-09-2007 FIX_CONV_FILTER_75_KNOWLEDGE_TO_80							*
 *	Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO									*
 *	Sim 01-02-2007 FIX_DETECT_EMPTY_BOOK										*
 *	Hong 01/08/08 V8.0780 FIX_SKIP_POINT_FAIL_APPLY_THEME_VALUE_IN_IMPWAV		*
 *	Hong QA80-11133 FIX_IMP_WIZ_FAIL_IMPORT_TO_ACTIVE_SHEET_WHEN_HAVE_OGW		*
 *	EJP 2008-02-25 v8.0812 QA80-4808 STOP_IMPORT_IF_ANY_COLS_ARE_LOCKED			*
 *	Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME		*
 *	Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE										*
 *	Hong 03/17/08 QA80-11162 ALLOW_OC_AUTO_SIZE_COMMENT_HEIGHT					*
 *	Hong 03/24/08 v8.0830 FIX_EXCEL_RUNTIME_BY_NOT_CONTAIN_FILLNODES_OF_RENAME_BRANCH
 *	Hong 06/06/08 v8.0879 AUTO_SIZE_NEED_MAXIMUM_LIMITATION						*
 *	Hong 07/30/08 QA80-11915 ASCII_DEFAULT_TURN_OFF_FORCE_SAME_SIZE_SUGGEST_CP_MAX
 *	Hong 08/05/08 QA80-11945 DEFAULT_TURN_ON_ALLOW_ALL_TEXT_IN_OC_CONSISTENT_WITH_75
 *	Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
 *	Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
 *	Sophy 10/23/2008 QA80-12422 SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
 *	Sim 10-29-2008 v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING	*
 *	Sim 10-31-2008 v9.963d FIX_DRAG_AND_DROP_PCLAMP_IMPORT_MODE_FAILED			*
 *	Hong 11/11/08 v8.0968c FIX_RENAME_TRIM_OPTION_FAIL_WORK_WHEN_SAVING			*
 *	Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION				*
 *	Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
 *	Hong 01/09/09 v8.0995 CORRECT_IMPASC_ERROR_RETURN_CHECKING					*
 *	Sim 03-03-2009 QA80-13209 IMPORT_IMG_SUPPORT_REIMPORT						*
 *	Hong 04/14/09 FIX_IMPASC_THEME_RESET_FAIL_RESET_PARTIAL_OPTIONS				*
 *	Hong 04/15/09 IMPROVE_XF_D&D_ERROR_MSG										*
 *	Folger 04/30/09 SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL
 *	Hong 08/26/09 QA80-13839 FIX_ORIGIN_CRASH_DUE_TO_BUFFER_OVERFLOW_WHEN_OPJ_CONTAIN_HUGE_PAGE_COMMENT
 *	Sim 09-02-2009 QA81-14236 FIX_SHOULD_NOT_CHANGE_COMMENT_FORMAT				*
 *	ML 9/30/3009 QA70-13839 NEED_EVEN_LARGER_TEMP_STRING_SIZE					*
 *	Hong 11/16/09 QA80-14079-P5 FIX_BINARY_UINT_VARIABLE_FAIL_TO_WORK			*
 *	Kenny 12/24/2009 QA81-14875-P2 PROGRESS_BAR_IN_BUILTIN_TOOL_SHOULD_NOT_KEEP_TOPMOST*
 *	Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC							*
 *	Sim 12-29-2009 QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL				*
 *	Sim 01-05-2010 QA81-14895 ADD_LT_VAR_FOR_DEFAULT_COUNTS_OF_AUTOSIZE_COLS	*
 *	Sim 02-04-2010 QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE	*
 *	Sim 02-05-2010 QA81-15063 ROLL_BACK_MOVE_COL_INFO_OUT_OF_USER_TREE			*
 *	Hong 03/12/10 QA80-15192-P1 FIX_BINARY_FILTER_HAVE_DUPLICATE_ID_MAKE_COPY_VALUE_BY_IDS_FAIL
 *	Sim 04-27-2010 ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
 *	Sophy 6/7/2010 ORG-220-P1 FAIL_TO_IMPORT_COLORFUL_IMAGE_TO_SAME_MATRIXSHEET	*
 *	Folger 06/28/10 ORG-155 ASCII_IMPORT_SPEED_IMPROVE							*
 *	Jacky 08/05/10 ORG-521-P5 ADD_OLDERFILTER_NODE_FOR_NEWFILTER				*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <oFilterUtils.h>
//#include "Import_Utils.h" ///---Sim 01-29-2007 GET_MOST_GENERAL_OPTIONS_FOR_XF
#include "fu_utils.h"
#include <page_utils.h>	//// AW 11/07/06 MORE_WORK_ON_SHOW_TIME_COL
#include <GetNbox.h>	///---Sim 02-08-2007 GENERAL_OPTIONS_FOR_XF
#include <okocUtils.h> ///---Sim 04-06-2007 MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT
#include <..\originlab\theme_utils.h>
//#include <..\originlab\wks_utils.h> ///---Sim 05-09-2007 QA80-9476 FIX_SET_FULL_PATH_TO_COL_COMM
#include <XFBase.h> ///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

// iw_base
///---Sim 05-08-2007 ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
void fuSet1stImportMode(TreeNode& trFilter, int iImportMode)
{
	if( !IS_IMPORT_MODE(iImportMode) )
		iImportMode = ASCIMP_MODE_REPLACE_DATA;
	fuSetInt(trFilter, IDE_DISPIMP_1STMODE, iImportMode);
}
int fuGet1stImportMode(TreeNode& trFilter)
{
	int nVal = fuGetInt(trFilter, IDE_DISPIMP_1STMODE, ASCIMP_MODE_REPLACE_DATA);
	if( !IS_IMPORT_MODE(nVal) )
		nVal = ASCIMP_MODE_REPLACE_DATA;
	return nVal;
}
void fuSetImportMode(TreeNode& trFilter, int iImportMode)
{
	if( !IS_IMPORT_MODE(iImportMode) )
		//iImportMode = ASCIMP_MODE_REPLACE_DATA;
		iImportMode = ASCIMP_MODE_NEW_SHEETS;
	fuSetInt(trFilter, IDE_IMP_IMPORTMODE, iImportMode);
}
int fuGetImportMode(TreeNode& trFilter)
{
	//int nVal = fuGetInt(trFilter, IDE_IMP_IMPORTMODE, ASCIMP_MODE_REPLACE_DATA);
	int nVal = fuGetInt(trFilter, IDE_IMP_IMPORTMODE, ASCIMP_MODE_NEW_SHEETS);
	if( !IS_IMPORT_MODE(nVal) )
		//nVal = ASCIMP_MODE_REPLACE_DATA;
		nVal = ASCIMP_MODE_NEW_SHEETS;
	return nVal;
}
///---END ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
/*
bool _fuLoadFilter(TreeNode &tnFilter, LPCSTR lpcszFile)
{
	Tree trFilter;
	if( !trFilter.Load(lpcszFile) )
		return false; // failed to load filter file

	double dOrgVer = fuGetOriginVersion(trFilter);
	if( dOrgVer < 8.0 )
	{
		TreeNode tnHdrParams;// = fuGetHeaderParams(tnFilter);
		if( !tnFilter.Common.HeaderParameters )
			tnFilter.Common.AddNode("HeaderParameters");
		tnHdrParams = tnFilter.Common.HeaderParameters;
		
		if( tnHdrParams &&
			tnHdrParams.FirstLine && tnHdrParams.LastLine && tnHdrParams.Separator )
		{
			//fuSetExtractVarByScanning(trFilter, TRUE);
			TreeNode tn = trFilter;
			if ( !tn )
			{
				if ( !tn.Variables )
					tn.AddNode("Variables");
				tn.Variables.ExtractByScanning.nVal = TRUE;
			}
		}
	}
	
	//fuSetOriginVersion(trFilter);
	double dVer;
	LT_get_var("@V", &dVer);
	fuSetDouble(&trFilter, IDE_FLT_ORIGIN_VER, dVer);
	
	tnFilter = trFilter;
	return true;
}
*/
/// Hong 9/01/06 GET_FILTER_BY_ID
/*
TreeNode fuGetHeaderParams(TreeNode &trFilter)
{
	if( !trFilter.Common.HeaderParameters )
		trFilter.Common.AddNode("HeaderParameters");
	return trFilter.Common.HeaderParameters;
}
*/
TreeNode fuGetHeaderParams(TreeNode &trFilter)
{
	///---Sim 09-06-2006 ADD_NODE_DYNAMIC
	/*
	TreeNode trHdrParams;
	trHdrParams = tree_get_node_by_id(trFilter,IDE_PARAMSIMP_HEADERPARAMETERS_NODE, true);
	if( !trHdrParams )
	{
		trHdrParams = trFilter.Display.AddNode("HeaderParameters");//suppose to be in Display node, may need change avoid hard code
		trHdrParams.SetAttribute(STR_DATAID_ATTRIB, IDE_PARAMSIMP_HEADERPARAMETERS_NODE);
	}
	return trHdrParams;
	*/
	FILTER_ADD_NODE(trFilter.GetNode(IMPORT_FILTER_DISPIMP), IDE_PARAMSIMP_HEADERPARAMETERS_NODE, "HeaderParameters");
	return tree_get_node_by_id(trFilter,IDE_PARAMSIMP_HEADERPARAMETERS_NODE, true);
	///---END ADD_NODE_DYNAMIC
}
/// end GET_FILTER_BY_ID
///---Sim 08-29-2006 GET_FILTER_BY_ID
/*
BOOL fuSetExtractVarByScanning(TreeNode& tnFilter, BOOL bEnable)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	tnVars.ExtractByScanning.nVal = bEnable;
	return TRUE;
}
*/
///---END GET_FILTER_BY_ID

//#ifdef USE_OC_FOR_FILTER_UTILS
BOOL fuSetOriginVersion(TreeNode &tnFilter)
{
	double d;
	LT_get_var("@V", &d);
	///---Sim 08-29-2006 GET_FILTER_BY_ID
	//tnFilter.OriginVersion.dVal = d;
	//return TRUE;
	return fuSetDouble(tnFilter, IDE_DISP_IMP_ORIGINVER, d);
	///---Sim 08-29-2006 GET_FILTER_BY_ID
}
/*
#else // !USE_OC_FOR_FILTER_UTILS
BOOL fuSetOriginVersion(TreeNode &tnFilter)
{
	double dVer;
	LT_get_var("@V", &dVer);
	return fuSetDouble(&tnFilter, IDE_FLT_ORIGIN_VER, dVer);
}
#endif // USE_OC_FOR_FILTER_UTILS
*/

bool _fuLoadFilter(TreeNode &tnFilter, LPCSTR lpcszFile)
{
	Tree trFilter;
	if( !trFilter.Load(lpcszFile) )
		return false; // failed to load filter file

	///---Sim 06-08-2007 FIX_LOAD_75_FILTER
	/*
	double dOrgVer = fuGetOriginVersion(trFilter);
	if( dOrgVer < 8.0 )
	{
		// this part of code need change to get value by id.
		TreeNode tnHdrParams = fuGetHeaderParams(tnFilter);
		if( tnHdrParams &&
			tnHdrParams.FirstLine && tnHdrParams.LastLine && tnHdrParams.Separator )
		{
			fuSetExtractVarByScanning(trFilter, TRUE);
		}
	}
	*/
	///---END FIX_LOAD_75_FILTER
	
	//fuSetOriginVersion(trFilter); ///---Sim 01-25-2007 LOAD_FILTER_SHOULD_NOT_SET_VERSION_MESSAGE remove
	tnFilter = trFilter;
	return true;
}

///---Sim 06-26-2007 ADD_LOAD_DATA_FOLDER_FILTER
//bool fuLoad(TreeNode &tnFilter, LPCSTR lpcszFile)// = NULL
/// Hong 03/12/10 QA80-15192-P1 FIX_BINARY_FILTER_HAVE_DUPLICATE_ID_MAKE_COPY_VALUE_BY_IDS_FAIL
//bool fuLoad(TreeNode &tnFilter, LPCSTR lpcszFile, LPCSTR lpcszDefPath) // = NULL, NULL
bool fuLoad(TreeNode &tnFilter, LPCSTR lpcszFile, LPCSTR lpcszDefPath, BOOL bCheckAddRepeatID/* = true*/) // = NULL, NULL
/// end FIX_BINARY_FILTER_HAVE_DUPLICATE_ID_MAKE_COPY_VALUE_BY_IDS_FAIL
///---END ADD_LOAD_DATA_FOLDER_FILTER
{
	// Check arguments
	if( !tnFilter || NULL == lpcszFile || 0 == *lpcszFile )
		return false;

	// Check for a file extension
	string strName = GetFileName(lpcszFile);
	if( -1 == strName.Find('.') )
		strName += ".oif";

	///---Sim 06-26-2007 ADD_LOAD_DATA_FOLDER_FILTER
	string strDefPath = lpcszDefPath;
	///---END ADD_LOAD_DATA_FOLDER_FILTER

	///---Sim 06-08-2007 FIX_LOAD_75_FILTER
	// If a path is specified then use it
	string strPath = GetFilePath(lpcszFile);
	if( !strPath.IsEmpty() )
	{
		strPath += strName;
		//return _fuLoadFilter(tnFilter, strPath);
		if( !_fuLoadFilter(tnFilter, strPath) )
			return false;
	}
	else
	{
		///---Sim 06-26-2007 ADD_LOAD_DATA_FOLDER_FILTER
		bool bLoad;
		bLoad = (!strDefPath.IsEmpty() && _fuLoadFilter(tnFilter, strDefPath + strName));
		if ( !bLoad )
		{
			/// Hong 08/15/07 v8.0682 CENTRALIZE_CODE_FOR_SEARCH_FILTER_FILE
			/*
			// Check 'Filters' folder
			strName.Insert(0, FILTERS_FOLDER_NAME);
		
			// Check user path
			strPath = GetAppPath(FALSE) + strName;
			//if( _fuLoadFilter(tnFilter, strPath) )
				//return true;
			//if( !_fuLoadFilter(tnFilter, strPath) )
			bLoad = _fuLoadFilter(tnFilter, strPath);
			if ( !bLoad )
			{
				/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
				// check group path
				strPath = okutil_get_origin_path(ORIGIN_PATH_GROUP) + strName;
				bLoad = _fuLoadFilter(tnFilter, strPath);
				if ( !bLoad ) // Check system path
				{
				/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
					strPath = GetAppPath(TRUE) + strName;
					//return _fuLoadFilter(tnFilter, strPath);
					//if( !_fuLoadFilter(tnFilter, strPath) )
					bLoad = _fuLoadFilter(tnFilter, strPath);
					if ( !bLoad )
						return false;
				}
			}
			*/
			/// Hong 09/11/07 v8.0700 FIX_FAIL_SEARCH_FIALTER_FILE
			//okutil_find_sys_path_with_file(&strPath, strName);						
			//bLoad = _fuLoadFilter(tnFilter, strPath);			
			/// Hong 01/24/08 FIX_FAIL_OPEN_FILE_WITH_FILTER
			//okutil_find_sys_path_with_file(&strPath, "Filters\\" + strName);
			//bLoad = _fuLoadFilter(tnFilter, strPath + strName);
			okutil_find_sys_path_with_file(&strPath, FILTERS_FOLDER_NAME + strName);
			bLoad = _fuLoadFilter(tnFilter, strPath + FILTERS_FOLDER_NAME + strName);
			/// end FIX_FAIL_OPEN_FILE_WITH_FILTER
			/// end FIX_FAIL_SEARCH_FIALTER_FILE
			if ( !bLoad )
				return false;
			/// end CENTRALIZE_CODE_FOR_SEARCH_FILTER_FILE
		}		
		///---END ADD_LOAD_DATA_FOLDER_FILTER
	}
	
	Tree trNewFilter;
	if ( !ConvFilter(tnFilter, trNewFilter) )
		return false;
	tnFilter.Replace(trNewFilter.Clone());
	
	/// Hong 03/12/10 QA80-15192-P1 FIX_BINARY_FILTER_HAVE_DUPLICATE_ID_MAKE_COPY_VALUE_BY_IDS_FAIL
	if ( bCheckAddRepeatID && FILTER_TYPE_BINARY == fuGetType(tnFilter) )
	{
		TreeNode tn = tree_get_node_by_id(tnFilter, IDE_PARAMSIMP_HEADERPARAMETERS_NODE, true);
		int			nRepeatID = 0;
		foreach ( TreeNode trNode in tn.Children )
		{
			if ( trNode.GetAttribute(STR_REPEAT_ID_ATTRIB, nRepeatID) )
				break;
			trNode.SetAttribute(STR_REPEAT_ID_ATTRIB, nRepeatID++);
		}
	}
	/// end FIX_BINARY_FILTER_HAVE_DUPLICATE_ID_MAKE_COPY_VALUE_BY_IDS_FAIL
	
	return true;
	///---END FIX_LOAD_75_FILTER
}

bool fuGetTypeName(TreeNode &trFilter, string &strType)
{
	StringArray	saFilterTypeName ={"ASCII","Binary", "User Defined","ImportFilter_XF", "unknown"};
	
	int iType = fuGetType(trFilter);
	if( IS_FILTER_TYPE(iType) )
	{
		if ( iType < FILTER_TYPE_ASCII || iType > FILTER_TYPE_XFUNC )
			iType = FILTER_TYPE_UNKNOWN;
		strType = saFilterTypeName[iType];
		return true;
	}
	return false;
}

int ImportErrorMsgBox(int iErr, LPCSTR lpcszFilter)
{
	string str, strErr;
	bool bAppendFilterName = false;

	switch( iErr )
	{
	case IMPERR_NO_FILTER:
		strErr = _L("No filter specified.");
		break;
	case IMPERR_LOAD_FILTER:
		str = _L("Error loading import filter:\r\n%s"); ///---Sim 09-11-2007 FIX_ESCAPE_CHAR
		strErr.Format(str, lpcszFilter);
		break;
	case IMPERR_NO_TARGET_PAGE:
		strErr = _L("No target page for data.");
		bAppendFilterName = true;
		break;
	case IMPERR_GET_IMPORT_FUNC:
		string strFilterType;
		Tree trFilter;
		/// EJP 2005-05-10 v8.0231 SUPPORT_VERSION_CHANGES
		///if( lpcszFilter && trFilter.Load(lpcszFilter) )
		if( lpcszFilter && fuLoad(trFilter, lpcszFilter) )
		/// end SUPPORT_VERSION_CHANGES
		{
			fuGetTypeName(trFilter, strFilterType);
			strErr.Format(_L("Failed to get pointer to %s import function."), strFilterType);
		}
		else
			strErr = _L("Failed to get pointer to import function.");
		break;
	case IMPERR_IMPORT_FUNC_ERR:
		string strFilterType;
		Tree trFilter;
		/// EJP 2005-05-10 v8.0231 SUPPORT_VERSION_CHANGES
		///if( lpcszFilter && trFilter.Load(lpcszFilter) )
		if( lpcszFilter && fuLoad(trFilter, lpcszFilter) )
		/// end SUPPORT_VERSION_CHANGES
		{
			/// Hong 04/15/09 IMPROVE_XF_D&D_ERROR_MSG
			if ( !fuGetXFunctionName(trFilter, strFilterType) )
			/// end IMPROVE_XF_D&D_ERROR_MSG
				fuGetTypeName(trFilter, strFilterType);
			strErr.Format(_L("%s import function returned error."), strFilterType);
		}
		else
			strErr = _L("The import function returned error.");
		bAppendFilterName = true;
		break;
	case IMPERR_PREPARE_WKS:
		strErr = _L("Error preparing worksheet for import.");
		bAppendFilterName = true;
		break;
	///---Sim 07-31-2006 ERR_HANDLE
	case IMPERR_IMPORT_MODE:
		strErr = _L("Error mode of import.");
		bAppendFilterName = true;
		break;
	///---END ERR_HANDLE
	case IMPERR_FILTER_TYPE:
		strErr = _L("Unknown filter type.");
		bAppendFilterName = true;
		break;
	///---Sim 07-31-2006 ERR_HANDLE
	case IMPERR_IWCLASS_UNDEFINED:
		strErr.Format(_L("Import wizard class %s undefined."), lpcszFilter);
		bAppendFilterName = true;
		break;
	///---END ERR_HANDLE
	///---Sim 07-31-2006 ERR_HANDLE
	case IMP_USER_CANCEL:
		strErr = _L("User cancel for import.");
		bAppendFilterName = true;
		break;
	///---END ERR_HANDLE
	case IMPERR_NONE:
	case IMPERR_CANCEL_ON_LOCKED_COL:
		return 0; // no error to report
	/// Hong 01/09/09 v8.0995 CORRECT_IMPASC_ERROR_RETURN_CHECKING
	case IMPERR_WKS_HAS_COL_LOCKED:		
		ocu_load_err_msg_str(XFERR_WORKSHEET_HAS_COL_LOCKED, &strErr);
		break;
	/// end CORRECT_IMPASC_ERROR_RETURN_CHECKING
	default:
		strErr = _L("Unknown error.");
		bAppendFilterName = true;
		break;
	}

	string strMsg;
	if( bAppendFilterName && lpcszFilter )
		strMsg.Format(_L("%s\r\nUsing filter:\r\n%s"), strErr, lpcszFilter); ///---Sim 09-11-2007 FIX_ESCAPE_CHAR
	else
		strMsg = strErr;

	/// EJP 2006-07-10 v8.0445 DO_NOT_HALT_EXECUTION_ON_ERR
	///MessageBox(GetWindow(), strMsg, _L("File Import Error"));
	///---Sim 01-05-2007 SHOW_ERROR_MESSAGE
	//printf("File Import Error: %s\n", strMsg);
	strMsg.Format(_L("File Import Error: %s\r\n"), strMsg); ///---Sim 09-11-2007 FIX_ESCAPE_CHAR
	warning_msg_box(strMsg, false);
	///---END SHOW_ERROR_MESSAGE
	/// end DO_NOT_HALT_EXECUTION_ON_ERR

	return 0;
}

/// Sim 08-25-2006 COMMON_FUNC_WKS_EMPTY
/*
int _is_sheet_empty(Layer &ly)
{
	Page pg;
	ly.GetParent(pg);
	if( !pg )
		return false;
	int nPageType = pg.GetType();
	switch( nPageType )
	{
	case EXIST_WKS:
		Worksheet wks = ly;//pg.Layers();
		if( !wks )
			return -1;
		//----CPY 4/5/06 WKS_CAN_BE_CREATED_WITH_NO_COLS
		if(wks.GetNumCols() == 0)
			return 1;
		//----
		int nR1, nR2;
		if( !wks.GetBounds(nR1, 0, nR2, -1) )
			return -1;
		if( 0 == nR1 && -1 == nR2 )
			return 1;
		return 0;
		
	case EXIST_MATRIX:
		MatrixLayer ml = ly;//pg.Layers();
		if( !ml )
			return -1;
		if( ml.HasData() || ml.HasImage() )
			return 0;
		return 1;
	}
	return -1;
}
*/
/// END COMMON_FUNC_WKS_EMPTY

///---Sim 08-30-2006 REMOVE_FROM_OFILTERUTILS
//// AW 02/27/06 GET_VALID_TEMPLATE_FILE
// when eed to get strTemplate, if the one saved in filter without path info, prioraty is 1) data file folder; 2) filter file folder;
// better can check if 1) is valid, if not then try 2). 
//int fuGetTargetPage(const TreeNode& tnFilter, string& strTemplate)// = NULL
int fuGetTargetPage(const TreeNode& tnFilter, string& strTemplate, string& strDataFilePath)// =NULL, NULL
//// END GET_VALID_TEMPLATE_FILE
{
	int nType = fuGetInt(tnFilter, IDE_DISP_IMP_PAGETYPE, EXIST_NONE);
	if ( strTemplate != NULL )
	//// AW 02/27/06 GET_VALID_TEMPLATE_FILE
	//	fuGetRStr(tnFilter, IDE_DISP_IMP_PAGETEMPLATE, strTemplate);
	{
		fuGetRStr(tnFilter, IDE_DISP_IMP_PAGETEMPLATE, strTemplate);
		if ( !strTemplate.IsEmpty() )
		{
			string strTempPath  = GetFilePath(strTemplate);
			if ( strTempPath.IsEmpty()) 
			{
				///---Sim 02-28-2007 FIX_TEMPLATE_FILE_FOLDER
				string strFile;
				// firstly check data folder
				if ( NULL != strDataFilePath )
				{
					strTempPath = strDataFilePath;
					if ( '\\' != strTempPath.Right(1) )
						strTempPath += '\\';	
					strFile = strTempPath + strTemplate;
					if ( !strFile.IsFile() )
						strTempPath.Empty();
				}
				
				// secondly check filter folder
				//else
				if ( strTempPath.IsEmpty() && tnFilter.Filename )
				{
					strTempPath = GetFilePath(tnFilter.Filename.strVal);
					if ( '\\' != strTempPath.Right(1) )
						strTempPath += '\\';	
					strFile = strTempPath + strTemplate;
					if ( !strFile.IsFile() )
						strTempPath.Empty();
				}
				///---END FIX_TEMPLATE_FILE_FOLDER
				strTemplate = strTempPath + strTemplate;			
			}
		}
	}
	/// END GET_VALID_TEMPLATE_FILE
	return nType;
}
BOOL fuSetTargetPage(TreeNode& tnFilter, int nType, LPCSTR lpcszTemplate)// = NULL
{
	int nRet = fuSetInt(tnFilter, IDE_DISP_IMP_PAGETYPE, nType);
	if ( nRet && lpcszTemplate != NULL )
		fuSetStr(tnFilter, IDE_DISP_IMP_PAGETEMPLATE, lpcszTemplate);
	return nRet;
}
///---END REMOVE_FROM_OFILTERUTILS


// impwiz

BOOL fuGetVarsRoot(TreeNode& tnFilter, TreeNode& tnVarsRoot)
{
	///---Sim 09-04-2006 GET_FILTER_BY_ID
	if( !tnFilter )
		return FALSE;
	/*
	if( !tnFilter.Variables )
		tnFilter.AddNode("Variables");
	tnVarsRoot = tnFilter.Variables;
	*/
	//tnVarsRoot = tree_get_node_by_id(tnFilter, IDE_VARIMP_VARIABLES_NODE, true);
	//if( !tnVarsRoot )
	//{
		//tnVarsRoot = tnFilter.AddNode("Variables");//suppose to be in Display node, may need change avoid hard code
		//tnVarsRoot.SetAttribute(STR_DATAID_ATTRIB, IDE_VARIMP_VARIABLES_NODE);
	//}
	FILTER_ADD_NODE(tnFilter, IDE_VARIMP_VARIABLES_NODE, "Variables");
	tnVarsRoot = tree_get_node_by_id(tnFilter, IDE_VARIMP_VARIABLES_NODE, true);
	
	return TRUE;
	///---END GET_FILTER_BY_ID
}

/// Hong 9/15/06 FIX_TREE_NODE_NOT_EXIST
BOOL fuSetExtractVarByDelimiter(TreeNode& tnFilter, BOOL bEnable)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	FILTER_ADD_NODE(tnVars, IDE_VARIMP_EXTBYDELIMITER, "ExtractByDelimiter");
	fuSetInt(tnVars, IDE_VARIMP_EXTBYDELIMITER, bEnable);
	return TRUE;
}

BOOL fuSetExtractVarByPosition(TreeNode& tnFilter, BOOL bEnable)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	FILTER_ADD_NODE(tnVars, IDE_VARIMP_EXTBYPOSITION, "ExtractByPosition");
	fuSetInt(tnVars, IDE_VARIMP_EXTBYPOSITION, bEnable);
	return TRUE;
}

BOOL fuSetExtractVarByScanning(TreeNode& tnFilter, BOOL bEnable)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	FILTER_ADD_NODE(tnVars, IDE_VARIMP_EXTVARBYSCAN, "ExtractByScanning");
	fuSetInt(tnVars, IDE_VARIMP_EXTVARBYSCAN, bEnable);
	return TRUE;
}

BOOL fuSetExtractVarByOCFunc(TreeNode& tnFilter, BOOL bEnable)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	FILTER_ADD_NODE(tnVars, IDE_VARIMP_EXTBYOCFUNC, "ExtractByOCFunction");
	fuSetInt(tnVars, IDE_VARIMP_EXTBYOCFUNC, bEnable);
	return TRUE;
}
/// end FIX_TREE_NODE_NOT_EXIST

/// Hong 01/15/07 FIX_TREE_NODE_NOT_EXIST
BOOL fuSetVarInPageInfo(TreeNode& tnFilter, BOOL bEnable)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	FILTER_ADD_NODE(tnVars, IDE_VARIMP_PAGEINFO, "PageInfo");
	fuSetInt(tnVars, IDE_VARIMP_PAGEINFO, bEnable);
	return TRUE;
}
/// end FIX_TREE_NODE_NOT_EXIST
/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
BOOL fuSetVarInUDL(TreeNode& tnFilter, BOOL bEnable)
{
	TreeNode 		tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	FILTER_ADD_NODE(tnVars, IDE_VARIMP_USERDEFINEDPARAM, "UserDefinedParameters");
	fuSetInt(tnVars, IDE_VARIMP_USERDEFINEDPARAM, bEnable);
	return TRUE;
}
/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
///---Sim 08-29-2006 GET_FILTER_BY_ID
/*
BOOL fuIsVarInPageInfo(TreeNode& tnFilter)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	if( !tnVars || !tnVars.PageInfo )
		return FALSE;
	return tnVars.PageInfo.nVal;
}
*/
///---END GET_FILTER_BY_ID
bool fuGetPostImportScript(TreeNode &trFilter, string &strScript)
{
	strScript.Empty(); ///---Sim 03-09-2007 FIX_SCRIPT_DEFAULT_SHOULD_EMPTY
	
	///---Sim 08-29-2006 GET_FILTER_BY_ID
	//if( !trFilter.Common.PostImportScript )
	//	return false;
	//strScript = trFilter.Common.PostImportScript.strVal;
	if ( !fuGetRStr(trFilter, IDE_IMP_POSTIMPSCRIPT, strScript) )
		return false;
	///---END GET_FILTER_BY_ID
	
	/// EJP 12-20-2004 v8.0177 UTIL_FUNC_CONV_CR_TO_CRLF
	///	// The string went into the filter with CR-LF combo, but the tree or XML
	///	// code strips the CR char.  Here I will replace all LF chars with CR-LF combo.
	///	// First check if combo is there in case tree or XML behavior changes.
	///	if( -1 == strScript.Find("\r\n") ) // If CR-LF combo is not found
	///		strScript.Replace("\n", "\r\n"); // Replace LF with CR-LF
	check_convert_CR_str_to_CRLF(strScript);
	/// end UTIL_FUNC_CONV_CR_TO_CRLF
	
	return true;
}

//#ifdef USE_OC_FOR_FILTER_UTILS
///---Sim 08-29-2006 GET_FILTER_BY_ID
/*
string fuGetDesignations(TreeNode& trFilter)
{
	string str;
	if( trFilter.Common.ColDesignations )
		str = trFilter.Common.ColDesignations.strVal;
	return str;
}
string fuGetFormats(TreeNode& trFilter)
{
	string str;
	if( trFilter.Common.ColFormats )
		str = trFilter.Common.ColFormats.strVal;
	return str;
}
BOOL fuGetRepetitive(TreeNode& trFilter)
{
	if( trFilter.Common.ColDesignationsRepetitive )
		return trFilter.Common.ColDesignationsRepetitive.nVal;
	return FALSE; // default is off
}
*/
///---END GET_FILTER_BY_ID
/*
#else // !USE_OC_FOR_FILTER_UTILS
string fuGetDesignations(TreeNode& trFilter)
{
	string str;
	fuGetStr(&trFilter, IDE_FLT_COL_DESIG, &str);
	return str;
}
string fuGetFormats(TreeNode& trFilter)
{
	string str;
	fuGetStr(&trFilter, IDE_FLT_COL_FORMAT, &str);
	return str;
}
#endif // USE_OC_FOR_FILTER_UTILS
*/

// IWASCII
BOOL fuGetASCIMP(TreeNode& trFilter, ASCIMP& ascimp, BOOL bGetCommonNode)// = FALSE
{
//	_MSG_INT(fuGetASCIMP, ascimp.iDelimited)
	
	TreeNode trASCIMP = trFilter.GetNode(IMPORT_FILTER_ASCIMP);
	if( trASCIMP )
	{
		///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
		if ( is_filter_gui_tree(trFilter) ) 
		{
			TREE_TO_STRUCT_BY_ID(trASCIMP, ascimp);
		}
		else
			ascimp = trASCIMP;
		///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE
		///---Sim 08-29-2006 COMMON_VALUE_ALREADY_IN_BINIMP_NODE
		/*	
		if( bGetCommonNode )
		{
			ascimp.iMode = trFilter.Common.ImportMode.nVal;
			ascimp.iRenameWks = trFilter.Common.RenameWks.nVal;
			ascimp.iPartial = trFilter.Common.Partial.nVal;
			ascimp.iPartialC1 = trFilter.Common.PartialC1.nVal;
			ascimp.iPartialC2 = trFilter.Common.PartialC2.nVal;
			ascimp.iPartialR1 = trFilter.Common.PartialR1.nVal;
			ascimp.iPartialR2 = trFilter.Common.PartialR2.nVal;
			ascimp.iSkipRows = tree_node_get_int(trFilter.Common.SkipRows, 0); /// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
			/// EJP 07-19-2004 v8.0911 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
			#if _OC_VER >= 0x0800
			ascimp.flags = tree_node_get_int(trFilter.Common.Flags, 0);
			#endif // _OC_VER >= 0x0800
			/// end SUPPORT_WORKBOOK_IMPWIZ
		}
		*/
		///---END COMMON_VALUE_ALREADY_IN_BINIMP_NODE
		return TRUE;
	}
	return FALSE;
}
///---Sim 08-29-2006 GET_FILTER_BY_ID
BOOL fuGetCustomDate(TreeNode& tnFilter, string& strFormat)
{
	//ASCIMP ai;
	//if( fuGetASCIMP(tnFilter, ai) )
	//{
	//	strFormat = ai.szDateFormat;
	fuGetRStr(tnFilter, IDE_ASCIMP_DATEFORMAT, strFormat);
	strFormat.TrimLeft();
	strFormat.TrimRight();
	return (!strFormat.IsEmpty());
	//}
	//return FALSE;
}
///---END GET_FILTER_BY_ID

// IWBinary
BOOL fuGetBINIMP(TreeNode& trFilter, BINIMP& binimp, BOOL bGetCommonNode)//=FALSE
{
	TreeNode trBINIMP = trFilter.GetNode(IMPORT_FILTER_BINIMP);
	if( trBINIMP )
	{
		///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
		if ( is_filter_gui_tree(trFilter) ) 
		{
			TREE_TO_STRUCT_BY_ID(trBINIMP, binimp);
		}
		else
			binimp = trBINIMP;
		///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE
		///hong 08-29-2006 COMMON_VALUE_ALREADY_IN_BINIMP_NODE
		/*	
		if( bGetCommonNode )
		{
			binimp.iMode = trFilter.Common.ImportMode.nVal;
			binimp.iRenameWks = trFilter.Common.RenameWks.nVal;
			binimp.iPartial = trFilter.Common.Partial.nVal;
			binimp.iPartialC1 = trFilter.Common.PartialC1.nVal;
			binimp.iPartialC2 = trFilter.Common.PartialC2.nVal;
			binimp.iPartialR1 = trFilter.Common.PartialR1.nVal;
			binimp.iPartialR2 = trFilter.Common.PartialR2.nVal;
			binimp.iSkipRows = tree_node_get_int(trFilter.Common.SkipRows, 0); /// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
			/// EJP 07-21-2004 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
			#if _OC_VER >= 0x0800
			binimp.flags = tree_node_get_int(trFilter.Common.Flags, 0);
			#endif // _OC_VER >= 0x0800
			/// end SUPPORT_WORKBOOK_IMPWIZ
		}
		*/
		///END COMMON_VALUE_ALREADY_IN_BINIMP_NODE
		return TRUE;
	}
	return FALSE;
}

// IWUser
PFNIMPLAYERFUNC fuGetImportToLayerFunctionPtr(TreeNode &trFilter)
{
	///---Sim 08-29-2006 GET_FILTER_BY_ID
	//string strOCFunc = trFilter.Common.OCFunction.strVal;
	//string strOCFile = trFilter.Common.OCFile.strVal;
	string strOCFunc = fuGetStr(trFilter, IDE_IMP_FUNCTION, "");
	string strOCFile = fuGetStr(trFilter, IDE_IMP_FILE, "");
	///---END GET_FILTER_BY_ID
	if( strOCFunc.IsEmpty() || strOCFile.IsEmpty() )
		return NULL;

	PFNIMPLAYERFUNC pfn = Project.FindFunction(strOCFunc, strOCFile, TRUE);
	return pfn;
}

PFNIMPORTFUNC fuGetImportFunctionPtr(TreeNode &trFilter)
{
	///---Sim 08-29-2006 GET_FILTER_BY_ID
	//string strOCFunc = trFilter.Common.OCFunction.strVal;
	//string strOCFile = trFilter.Common.OCFile.strVal;
	string strOCFunc = fuGetStr(trFilter, IDE_IMP_FUNCTION, "");
	string strOCFile = fuGetStr(trFilter, IDE_IMP_FILE, "");
	///---END GET_FILTER_BY_ID
	if( strOCFunc.IsEmpty() || strOCFile.IsEmpty() )
		return NULL;

	PFNIMPORTFUNC pfn = Project.FindFunction(strOCFunc, strOCFile, TRUE);
	return pfn;
}

// IWXF
BOOL fuGetXFunction(TreeNode& tnFilter, TreeNode& tnXFunc)
{
	if( tnFilter.XFunction )
	{
		tnXFunc = tnFilter.XFunction;
		return TRUE;
	}
	return FALSE;
}

///---Sim 02-05-2007 MORE_WORK_ON_TEMPLATE
int check_template(string& strTemplate, int nType)// = TEMPL_BOOK
{
	/// Hong 05/23/07 v8.0623 SHOULD_NOT_TRIM_FILENAME
	//strTemplate.TrimLeft();
	//strTemplate.TrimRight();
	/// end SHOULD_NOT_TRIM_FILENAME
	
	string strTemplName, strExt;
	separate_file_name_ext(strTemplate, &strTemplName, &strExt);
	
	if ( strTemplName.IsEmpty() )
		return TEMPL_TYPE_UNKNOWN;

	// default extension is ".otw"
	if ( strExt.IsEmpty() )
	{
		strExt = "otw";
		add_file_extension(strTemplate, strExt);
	}
	
	int nTemplType;
	if ( strExt.CompareNoCase("otw") == 0 )
	{
		nTemplType = TEMPL_TYPE_OTW;
	}
	else if ( strExt.CompareNoCase("otm") == 0 )
	{
		nTemplType = TEMPL_TYPE_OTM;
	}
	else if ( strExt.CompareNoCase("ogw") == 0 )
	{
		nTemplType = TEMPL_TYPE_OGW;
		
		if ( TEMPL_BOOK != nType )
		{
			string strMsg;
			strMsg.Format(_L("Warning: New Sheets mode does not support template file(%s.ogw)."), strTemplName);
			warning_msg_box(strMsg, false);
			strTemplate.Empty();
			nTemplType = TEMPL_TYPE_UNKNOWN;
		}
	}
	else if ( strExt.CompareNoCase("ogm") == 0 )
	{
		nTemplType = TEMPL_TYPE_OGM;
		
		if ( TEMPL_BOOK != nType )
		{
			string strMsg;
			strMsg.Format(_L("Warning: New Sheets mode does not support template file(%s.ogm)."), strTemplName);
			warning_msg_box(strMsg, false);
			strTemplate.Empty();
			nTemplType = TEMPL_TYPE_UNKNOWN;
		}
	}
	else
	{
		nTemplType = TEMPL_TYPE_UNKNOWN;
		strTemplate.Empty(); // clear template name
	}
	return nTemplType;
}
///---END MORE_WORK_ON_TEMPLATE

/// AW 08/30/06 SUPPORT_MULTI_FILES_INXF
///---Sim 09-19-2006 SUPPORT_DATA_RANGE
//Layer GetTargetLayer(Page& pgTarget, int& nIndexLayer, int nIndexFile, TreeNode& trFilter, BOOL bSameFilter)
Layer GetTargetLayer(Page& pgTarget, int& nIndexLayer, int nIndexFile, TreeNode& trFilter, BOOL bSameFilter, DataRange& orng, int nDefaultMode, int& nC1, bool bShowTimeCol, int& nC2, string& strDataFilePath) // true, NULL, ASCIMP_MODE_NEW_SHEETS, NULL, true, NULL, NULL
///---END SUPPORT_DATA_RANGE
{
	///---Sim 09-19-2006 SUPPORT_DATA_RANGE
	int nStartCol = -1;
	int nEndCol = -1;
	if ( 0 == nIndexFile && orng && orng.IsValid() )
	{
		int c1,c2; 
		Datasheet ds;
		orng.GetRange(ds, c1, c2);
		if ( ds && ds.IsValid() )
		{
			//if ( NULL != (&nC1) )
				//nC1 = c1;
			nStartCol = c1;
			nEndCol = c2; ///---Sim 03-01-2007 QA80-9420 REIMPORT
			nIndexLayer = ds.GetIndex(); ///---Sim 09-28-2006 UPDATE_FOR_CURRENT_LAYER_INDEX_VALUE
			ds.GetParent(pgTarget);
			//return ds;    /// AW 10/05/06 SHOULD ALSO CHECK IMPORT MODE ETC
		}
	}
	///---END SUPPORT_DATA_RANGE
	
	///---Sim 10-23-2006 CHECK_LAYER_INDEX
	//Layer lyTarget = pgTarget.Layers(nIndexLayer);
	Layer lyTarget;
	//// AW 10/30/06 MORE_WORK_ON_FILE_OPEN
	// fail to  open image file through menu File::Open...
	if ( pgTarget )
	{
	//// END MORE_WORK_ON_FILE_OPEN
		if ( nIndexLayer <= pgTarget.Layers.Count() - 1 )
		{
			lyTarget = pgTarget.Layers(nIndexLayer);
		}
		else
		{
			lyTarget = pgTarget.Layers();
			nIndexLayer = lyTarget.GetIndex();
		}
	///---END CHECK_LAYER_INDEX

		int nPageType = EXIST_NONE;
		if( pgTarget )
			nPageType = pgTarget.GetType();
	
		int nImportMode;
		if ( trFilter.IsValid() )
		{
			///---Sim 05-08-2007 ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
			if ( 0 == nIndexFile )
				nImportMode = fuGet1stImportMode(trFilter);
			else
				nImportMode = fuGetImportMode(trFilter);
			///---END ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
			if( ASCIMP_MODE_AUTO == nImportMode )
			{
				if( fuIsRenameWorkbook(trFilter) )
					nImportMode = ASCIMP_MODE_NEW_BOOKS;
				else if( fuIsRenameWks(trFilter) )
					nImportMode = ASCIMP_MODE_NEW_SHEETS;
				else
					nImportMode = ASCIMP_MODE_REPLACE_DATA;
			}
		}
		else
			///---Sim 09-19-2006 SUPPORT_DEFAULT_IMPORT_MODE
			//nImportMode = ASCIMP_MODE_NEW_SHEETS;
			nImportMode = nDefaultMode;
			///---END SUPPORT_DEFAULT_IMPORT_MODE
		
		///---Sim 02-05-2007 FIX_IMPORT_MODE Tracker 9324 P1-L3
		/*
		//// AW 11/07/06 MORE_WORK_ON_SHOW_TIME_COL
		if ( ASCIMP_MODE_APPEND_COLS == nImportMode && 0 == nIndexFile && !bShowTimeCol)
		{
			Worksheet wksTemp = lyTarget;
			if ( wks_has_x(wksTemp) )
				nImportMode = ASCIMP_MODE_NEW_SHEETS;	
		}
		//// END MORE_WORK_ON_SHOW_TIME_COL
		*/
		///---END FIX_IMPORT_MODE Tracker 9324 P1-L3
		
		///---Sim 10-31-2006 CHECK_LAYER_INDEX
		if ( !lyTarget || !lyTarget.IsValid() ) // create new layer if it is invalid
		{
			nImportMode = ASCIMP_MODE_NEW_SHEETS;
			nIndexLayer = -1;
		}
		///---END CHECK_LAYER_INDEX
		///---Sim 10-31-2006 CAN_NOT_IMPORT_TO_REPORT_SHEET
		if ( ASCIMP_MODE_NEW_BOOKS != nImportMode && ASCIMP_MODE_NEW_SHEETS != nImportMode )
		{
			// can't import into report sheet, create new sheet when meet report sheet
			if ( lyTarget.GetSystemParam(0) & WP_SHEET_HIERARCHY ) // report sheet
				nImportMode = ASCIMP_MODE_NEW_SHEETS;
		}
		///---END CAN_NOT_IMPORT_TO_REPORT_SHEET
			
		/// AW 11/01/06 FIX_AUTO_BUG_IN_ASC_IMP
		//if( !trFilter.IsValid() || fuGetTargetPage(trFilter) == nPageType )
		///---Sim 08-03-2007 FIX_D_AND_D_TO_GRAPH
		bool bDataSheet = ( EXIST_WKS == nPageType || EXIST_MATRIX == nPageType );
		bool bVarPageType = (!trFilter.IsValid() || EXIST_NONE == fuGetTargetPage(trFilter));
		//if( !trFilter.IsValid() || EXIST_NONE == fuGetTargetPage(trFilter) || fuGetTargetPage(trFilter) == nPageType )
		if( (bVarPageType && bDataSheet ) || fuGetTargetPage(trFilter) == nPageType )
		///---END FIX_D_AND_D_TO_GRAPH
		/// END FIX_AUTO_BUG_IN_ASC_IMP		
		{
			///---Sim 02-05-2007 MORE_WORK_ON_TEMPLATE
			string strTemplate;
			if ( trFilter.IsValid() )
				fuGetTargetPage(trFilter, strTemplate);
			///---END MORE_WORK_ON_TEMPLATE
				
			if( ASCIMP_MODE_REPLACE_DATA == nImportMode )
			{
				///---Sim 01-27-2007 CLEAN_LAYER_WHEN_REPLACE_MODE
				//if ( 0 == nIndexFile)
					//return lyTarget;
				if ( nIndexFile > 0 )
					nImportMode = ASCIMP_MODE_NEW_BOOKS;
				///---END CLEAN_LAYER_WHEN_REPLACE_MODE
			}
			
			/// import diff type files need use new workbook
			if ( 0 != nIndexFile && !bSameFilter && (ASCIMP_MODE_APPEND_COLS == nImportMode || ASCIMP_MODE_APPEND_ROWS == nImportMode ) )
				nImportMode = ASCIMP_MODE_NEW_BOOKS;
			
			///---Sim 03-01-2007 QA80-9420 REIMPORT
			if ( nStartCol < 0 )
				nStartCol = 0;
			/// Hong 08/07/07 v8.0676 FIX_PCLAMP_REIMPORT_RUNTIME_ERROR_BY_DELETE_SOME_COLS			
			//if ( nEndCol < 0 )			
			//{
			//	Datasheet ds(lyTarget);
			//	if ( ds )
			//		nEndCol = ds.GetNumCols() - 1;
			//}
			Datasheet ds(lyTarget);
			if ( ds )
			{
				int nNumCols = ds.GetNumCols();
				if ( nEndCol < 0 || nEndCol >= nNumCols )
					nEndCol = nNumCols - 1;
			}
			/// end FIX_PCLAMP_REIMPORT_RUNTIME_ERROR_BY_DELETE_SOME_COLS
			if ( NULL != (&nC1) )
				nC1 = nStartCol;
			if ( NULL != (&nC2) )
				nC2 = nEndCol;
			///---END QA80-9420 REIMPORT
			
			switch( nImportMode )
			{
			///---Sim 01-27-2007 CLEAN_LAYER_WHEN_REPLACE_MODE
			case ASCIMP_MODE_REPLACE_DATA:
				// clean layer
				Worksheet wks(lyTarget);
				if ( wks )
					//---- CPY 11/29/2007 MARKO_FOUND_ASCII_IMPORT_LOST_ALL_OPERATIONS
					//wks.SetSize(0, 0);
					///---Sim 02-01-2007 CLEAR_DATA_BUFFER_FOR_WORK_SHEET
					//wks.SetSize(0, -1);
				///---Sim 03-01-2007 QA80-9420 REIMPORT
				{
					//wks.ClearData();

					/// EJP 2008-02-25 v8.0812 QA80-4808 STOP_IMPORT_IF_ANY_COLS_ARE_LOCKED
					/// I am removing the following because we should not change the target
					/// wks incase of error or user aborts before the actual import starts.
					///
					///	wks.ClearData(0, nStartCol, nEndCol);
					///	/// Hong 04/16/07 v8.0601b CLEAN_SPARKLINE_IF_NOT_ADD_WHEN_REPLACE_MODE
					///	wks.ClearLabelsContent(RCLT_SPARKLINE, -1, nStartCol, nEndCol);
					///	/// end CLEAN_SPARKLINE_IF_NOT_ADD_WHEN_REPLACE_MODE
					/// end STOP_IMPORT_IF_ANY_COLS_ARE_LOCKED

					// temporary code
					//for ( int ii = nStartCol; ii <= nEndCol; ii++ )
					//{
						//Column col = wks.Columns(ii);
						//vectorbase& vb = col.GetDataObject();
						//vb = NANUM;
					//}
				}
				///---END QA80-9420 REIMPORT
					///---END CLEAR_DATA_BUFFER_FOR_WORK_SHEET
					//----
					
				MatrixLayer ml(lyTarget);
				if ( ml )
				{
					///Sophy 6/22/2010 ORG-220-P7 REPLACE_EXISTING_DATA_FROM_ACTIVE_MATRIXOBJECT_IN_IMPIMAGE
					//ml.SetSize(1, 0, 0);
					if ( NULL != (&nC1) )
						nC1 = -1;
					///end REPLACE_EXISTING_DATA_FROM_ACTIVE_MATRIXOBJECT_IN_IMPIMAGE
				}
				
				return lyTarget;
			///---END CLEAN_LAYER_WHEN_REPLACE_MODE
			case ASCIMP_MODE_APPEND_COLS:
				///---Sim 09-19-2006 APPEND_COLUMN_INSIDE
				/// Hong 06/28/07 v8.0651 ASCII_SUPPORT_IMPORT_TO_MATRIX_WITH_APPEND_COL
				/*
				if ( EXIST_WKS != nPageType )
					break;	// only support worksheet, otherwise new a book
				//if ( nStartCol < 0 ) // Data range is invalid, number of start column is end of sheet
				//{
					/// Hong 9/12/06 SUPPORT_MULTI_FILES_APPEND_COLS_MODE
					//if( ASCIMP_MODE_APPEND_COLS ==  fuGetImportMode(trFilter))
						//c1 = wks_find_empty_column(ws);
					Worksheet wks = lyTarget;      
					//int c1 = wks_find_empty_column(wks);
					nStartCol = wks_find_empty_column(wks);
					/// Hong 9/13/06 FIX_NOT_EMPTY_COLUMN
					//if ( c1 < 0 )
					if ( nStartCol < 0 )
					{
						//Worksheet wksTemp = lyTarget;      
						//c1 = wks.GetNumCols();
						nStartCol = wks.GetNumCols();
						wks.AddCol();
					}
					/// end FIX_NOT_EMPTY_COLUMN
					/// end SUPPORT_MULTI_FILES_APPEND_COLS_MODE
					
					nEndCol = wks.GetNumCols() - 1;
				//}
				*/
				Datasheet ds(lyTarget);
				nStartCol = sheet_find_empty_dataobject(ds);
				
				Worksheet wks = lyTarget;
				if ( wks )
				{
					if ( nStartCol < 0 )
					{
						nStartCol = wks.GetNumCols();
						wks.AddCol();
					}
					nEndCol = wks.GetNumCols() - 1;
				}
				
				MatrixLayer ml = lyTarget;
				if ( ml )
				{
					///---Sim 07-11-2007 FIX_ADD_MAT_OBJ_MODE
					/*
					if ( nStartCol < 0 )
					{
						nStartCol = ml.MatrixObjects.Count();
						ml.SetActive( ml.Insert(1) ); // active new added MatrixObject for import, specially for impASC					
					}
					*/
					if ( nStartCol < 0 )
					{
						nStartCol = ml.Insert(1);
					}
					ml.SetActive(nStartCol);
					///---END FIX_ADD_MAT_OBJ_MODE
					nEndCol = ml.MatrixObjects.Count() - 1;
				}
				/// end ASCII_SUPPORT_IMPORT_TO_MATRIX_WITH_APPEND_COL

				if ( NULL != (&nC1) )
					//nC1 = c1;
					nC1 = nStartCol;
				if ( NULL != (&nC2) )
					nC2 = nEndCol;
					
				return lyTarget;
				///---END APPEND_COLUMN_INSIDE
			///Sophy 6/4/2010 ORG-220 IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
			case ASCIMP_MODE_NEW_OBJECTS:
				
				MatrixLayer ml(lyTarget);
				ASSERT(ml.IsValid()); //only matrixsheet alllow new matrix objects
				if ( ml.IsValid() )
				{
					bool bCreate = true;
					MatrixObject mo(ml, ml.MatrixObjects.Count() - 1);
					///Sophy 6/7/2010 ORG-220-P1 FAIL_TO_IMPORT_COLORFUL_IMAGE_TO_SAME_MATRIXSHEET
					//if ( mo.IsValid() && !mo.HasData() )
					///Sophy 6/8/2010 ORG-220-S1 SUPPORT_APPEND_MATRIXOBJECT_OF_SAME_DIM_TO_EXISTING_SHEET
					//if ( mo.IsValid() && !mo.HasData() && !mo.HasImage() )
					if ( mo.IsValid() && (!mo.HasData() && !mo.HasImage() || is_sheet_empty(ml)) )
					///end SUPPORT_APPEND_MATRIXOBJECT_OF_SAME_DIM_TO_EXISTING_SHEET
					///end FAIL_TO_IMPORT_COLORFUL_IMAGE_TO_SAME_MATRIXSHEET
						bCreate = false;
					if ( bCreate )
					{
						int nMoIndex = ml.Insert(1); //append one matrix object
						if ( NULL != (&nC1) )
							nC1 = nMoIndex;
						if ( NULL != (&nC2) )
							nC2 = nMoIndex;
					}
				}
				return lyTarget;
			///end IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
			case ASCIMP_MODE_APPEND_ROWS:
				/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
				///return pgTarget;
				return lyTarget;
				/// end PRESERVE_ACTIVE_PAGE_AND_LAYER
			case ASCIMP_MODE_NEW_BOOKS:
				///---Sim 09-15-2006 CHECK_EMPTY_BOOKS
				///---Sim 02-05-2007 MORE_WORK_ON_TEMPLATE
				// if template is exist, always new a book
				if ( strTemplate.IsEmpty() )
				{
					//if( 0 == nIndexFile && 1 == pgTarget.Layers.Count() && is_sheet_empty(lyTarget) )
					///---Sim 01-02-2007 FIX_DETECT_EMPTY_BOOK
					//if( 1 == pgTarget.Layers.Count() && is_sheet_empty(lyTarget) ) // Hong 02/09/07 FIX_EMPTY_BOOK_WHEN_NO_DATA_IMPORT
					/// Hong 11/10/09 QA80-11771 IMPORT_MODE_SUPPORT_SKIP_EMPTY_BOOK_SHEET
					//if( is_book_empty(pgTarget) )
					if ( is_book_empty(pgTarget) && !fuIsSkipEmptyBookSheet(nImportMode) )
					/// end IMPORT_MODE_SUPPORT_SKIP_EMPTY_BOOK_SHEET
					{
						// return first layer for empty book
						nIndexLayer = 0;
						page_set_active_layer(pgTarget, nIndexLayer, false);
						lyTarget = pgTarget.Layers(nIndexLayer);
						return lyTarget;
					}
					///---END FIX_DETECT_EMPTY_BOOK
				}
				///---END MORE_WORK_ON_TEMPLATE
				///---END CHECK_EMPTY_BOOKS
				break;
			case ASCIMP_MODE_NEW_SHEETS:
				// We may want to put first file into active sheet
				// if active sheet is considered empty.
				
				///---Sim 02-05-2007 MORE_WORK_ON_TEMPLATE
				// if template is exist, always new a sheet
				check_template(strTemplate, TEMPL_SHEET);
				if ( strTemplate.IsEmpty() )
				{
					/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
					//if( 0 == nIndexFile && is_sheet_empty(lyTarget) )
					/// Hong 11/10/09 QA80-11771 IMPORT_MODE_SUPPORT_SKIP_EMPTY_BOOK_SHEET
					//if( is_sheet_empty(lyTarget) ) // Hong 02/09/07 FIX_EMPTY_BOOK_WHEN_NO_DATA_IMPORT
					if ( is_sheet_empty(lyTarget) && !fuIsSkipEmptyBookSheet(nImportMode) )
					/// end IMPORT_MODE_SUPPORT_SKIP_EMPTY_BOOK_SHEET
						return lyTarget;
					/// end PRESERVE_ACTIVE_PAGE_AND_LAYER
				}
	
				//nIndexLayer = pgTarget.AddLayer();
				DWORD dwOptions = 0;
				LPCSTR lpcszTemplate = NULL;
				if ( !strTemplate.IsEmpty() )
				{
					dwOptions = CREATE_NO_DEFAULT_TEMPLATE;
					lpcszTemplate = strTemplate;
				}
				nIndexLayer = pgTarget.AddLayer(NULL, dwOptions, lpcszTemplate);
				///---END MORE_WORK_ON_TEMPLATE
				///---Sim 05-23-2007 FIX_RUNTIME_ERROR_WHEN_TEMPLATE_INVALID
				if ( !strTemplate.IsEmpty() && nIndexLayer < 0 )
				{
					string strMsg;
					strMsg.Format(_L("Invalid template for new layer: %s"), strTemplate);
					warning_msg_box(strMsg, false);
					
					nIndexLayer = pgTarget.AddLayer();
				}
				///---END FIX_RUNTIME_ERROR_WHEN_TEMPLATE_INVALID
				
				if( nIndexLayer >= 0 )
				/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
				///	page_set_active_layer(pgTarget, nLayer);
				///return pgTarget;
				///---Sim 09-18-2006 SET_ACTIVE_FOR_ANY_IMPORTING
				{
					/// Hong 04/14/07 v8.0600 SHOULD_NOT_CHANGE_PAGE_HIDDEN_STATUA
					//set_active_layer(pgTarget.Layers(nIndexLayer));
					page_set_active_layer(pgTarget, nIndexLayer, false);
					/// end SHOULD_NOT_CHANGE_PAGE_HIDDEN_STATUA
					///---Sim 03-01-2007 QA80-9420 REIMPORT
					//return pgTarget.Layers(nIndexLayer);
					lyTarget = pgTarget.Layers(nIndexLayer);
					
					nStartCol = 0;
					Datasheet ds(lyTarget);
					if ( ds )
						nEndCol = ds.GetNumCols() - 1;
					if ( NULL != (&nC1) )
						nC1 = nStartCol;
					if ( NULL != (&nC2) )
						nC2 = nEndCol;
					
					return lyTarget;
					///---END QA80-9420 REIMPORT
				}
				///---END SET_ACTIVE_FOR_ANY_IMPORTING
				
				///---Sim 05-23-2007 FIX_RUNTIME_ERROR_WHEN_TEMPLATE_INVALID
				///---Sim 02-05-2007 MORE_WORK_ON_TEMPLATE
				//if ( strTemplate.IsEmpty() )
				warning_msg_box(_L("Failed to create new layer!"), false);
				/*
				else
				{
					string strMsg;
					strMsg.Format("Invalid template for new layer: %s", strTemplate);
					warning_msg_box(strMsg, false);
				}
				///---END MORE_WORK_ON_TEMPLATE
				*/
				///---END FIX_RUNTIME_ERROR_WHEN_TEMPLATE_INVALID
			
				return NULL;
				/// end PRESERVE_ACTIVE_PAGE_AND_LAYER
			default:
				ASSERT(FALSE); // should never come here
				// TODO: error handle here
				ImportErrorMsgBox(IMPERR_IMPORT_MODE, NULL); ///---Sim 07-31-2006 ERR_HANDLE
				return NULL;
			}
		}
	}	//// AW 10/30/06 MORE_WORK_ON_FILE_OPEN
	/// end NEW_IMPORT_MODES

	/// EJP 08-12-2003 v7.0657 HIDE_DATA_WINDOW_ON_IMPORT_INTO_GRAPH
	int iOption = CREATE_VISIBLE;
	if( pgTarget && EXIST_PLOT == pgTarget.GetType() )
		///---Sim 07-13-2007 IMPORT_TO_GRAPH_SHOULD_KEEP_WORKSHEET_IN_SIGHT
		/*
		///---Sim 06-04-2007 SOME_PAGES_TO_BE_EXCLUDED_FROM_MANAGER
		//iOption = CREATE_HIDDEN;
		 iOption = CREATE_SET_MISSING_IN_MANAGER;
		///---END SOME_PAGES_TO_BE_EXCLUDED_FROM_MANAGER
		*/
		iOption = CREATE_HIDDEN;
		///---END IMPORT_TO_GRAPH_SHOULD_KEEP_WORKSHEET_IN_SIGHT
	
	// create a new page
	int iType = EXIST_NONE;
	string strTemplate;
	if ( trFilter.IsValid() )
		iType = fuGetTargetPage(trFilter, strTemplate, strDataFilePath);
	
	///---Sim 02-05-2007 MORE_WORK_ON_TEMPLATE
	int nTemplType = check_template(strTemplate, TEMPL_BOOK);
	
	/// AW 11/02/06 FIX_AUTO_BUG_IN_ASC_IMP	
	// when call from menu, there is no filter, so I use option tree to fix auto import problem, so, need more work to handel New BOOK case
	//else
	//	iType = pgTarget.GetType();
	if ( EXIST_NONE == iType )
	///---Sim 02-13-2007 FIX_REDUNDANT_BOOK_FOR_SPE_AND_SPC
	{
		///---Sim 06-19-2007 NOT_CREATE_LAYER_FOR_USER_DEFINED_IF_TARGET_TYPE_IS_NODE
		if ( FILTER_TYPE_USERDEFINED == fuGetType(trFilter) )
		{
			// return invalid layer
			Layer ly;
			return ly;
		}
		///---END NOT_CREATE_LAYER_FOR_USER_DEFINED_IF_TARGET_TYPE_IS_NODE
		
		if ( pgTarget )
			iType = pgTarget.GetType();
		///---Sim 08-03-2007 FIX_D_AND_D_TO_GRAPH
		//else
		if ( !(EXIST_WKS == iType || EXIST_MATRIX == iType) )
			iType = EXIST_NONE;
		
		if ( EXIST_NONE == iType )
		///---END FIX_D_AND_D_TO_GRAPH
		{
			switch (nTemplType)
			{
			case TEMPL_TYPE_OTW:
			case TEMPL_TYPE_OGW:
				iType = EXIST_WKS;
				break;
			case TEMPL_TYPE_OTM:
			case TEMPL_TYPE_OGM:
				iType = EXIST_MATRIX;
				break;
			default:
				iType = EXIST_WKS;
				break;
			}
		}
	}
	///---END FIX_REDUNDANT_BOOK_FOR_SPE_AND_SPC
	/// END FIX_AUTO_BUG_IN_ASC_IMP
		
	//if ( TEMPL_TYPE_OGW == nTemplType )
	//{
		////unfinish
		//string strLT;
		//strLT.Format("doc -a %s", GetAppPath(true) + strTemplate);
		//LT_execute(strLT);
		//pgTarget = Project.Pages();
	//}
	//else
	//{
	if ( !strTemplate.IsEmpty() )
	{
		/// Hong 04/10/07 QA80-9595-P1 ROLLBACK_CODE_AS_9345_FIXED
		iOption |= CREATE_NO_DEFAULT_TEMPLATE;
		//iOption = CREATE_NO_DEFAULT_TEMPLATE; // temporary comment, has bug for template, #9345
		/// end ROLLBACK_CODE_AS_9345_FIXED
	}
	
	///---Sim 05-23-2007 FIX_RUNTIME_ERROR_WHEN_TEMPLATE_INVALID
	//Page pgTarget;
	if( EXIST_MATRIX == iType )
	{
		MatrixPage pgMat;
		//if( strTemplate.IsEmpty() )
		if( !strTemplate.IsEmpty() )
		{
			pgMat.Create(strTemplate, iOption);
			if ( !pgMat )
			{
				string strMsg;
				strMsg.Format(_L("Template file %s is invalid. Origin.otm is used to create the matrixbook or matrixsheet page."), strTemplate);
				warning_msg_box(strMsg, false);
			}
		}
		if ( !pgMat )
		{
			strTemplate = LabTalk.System.Matrix.DefTemplate$;
			pgMat.Create(strTemplate, iOption);
		}
		pgTarget = pgMat;
	}
	else if( EXIST_WKS == iType )
	{
		WorksheetPage pgWks;
		//if( strTemplate.IsEmpty() )
		if( !strTemplate.IsEmpty() )
		{
			pgWks.Create(strTemplate, iOption);
			if ( !pgWks )
			{
				string strMsg;
				strMsg.Format(_L("Template file %s is invalid. Origin.otw is used to create the workbook or worksheet page."), strTemplate);
				warning_msg_box(strMsg, false);
			}
		}
		if ( !pgWks )
		{
			strTemplate = LabTalk.System.Wks.DefTemplate$;
			pgWks.Create(strTemplate, iOption);
		}
		pgTarget = pgWks;
	}
		
	//}
	
	if ( !pgTarget.IsValid() )
	{
		//string strMsg;
		//strMsg.Format("Failed to create page, maybe template file %s is invalid!", strTemplate);
		//warning_msg_box(strMsg, false);
		warning_msg_box(_L("Failed to create page."), false);
		return NULL;
	}
	///---END FIX_RUNTIME_ERROR_WHEN_TEMPLATE_INVALID

	/// Hong QA80-11133 FIX_IMP_WIZ_FAIL_IMPORT_TO_ACTIVE_SHEET_WHEN_HAVE_OGW
	//nIndexLayer = 0; ///---Sim 07-31-2006 CREATE_PAGE
	////return pgTarget.Layers();
	//lyTarget = pgTarget.Layers(nIndexLayer);
	lyTarget = pgTarget.Layers();
	nIndexLayer = lyTarget.GetIndex();
	/// end FIX_IMP_WIZ_FAIL_IMPORT_TO_ACTIVE_SHEET_WHEN_HAVE_OGW
	
	///---Sim 03-01-2007 QA80-9420 REIMPORT
	nStartCol = 0;
	nEndCol = 0;
	
	Worksheet wks(lyTarget);
	if ( wks )
	{
		wks.ClearData();
		nEndCol = wks.GetNumCols() - 1;
	}
	
	if ( NULL != (&nC1) )
		nC1 = nStartCol;
	if ( NULL != (&nC2) )
		nC2 = nEndCol;
	///---END QA80-9420 REIMPORT
	
	return lyTarget;
	///---END MORE_WORK_ON_TEMPLATE
	/// end HIDE_DATA_WINDOW_ON_IMPORT_INTO_GRAPH
}

void GetDataRange(Layer& lyTarget, DataRange& dr, int nImportMode )
{
	Datasheet wks = lyTarget;
	int nFirstTargetCol = 0;
	if ( ASCIMP_MODE_APPEND_COLS ==  nImportMode)
	{
		nFirstTargetCol = wks_find_empty_column(wks);
		if ( nFirstTargetCol < 0 )
		{
			Worksheet wksTemp = wks;       //// AW !!!!!! later need think about Matrixlayer and graphLayer
			nFirstTargetCol = wksTemp.GetNumCols();;
			wksTemp.AddCol();
		}

	}
	if(wks)
		/// YuI 09/22/06 GETN_TREE_FOR_VARS_SET_EXTERNALLY_SHOULD_BE_CORRECT
		// passing NULL as range name will create separator node. This is wrong
		//	dr.Add(wks,nFirstTargetCol);
		/// Hong 04/17/07 v8.0602b DEFAULT_SELECT_WHOLE_SHEET
		//dr.Add(wks,nFirstTargetCol, "X");
		dr.Add(wks,nFirstTargetCol, "X", -1);
		/// end DEFAULT_SELECT_WHOLE_SHEET
		/// end GETN_TREE_FOR_VARS_SET_EXTERNALLY_SHOULD_BE_CORRECT
}
/// END SUPPORT_MULTI_FILES_INXF


///---Sim 08-29-2006 GET_FILTER_BY_ID
/*
BOOL fuGetXFunctionName(TreeNode& tnFilter, string& strName)
{
	TreeNode tnXFunc;
	if( fuGetXFunction(tnFilter, tnXFunc) )
	{
		if( tnXFunc.Name )
		{
			strName = tnXFunc.Name.strVal;
			return TRUE;
		}
	}
	return FALSE;
}
*/
///---END GET_FILTER_BY_ID

///---Sim 09-04-2006 REMOVE_FROM_FILTER_UTILS
void fuSetASCIMP(TreeNode& trFilter, ASCIMP& ascimp, BOOL bSetCommonNode)
{
	//_MSG_INT(fuSetASCIMP, ascimp.iDelimited) ///---Sim 09-04-2006 SEEMS_NO_USEFUL
	
	TreeNode trASCIMP = trFilter.GetNode(IMPORT_FILTER_ASCIMP);
	if( !trASCIMP )
		trASCIMP = trFilter.AddNode(IMPORT_FILTER_ASCIMP);
	trASCIMP.SetAttribute(STR_LABEL_ATTRIB, _L("ASCII"));		//------ Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO
	///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
	if ( is_filter_gui_tree(trFilter) ) 
	{
		STRUCT_TO_TREE_BY_ID(ascimp, trASCIMP);
	}
	else
		trASCIMP = ascimp;
	///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE
}
//------------------------------------------------------------
void fuSetBINIMP(TreeNode& trFilter, BINIMP& binimp, BOOL bSetCommonNode)
{
	TreeNode trBINIMP = trFilter.GetNode(IMPORT_FILTER_BINIMP);
	if( !trBINIMP )
		trBINIMP = trFilter.AddNode(IMPORT_FILTER_BINIMP);
	trBINIMP.SetAttribute(STR_LABEL_ATTRIB, _L("Binary"));		//------ Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO
	///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
	if ( is_filter_gui_tree(trFilter) ) 
	{
		STRUCT_TO_TREE_BY_ID(binimp, trBINIMP);
	}
	else
		trBINIMP = binimp;
	///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE
}
void fuSetDISPIMP(TreeNode& trFilter, DISPIMP& dispimp)
{
	TreeNode trDISPIMP = trFilter.GetNode(IMPORT_FILTER_DISPIMP);
	if( !trDISPIMP )
		trDISPIMP = trFilter.AddNode(IMPORT_FILTER_DISPIMP);
	trDISPIMP.SetAttribute(STR_LABEL_ATTRIB, _L("Display"));		//------ Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO
	///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
	if ( is_filter_gui_tree(trFilter) ) 
	{
		STRUCT_TO_TREE_BY_ID(dispimp, trDISPIMP);
	}
	else
		trDISPIMP = dispimp;
	///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE
}

void fuSetXFIMP(TreeNode& trFilter, XFIMP& xfimp)
{
	TreeNode trXFIMP = trFilter.GetNode(IMPORT_FILTER_XFIMP);
	if( !trXFIMP )
		trXFIMP = trFilter.AddNode(IMPORT_FILTER_XFIMP);
	trXFIMP.SetAttribute(STR_LABEL_ATTRIB, _L("X Function"));		//------ Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO
	///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
	if ( is_filter_gui_tree(trFilter) ) 
	{
		STRUCT_TO_TREE_BY_ID(xfimp, trXFIMP);
	}
	else
		trXFIMP = xfimp;
	///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE
}

void fuSetUSERDEFIMP(TreeNode& trFilter, USERDEFIMP& userdefimp)
{
	TreeNode trUSERDEFIMP = trFilter.GetNode(IMPORT_FILTER_USERDEFIMP);
	if( !trUSERDEFIMP )
		trUSERDEFIMP = trFilter.AddNode(IMPORT_FILTER_USERDEFIMP);
	trUSERDEFIMP.SetAttribute(STR_LABEL_ATTRIB, _L("User Defined"));		//------ Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO
	///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
	if ( is_filter_gui_tree(trFilter) ) 
	{
		STRUCT_TO_TREE_BY_ID(userdefimp, trUSERDEFIMP);
	}
	else
		trUSERDEFIMP = userdefimp;
	///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE
}

void fuPrepareDefault(TreeNode& trFilter, int nFilterType)
{
	trFilter.Reset();
	DISPIMP dispimp = {0};
	/// Hong 9/01/06 MOVE_TO_FIRST_LEVEL
	//dispimp.iType = nFilterType;
	trFilter.OriginVersion.SetAttribute(STR_DATAID_ATTRIB, IDE_DISP_IMP_ORIGINVER);
	trFilter.Type.nVal = nFilterType;
	trFilter.Type.SetAttribute(STR_DATAID_ATTRIB, IDE_DISP_IMP_TYPE);
	//------ Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO
	trFilter.OriginVersion.SetAttribute(STR_LABEL_ATTRIB, _L("Origin Version"));
	trFilter.Type.SetAttribute(STR_LABEL_ATTRIB, _L("Type"));
	//------ End LOCALIZE_IMPORT_FILE_INFO
	/// end MOVE_TO_FIRST_LEVEL
	fuSetOriginVersion(trFilter);
	fuSetDISPIMP(trFilter, dispimp);
	/// Hong 03/06/07 CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE
	//fuSetInt(trFilter, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, -1); // Hong 02/28/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//fuSetInt(trFilter, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, -1); ///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	fuSetInt(trFilter, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, 1);
	fuSetInt(trFilter, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, 1);
	/// end CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE
	///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
	//fuSetSparkLine(trFilter, TRUE); // Hong 01/26/07 DEFAULT_ADD_SPARKLINE
	fuSetSparkLine(trFilter, SPARKLINE_ADD_IF_LESS_THAN_50_COLS);
	///---END SUPPORT_SMART_SPARKLINE
	fuSetAutoSize(trFilter, FILTER_AUTO_SIZE_WIDTH); ///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	//Hong 8/30/06 MORE_INIT_FOR_FILTER
	///---Sim 05-08-2007 FIX_DEFAULT_SHOULD_NOT_CHAGNE_DESIGNATIONS
	//fuSetDesignations(trFilter, "XY");
	///---Sim 05-08-2007 FIX_DEFAULT_SHOULD_NOT_CHAGNE_DESIGNATIONS
	fuSetRepetitive(trFilter, FALSE);
	fuSetFormats(trFilter, "9");
	fuSetPlotID(trFilter, IDM_PLOT_LINE);
	fuSetTargetPage(trFilter, EXIST_WKS);
	///---Sim 02-24-2007 CHANGE_DEFAULT_TO_DISABLE
	//fuSetAutoRename(trFilter, TRUE); ///---Sim 02-02-2007 AUTO_RENAME_DEFAULT_IS_OPEN
	///---END CHANGE_DEFAULT_TO_DISABLE
	///end MORE_INIT_FOR_FILTER
	switch(nFilterType)
	{
	case FILTER_TYPE_ASCII:
		ASCIMP ascimp = {0};
		///---Sim 04-06-2007 MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT
		/*
		ascimp.iDelimited = 1;
		ascimp.iApplyRange = 0;
		fuSetASCIMP(trFilter, ascimp);
		///---Sim 03-07-2007 CHANGE_DEFAULT_SETTING
		fuSetRenameWks(trFilter, TRUE);
		fuSetRenameWorkbook(trFilter, TRUE);
		fuSetRenameBookWithoutPath(trFilter, TRUE); // include path when rename book default is off
		fuSetAppendFileNameToWorkBookComments(trFilter, TRUE);
		///---END CHANGE_DEFAULT_SETTING	
		/// Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE
		fuSetForceSameSize(trFilter, TRUE);
		/// end ADD_FORCE_ROW_SAME_SIZE
		*/
		initASCIMP(ascimp);
		fuSetASCIMP(trFilter, ascimp);
		///---END MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT
		return ;
	case FILTER_TYPE_BINARY:
		BINIMP binimp = {0};
		initBINIMP(binimp);	///---Sim 06-08-2007 DEFAULT_VALUE_FOR_BIN_IMPORT
		fuSetBINIMP(trFilter, binimp);
		///---Sim 03-07-2007 DEFAULT_SETTING
		/*
		fuSetImportMode(trFilter, ASCIMP_MODE_NEW_SHEETS); ///---Sim 05-08-2007 REMOVE_REPLACE_OUT_OF_MULTI_FILE_IMPORT_MODE
		fuSetRenameWks(trFilter, TRUE);
		fuSetRenameWorkbook(trFilter, TRUE);
		fuSetRenameBookWithoutPath(trFilter, TRUE); // include path when rename book default is off
		fuSetAppendFileNameToWorkBookComments(trFilter, TRUE);
		*/
		///---END DEFAULT_SETTING
		return ;
	case FILTER_TYPE_USERDEFINED:
		USERDEFIMP userdefimp = {0};
		fuSetUSERDEFIMP(trFilter, userdefimp);
		fuSetImportMode(trFilter, ASCIMP_MODE_NEW_SHEETS); ///---Sim 05-08-2007 REMOVE_REPLACE_OUT_OF_MULTI_FILE_IMPORT_MODE
		return ;
	case FILTER_TYPE_XFUNC:
		XFIMP xfimp = {0};
		fuSetXFIMP(trFilter, xfimp);
		fuSetImportMode(trFilter, ASCIMP_MODE_NEW_SHEETS); ///---Sim 05-08-2007 REMOVE_REPLACE_OUT_OF_MULTI_FILE_IMPORT_MODE
		///---Sim 03-07-2007 CHANGE_DEFAULT_SETTING
		fuSetRenameWks(trFilter, TRUE);
		fuXFSetRenameWorkbook(trFilter, TRUE);
		fuXFSetAppendFileNameIncludePath(trFilter, TRUE); // include path when append to comment default is on
		fuXFSetAppendFileNameToWorkBookComments(trFilter, TRUE);
		///---END CHANGE_DEFAULT_SETTING
		///---Sim 02-28-2007 QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
		fuSetStartPoint(trFilter, 1);
		fuSetEndPoint(trFilter, 0);
		fuSetColStartPoint(trFilter, 1);
		fuSetColEndPoint(trFilter, 0);
		fuSetReadPoint(trFilter, 1);
		fuSetSkipPoint(trFilter, 0);
		/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		fuSetStartTime(trFilter, 0);
		fuSetEndTime(trFilter, 0);
		/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT

		///---END QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
		return;
	default:
		return;
	}
}
///---END REMOVE_FROM_FILTER_UTILS

/// Hong 9/01/06 CONVERT_75_FILTER_TO_80
void GetDispFilter(const TreeNode &trIn, TreeNode &trOut)
{
	///---Sim 06-12-2007 DROP_VERSION_INFO_WHEN_CONVERT_FILTER
	//if (trIn.OriginVersion)
		//fuSetDouble(trOut, IDE_DISP_IMP_ORIGINVER,		trIn.OriginVersion.dVal);
	///---END DROP_VERSION_INFO_WHEN_CONVERT_FILTER
	if (trIn.Type)
		fuSetInt(trOut, IDE_DISP_IMP_TYPE,				trIn.Type.nVal);
	if (trIn.Common.ApplyRangeToGraph)
		fuSetInt(trOut, IDE_DISP_IMP_RANGETOGRAPH,		trIn.Common.ApplyRangeToGraph.nVal);
	if (trIn.Common.LinkWks)
		fuSetInt(trOut, IDE_DISP_IMP_LINKWKS,			trIn.Common.LinkWks.nVal);
	if (trIn.Common.ColDesignations)
		fuSetStr(trOut, IDE_DISP_IMP_COLDESIGN,			trIn.Common.ColDesignations.strVal);
	if (trIn.Common.ColDesignationsRepetitive)
		fuSetInt(trOut, IDE_DISP_IMP_COLDESIGNREP,		trIn.Common.ColDesignationsRepetitive.nVal);
	if (trIn.Common.ColFormats)
		fuSetStr(trOut, IDE_DISP_IMP_COLFORMATS,		trIn.Common.ColFormats.strVal);
	if (trIn.Common.PlotType)
		fuSetInt(trOut, IDE_DISP_IMP_PLOTTYPE,			trIn.Common.PlotType.nVal);
	if (trIn.Common.PlotTemplate)
		fuSetStr(trOut, IDE_DISP_IMP_PLOTTEMPLATE,		trIn.Common.PlotTemplate.strVal);
	if (trIn.Common.TargetWindowType)
		fuSetInt(trOut, IDE_DISP_IMP_PAGETYPE,			trIn.Common.TargetWindowType.nVal);
	if (trIn.Common.TargetWindowTemplate)
		fuSetStr(trOut, IDE_DISP_IMP_PAGETEMPLATE,		trIn.Common.TargetWindowTemplate.strVal);
	if (trIn.Common.FilenameToWksLabel)
		fuSetInt(trOut, IDE_DISP_IMP_FNAMETOWKSLAB,		trIn.Common.FilenameToWksLabel.nVal);
	if (trIn.Common.FileSpec)
		fuSetStr(trOut, IDE_DISP_IMP_FILESPEC,			trIn.Common.FileSpec.strVal);
	if (trIn.Common.Description)
		fuSetStr(trOut, IDE_DISP_IMP_DESCRIPTION,		trIn.Common.Description.strVal);
	/// Hong 9/26/06 MORE_FOR_FILTER
	TreeNode trNode;
	if (trIn.Common.HeaderParameters)
	{	
		trNode = fuGetHeaderParams(trOut);
		trNode.Replace(trIn.Common.HeaderParameters.Clone());
		trNode.SetAttribute(STR_DATAID_ATTRIB,IDE_PARAMSIMP_HEADERPARAMETERS_NODE); 
		/// Hong v8.0671 FIX_75_FILTER_WITH_VARIABLE_FAIL_WORK_IN_80
		if (trNode.FirstLine)
			trNode.FirstLine.SetAttribute(STR_DATAID_ATTRIB,IDE_PARAMSIMP_FIRSTLINE);		
		if (trNode.LastLine)
			trNode.LastLine.SetAttribute(STR_DATAID_ATTRIB,IDE_PARAMSIMP_LASTLINE);		
		if (trNode.Separator)
			trNode.Separator.SetAttribute(STR_DATAID_ATTRIB,IDE_PARAMSIMP_SEPARATOR);
		
		fuGetVarsRoot(trOut, trNode);
		trNode.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_VARIABLES_NODE);
		fuSetExtractVarByScanning(trOut, 1);		
		fuSetVarInPageInfo(trOut, 1);
		/// end FIX_75_FILTER_WITH_VARIABLE_FAIL_WORK_IN_80
		/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
		fuSetVarInUDL(trOut, FALSE);
		/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	}
	if (trIn.Variables)
	{
		fuGetVarsRoot(trOut, trNode);
		trNode.Replace(trIn.Variables.Clone());
		trNode.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_VARIABLES_NODE);
		
		if(trNode.ExtractByScanning)
			trNode.ExtractByScanning.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_EXTVARBYSCAN);
		if(trNode.ExtractByDelimiter)
			trNode.ExtractByDelimiter.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_EXTBYDELIMITER);
		if(trNode.ExtractByPosition)
			trNode.ExtractByPosition.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_EXTBYPOSITION);
		if(trNode.ExtractByOCFunction)
			trNode.ExtractByOCFunction.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_EXTBYOCFUNC);
		if(trNode.PageInfo)
			trNode.PageInfo.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_PAGEINFO);
		if(trNode.OCFileName)
			trNode.OCFileName.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_OCFILENAME);
		if(trNode.OCFunctionName)
			trNode.OCFunctionName.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_OCFUNCNAME);
		if(trNode.Vars)
			trNode.Vars.SetAttribute(STR_DATAID_ATTRIB,IDE_VARIMP_VARS_NODE);
	}
	if (trIn.Common.DragAndDrop)
	{
		FILTER_ADD_NODE(trOut.GetNode(IMPORT_FILTER_DISPIMP), IDE_DNDIMP_NODE, "DragAndDrop");
		trNode = trOut.GetNode(IMPORT_FILTER_DISPIMP).DragAndDrop;
		trNode.Replace(trIn.Common.DragAndDrop.Clone());

		if(trNode.Graph)
			trNode.Graph.SetAttribute(STR_DATAID_ATTRIB,IDE_DNDIMP_GRAPH);
		if(trNode.Workspace)
			trNode.Workspace.SetAttribute(STR_DATAID_ATTRIB,IDE_DNDIMP_WORKSPACE);
	}
	if (trIn.Common.PostImportScript)
	{
		FILTER_ADD_NODE(trOut.GetNode(IMPORT_FILTER_DISPIMP), IDE_IMP_POSTIMPSCRIPT, "PostImportScript");
		trOut.GetNode(IMPORT_FILTER_DISPIMP).PostImportScript.Replace(trIn.Common.PostImportScript.Clone());
		trOut.GetNode(IMPORT_FILTER_DISPIMP).PostImportScript.SetAttribute(STR_DATAID_ATTRIB, IDE_IMP_POSTIMPSCRIPT);
	}
	/// END MORE_FOR_FILTER
}

void SettingFilterID(const TreeNode &tr)
{
	if (tr.DISPIMP.strColDesignations)
		tr.DISPIMP.strColDesignations.SetAttribute(STR_DATAID_ATTRIB, IDE_DISP_IMP_COLDESIGN);
	if (tr.DISPIMP.strColFormats)
		tr.DISPIMP.strColFormats.SetAttribute(STR_DATAID_ATTRIB, IDE_DISP_IMP_COLFORMATS);
	if (tr.DISPIMP.strPlotTemplate)
		tr.DISPIMP.strPlotTemplate.SetAttribute(STR_DATAID_ATTRIB, IDE_DISP_IMP_PLOTTEMPLATE);
	if (tr.DISPIMP.strTargetWindowTemplate)
		tr.DISPIMP.strTargetWindowTemplate.SetAttribute(STR_DATAID_ATTRIB, IDE_DISP_IMP_PAGETEMPLATE);
	if (tr.DISPIMP.strFileSpec)
		tr.DISPIMP.strFileSpec.SetAttribute(STR_DATAID_ATTRIB, IDE_DISP_IMP_FILESPEC);
	if (tr.DISPIMP.strDescription)
		tr.DISPIMP.strDescription.SetAttribute(STR_DATAID_ATTRIB, IDE_DISP_IMP_DESCRIPTION);
	
	if (tr.ASCIMP.szFixedWidth)
		tr.ASCIMP.szFixedWidth.SetAttribute(STR_DATAID_ATTRIB, IDE_ASCIMP_COLWIDTHS);
	if (tr.ASCIMP.szDateFormat)
		tr.ASCIMP.szDateFormat.SetAttribute(STR_DATAID_ATTRIB, IDE_ASCIMP_DATEFORMAT);
	if (tr.ASCIMP.cDelimiters)
		tr.ASCIMP.cDelimiters.SetAttribute(STR_DATAID_ATTRIB, IDE_ASCIMP_DELIMITERS);
		
	if (tr.BINIMP.vParamType)
		tr.BINIMP.vParamType.SetAttribute(STR_DATAID_ATTRIB, IDE_BINIMP_PARAMTYPE);
	if (tr.BINIMP.vParamSize)
		tr.BINIMP.vParamSize.SetAttribute(STR_DATAID_ATTRIB, IDE_BINIMP_PARAMSIZE);
	if (tr.BINIMP.vParamCount)
		tr.BINIMP.vParamCount.SetAttribute(STR_DATAID_ATTRIB, IDE_BINIMP_PARAMCOUNT);

	if (tr.XFunction.strName)
		tr.XFunction.strName.SetAttribute(STR_DATAID_ATTRIB, IDE_XFIMP_NAME);
		
	if (tr.UserDefine.PostImportScript)
		tr.UserDefine.PostImportScript.SetAttribute(STR_DATAID_ATTRIB, IDE_USERDEFIMP_POSTIMPSCRIPT);
	if (tr.UserDefine.OCFile)
		tr.UserDefine.OCFile.SetAttribute(STR_DATAID_ATTRIB, IDE_USERDEFIMP_FILE);
	if (tr.UserDefine.OCFunction)
		tr.UserDefine.OCFunction.SetAttribute(STR_DATAID_ATTRIB, IDE_USERDEFIMP_FUNCTION);
	if (tr.UserDefine.OCClass)
		tr.UserDefine.OCClass.SetAttribute(STR_DATAID_ATTRIB, IDE_USERDEFIMP_CLASS);
}

bool ConvFilter(const TreeNode &trFilterOlder, TreeNode &trFilterLater)
{
	///---Sim 02-24-2007 FIX_FILTER_CONVERSION
	trFilterLater.Replace(trFilterOlder);
	
	double dVer = fuGetOriginVersion(trFilterOlder);
	
	if( dVer < 8.0473 )
	{
		int iType = FILTER_TYPE_UNKNOWN;
		if (trFilterOlder.Type)
			iType = trFilterOlder.Type.nVal;
		if ( FILTER_TYPE_UNKNOWN == iType )
			return false;
		
		fuPrepareDefault(trFilterLater, iType);
		GetDispFilter(trFilterOlder, trFilterLater);
		switch (iType)
		{
		case FILTER_TYPE_ASCII:
			ASCIMP ai = {0};
			ai = trFilterOlder.ASCIMP;
			///---Sim 05-24-2007 FIX_HEADER_LINE_ON_CONVERT_FILTER_75_TO_80
			/*
			///---Sim 01-04-2007 FIX_HEADER_LINE
			/// AW 05/21/07 FIX_ORIGIN75_FILTER_BUG
			//ai.iSubHeaderLines = ai.iHeaderLines;	// iHeaderLines in 8.0 means main lines(just be skipped)
			/// END FIX_ORIGIN75_FILTER_BUG
			ai.iHeaderLines = 0;
			///---END FIX_HEADER_LINE
			*/
			///---END FIX_HEADER_LINE_ON_CONVERT_FILTER_75_TO_80
			///---Sim 11-09-2007 FIX_CONV_FILTER_75_KNOWLEDGE_TO_80
			int nAllHeaderLines = ai.iHeaderLines + ai.iSubHeaderLines;
			if ( (ai.iSubHeaderLines < ai.iRenameCols ) && ( ai.iRenameCols <= nAllHeaderLines ) ) // out of range, extend Sub Header Lines
			{	
				int nExtendedLines = ai.iRenameCols - ai.iSubHeaderLines;
				
				ai.iHeaderLines -= nExtendedLines;
				ai.iSubHeaderLines += nExtendedLines;
				
				ai.iLabels += nExtendedLines;
			}
			///---END FIX_CONV_FILTER_75_KNOWLEDGE_TO_80
			/// Hong 8/04/06 FILL_CDELIMITERS_USE_75_FILTER
			//trFilterLater.ASCIMP = ai;
			switch(ai.iDelimiter)
			{
			case ASCIMP_DELIM_UNKNOWN:
				break;
			case ASCIMP_DELIM_COMMA:
				ai.cDelimiters[0] = ',';
				break;
			case ASCIMP_DELIM_TAB:
				ai.cDelimiters[0] = '\t';
				break;
			case ASCIMP_DELIM_SPACE:
				ai.cDelimiters[0] = ' ';
				break;
			case ASCIMP_DELIM_OTHER:
				ai.cDelimiters[0] = ai.cChar;
				break;
			}
			trFilterLater.ASCIMP = ai;
			/// end FILL_CDELIMITERS_USE_75_FILTER
			break;
		case FILTER_TYPE_BINARY:
			BINIMP bi = {0};
			bi = trFilterOlder.BINIMP;
			trFilterLater.BINIMP = bi;
			break;
		case FILTER_TYPE_USERDEFINED:
			//USERDEFIMP ud = {0};
			//ud = trFilterOlder.UserDefine;
			//trFilterLater.UserDefine = ud;
			/// Hong 04/16/07 FIX_FAIL_LOAD_75_USER_DEFINE_TYPE_FILTER
			if ( trFilterOlder.Common.OCFile && trFilterOlder.Common.OCFunction )
				fuSetUserDefinedFunction(trFilterLater, trFilterOlder.Common.OCFile.strVal, trFilterOlder.Common.OCFunction.strVal);
			//--- Jacky 08/05/10 ORG-521-P5 ADD_OLDERFILTER_NODE_FOR_NEWFILTER
			foreach(TreeNode trNode in trFilterOlder.Children)
			{
				string strTagName = trNode.tagName;
				if ( strTagName.CompareNoCase("Common") == 0 )
					continue;
				if ( strTagName.CompareNoCase("Type") == 0 )
					continue;
				trFilterLater.AddNode(trNode.Clone(),true);
			}
			//--- end ADD_OLDERFILTER_NODE_FOR_NEWFILTER
			/// end FIX_FAIL_LOAD_75_USER_DEFINE_TYPE_FILTER
			break;
		case FILTER_TYPE_XFUNC:
			XFIMP xf = {0};
			xf = trFilterOlder.XFunction;
			trFilterLater.XFunction = xf;
			if ( trFilterOlder.XFunction.Name )
				fuSetStr(trFilterLater, IDE_XFIMP_NAME, trFilterOlder.XFunction.Name.strVal);
			///---Sim 09-15-2006 MORE_NODE_IN_XFUNTION
			if ( trFilterOlder.Common.RenameWks )
				fuSetInt(trFilterLater, IDE_XFIMP_RENAMEWKS, trFilterOlder.Common.RenameWks.nVal);
			if ( trFilterOlder.Common.flags )
				fuSetInt(trFilterLater, IDE_XFIMP_FLAGS, trFilterOlder.Common.flags.nVal);
			if ( trFilterOlder.Common.ImportMode )
				fuSetInt(trFilterLater, IDE_XFIMP_IMPORTMODE, trFilterOlder.Common.ImportMode.nVal);
			///---END MORE_NODE_IN_XFUNTION
			break;
		}
		/// Hong 05/23/07 v8.0623 KEEP_ORIGIN_IMPORT_MODE
		int nMode = fuGetImportMode(trFilterLater);
		fuSet1stImportMode(trFilterLater, nMode);
		/// end KEEP_ORIGIN_IMPORT_MODE
		SettingFilterID(trFilterLater);
	}
	///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE
	//else if ( dVer < 8.0552 )
	else
	{
		if ( dVer < 8.0552 )
	///---END FIX_FILTER_CONVERT_ISSUE
		{
			// add auto rename options
			TreeNode trDISPIMP = trFilterLater.GetNode(IMPORT_FILTER_DISPIMP);
			//if( !trDISPIMP )
				//trDISPIMP = trFilterLater.AddNode(IMPORT_FILTER_DISPIMP);
			if ( !tree_get_node_by_id(trFilterLater, IDE_DISP_IMP_AUTO_RENAME, true) )
			{
				
				FILTER_ADD_NODE(trDISPIMP, IDE_DISP_IMP_AUTO_RENAME, "bAutoRename");
				fuSetInt(trDISPIMP, IDE_DISP_IMP_AUTO_RENAME, false);
			}
			
			if ( fuGetType(trFilterLater) == FILTER_TYPE_XFUNC )
			{
				TreeNode trXFIMP = trFilterLater.GetNode(IMPORT_FILTER_XFIMP);
				//if( !trXFIMP )
					//trXFIMP = trFilterLater.AddNode(IMPORT_FILTER_XFIMP);
				if ( !tree_get_node_by_id(trFilterLater, IDE_XFIMP_FILENAME2WKBK, true) )
				{
					
					FILTER_ADD_NODE(trXFIMP, IDE_XFIMP_FILENAME2WKBK, "iRenameWkBk");
					fuSetInt(trXFIMP, IDE_XFIMP_FILENAME2WKBK, 0);
				}
				if ( !tree_get_node_by_id(trFilterLater, IDE_XFIMP_ADDPATH4WKBK, true) )
				{
					
					FILTER_ADD_NODE(trXFIMP, IDE_XFIMP_ADDPATH4WKBK, "iIncludePathForWkBk");
					fuSetInt(trXFIMP, IDE_XFIMP_ADDPATH4WKBK, 0);
				}
				if ( !tree_get_node_by_id(trFilterLater, IDE_XFIMP_FILENAME2WKBKCOMMENT, true) )
				{
					
					FILTER_ADD_NODE(trXFIMP, IDE_XFIMP_FILENAME2WKBKCOMMENT, "iAppendWkBkComm");
					fuSetInt(trXFIMP, IDE_XFIMP_FILENAME2WKBKCOMMENT, 0);
				}
				if ( !tree_get_node_by_id(trFilterLater, IDE_XFIMP_FILENAME2COLCOMMENT, true) )
				{
					
					FILTER_ADD_NODE(trXFIMP, IDE_XFIMP_FILENAME2COLCOMMENT, "iAppendColComm");
					fuSetInt(trXFIMP, IDE_XFIMP_FILENAME2COLCOMMENT, 0);
				}
				if ( !tree_get_node_by_id(trFilterLater, IDE_XFIMP_ADDPATH, true) )
				{
					
					FILTER_ADD_NODE(trXFIMP, IDE_XFIMP_ADDPATH, "iIncludePath");
					fuSetInt(trXFIMP, IDE_XFIMP_ADDPATH, 0);
				}
				if ( !tree_get_node_by_id(trFilterLater, IDE_XFIMP_REMOVE_QUOTES, true) )
				{
					
					FILTER_ADD_NODE(trXFIMP, IDE_XFIMP_REMOVE_QUOTES, "iRemoveQuotes");
					fuSetInt(trXFIMP, IDE_XFIMP_REMOVE_QUOTES, 0);
				}
			}		
			dVer = 8.0552; ///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE
		}
		/// Hong 01/23/08 QA80-10541 FIX_IMPORT_FILTER_ISSUE_CAUSED_BY_FILTER_CONVERT
		///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE
		//else if ( dVer < 8.0602 ) // no sure if this version number is really correct, but works for all build-in filters
		if ( dVer < 8.0602 ) // no sure if this version number is really correct, but works for all build-in filters
		///---END FIX_FILTER_CONVERT_ISSUE
		{
			TreeNode trDISPIMP = trFilterLater.GetNode(IMPORT_FILTER_DISPIMP);
	
			if ( !tree_get_node_by_id(trFilterLater, IDE_DISPIMP_SHOWFILTERINOPENLIST, true) )
			{
				
				FILTER_ADD_NODE(trDISPIMP, IDE_DISPIMP_SHOWFILTERINOPENLIST, "bAddToFileOpen");
				fuSetInt(trDISPIMP, IDE_DISPIMP_SHOWFILTERINOPENLIST, false);
			}
			
			if ( !tree_get_node_by_id(trFilterLater, IDE_DISPIMP_1STMODE, true) )
			{
				
				FILTER_ADD_NODE(trDISPIMP, IDE_DISPIMP_1STMODE, "i1stMode");
				fuSet1stImportMode(trDISPIMP, ASCIMP_MODE_REPLACE_DATA);
			}
			dVer = 8.0602; ///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE
		}	
		/// end FIX_IMPORT_FILTER_ISSUE_CAUSED_BY_FILTER_CONVERT
		///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE
		//else if ( dVer < 8.0814 ) // no sure if this version number is really correct, but works for all build-in filters
		if ( dVer < 8.0814 ) // no sure if this version number is really correct, but works for all build-in filters
		///---END FIX_FILTER_CONVERT_ISSUE
		{
			if ( fuGetType(trFilterLater) == FILTER_TYPE_XFUNC )
			{
				TreeNode trXFIMP = trFilterLater.GetNode(IMPORT_FILTER_XFIMP);
				if ( !tree_get_node_by_id(trFilterLater, IDE_XFIMP_WKBKLNONLY, true) )
				{
					FILTER_ADD_NODE(trXFIMP, IDE_XFIMP_WKBKLNONLY, "iRenameWkBkLongNameOnly");
					///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE support 80 SR0,SR1
					//fuSetInt(trXFIMP, IDE_XFIMP_WKBKLNONLY, 0);
					fuSetInt(trXFIMP, IDE_XFIMP_WKBKLNONLY, 1);
					///---END FIX_FILTER_CONVERT_ISSUE
				}
			}
			///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE support 80 SR0,SR1
			else
			{
				fuSetRenameBookLongNameOnly(trFilterLater, 1);
			}
			///---END FIX_FILTER_CONVERT_ISSUE
			dVer = 8.0814; ///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE
		}
		///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
		if ( dVer < 8.0918 )
		{
			if ( tree_get_node_by_id(trFilterLater, IDE_VARIMP_VARIABLES_NODE, true) )
			{
				fuSetVarInUDL(trFilterLater, FALSE);
			}
			dVer = 8.0918; ///---Sim 10-31-2008 FIX_FILTER_CONVERT_ISSUE
		}
		/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
		/// Hong 11/11/08 v8.0968c FIX_RENAME_TRIM_OPTION_FAIL_WORK_WHEN_SAVING
		if ( dVer < 8.0969 )
		{
			TreeNode trDISPIMP = trFilterLater.GetNode(IMPORT_FILTER_DISPIMP);
			ASSERT(trDISPIMP);
			if ( !tree_get_node_by_id(trFilterLater, IDE_DISP_IMP_SPARKLINES, true) )
			{				
				FILTER_ADD_NODE(trDISPIMP, IDE_DISP_IMP_SPARKLINES, "nSparklines");
				fuSetInt(trDISPIMP, IDE_DISP_IMP_SPARKLINES, SPARKLINE_ADD_IF_LESS_THAN_50_COLS);
			}			
			if ( !tree_get_node_by_id(trFilterLater, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, true) )
			{				
				FILTER_ADD_NODE(trDISPIMP, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, "iWksTrimFNameFrom");
				fuSetInt(trDISPIMP, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, 1);
			}
			if ( !tree_get_node_by_id(trFilterLater, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, true) )
			{				
				FILTER_ADD_NODE(trDISPIMP, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, "iWksTrimFNameTo");
				fuSetInt(trDISPIMP, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, 0);
			}
			if ( !tree_get_node_by_id(trFilterLater, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, true) )
			{				
				FILTER_ADD_NODE(trDISPIMP, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, "iWkBkTrimFNameFrom");
				fuSetInt(trDISPIMP, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, 1);
			}
			if ( !tree_get_node_by_id(trFilterLater, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, true) )
			{				
				FILTER_ADD_NODE(trDISPIMP, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, "iWkBkTrimFNameTo");
				fuSetInt(trDISPIMP, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, 0);
			}
			
			dVer = 8.0969;
		}
		/// end FIX_RENAME_TRIM_OPTION_FAIL_WORK_WHEN_SAVING
		///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
		if ( dVer < 8.0976 )
		{
			TreeNode trDISPIMP = trFilterLater.GetNode(IMPORT_FILTER_DISPIMP);
			ASSERT(trDISPIMP);
			if ( !tree_get_node_by_id(trFilterLater, IDE_DISP_IMP_AUTOSIZE, true) )
			{				
				FILTER_ADD_NODE(trDISPIMP, IDE_DISP_IMP_AUTOSIZE, "nAutoSize");
				fuSetInt(trDISPIMP, IDE_DISP_IMP_AUTOSIZE, FILTER_AUTO_SIZE_WIDTH);
			}			
			
			dVer = 8.0976;
		}
		///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	} ///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE
	///---END FIX_FILTER_CONVERSION
	
	fuSetOriginVersion(trFilterLater); // must to set to avoid convert twice. ///---Sim 02-29-2008 FIX_FILTER_CONVERT_ISSUE
	
	return true;
}

/// end CONVERT_75_FILTER_TO_80


// filter_utils

/// Hong 08/15/07 v8.0682 ROLLBACK_CODE_TO_CENTRALIZE_CODE --don't know why need duplicate version here
// Include definitions of all localized strings. $ causes CodeBuilder to look for 
// correct version of Local.h depending on Windows Regional settings.
//#include "$Local.h"  //CPY 8/15/2007 Local.h no longer used
//#define FILTER_LOCATION_PREFIX _L("Data Folder|Origin Folder|User Files Folder")
#define FILTER_LOCATION_PREFIX _L("Data Folder|Origin Folder|User Files Folder|Group Folder") /// Hong 08/16/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
/// end ROLLBACK_CODE_TO_CENTRALIZE_CODE

#define FILTER_HEADERPARAM_DEFINED		"Defined"

BOOL fuIsApplicable(LPCSTR lpcszFilterFile, LPCSTR lpcszDataFile, int iFilterType)
{
	Tree trFilter(lpcszFilterFile);
	if( trFilter )
		return fuIsApplicable(trFilter, lpcszDataFile, iFilterType);
	return FALSE;
}

BOOL fuIsApplicable(TreeNode &trFilter, LPCSTR lpcszDataFile, int iFilterType)
{
	if( IS_FILTER_TYPE(iFilterType) )
		if( iFilterType != trFilter.Type.nVal )// Hong 9/04/06 SUPPORT_ORIGIN75_FILTER
		///---add code here to support .75 filter can convert it to .80 filter
		//if( iFilterType != fuGetType(trFilter) )//Hong 8/31/06 GET_FILTER_BY_ID	
			return FALSE;

	if( NULL == lpcszDataFile )
		return TRUE; // no file name to compare

	string strDataFile = GetFileName(lpcszDataFile);
	if( strDataFile.IsEmpty() )
		return TRUE; // no file name to compare

	if( strDataFile.Find('.') == -1 ) // if no extension
		strDataFile += '.';

	/// Hong 9/04/06 SUPPORT_ORIGIN75_FILTER
	//string strFileSpecs = fuGetApplicability(trFilter);
	string strFileSpecs;
	/// Hong 9/12/06 GET_FILTER_BY_ID
	//double dVersion = trFilter.OriginVersion.dVal;
	//if(dVersion > 8.0473)
	if(fuGetOriginVersion(trFilter) > 8.0473)
	/// end GET_FILTER_BY_ID
		strFileSpecs = fuGetApplicability(trFilter);
	else
		strFileSpecs = trFilter.Common.FileSpec.strVal;
	/// end SUPPORT_ORIGIN75_FILTER
	
	
	StringArray saFileSpec;
	strFileSpecs.GetTokens(saFileSpec, ';');

	for( int n = 0; n < saFileSpec.GetSize(); n++ )
	{
		if( strDataFile.Match(saFileSpec[n]) )
			return TRUE;
	}
	return FALSE;
}

//------------------------------------------------------------
void fuGetFilterFiles(StringArray& sarrFilterFiles, LPCSTR lpcszFolderPath, LPCSTR lpcszDataFile, int iFilterType)
{
	sarrFilterFiles.SetSize(0);
	fuAppendFilterFiles(sarrFilterFiles, lpcszFolderPath, lpcszDataFile, iFilterType);
}

void fuAppendFilterFiles(StringArray& sarrFilterFiles, LPCSTR lpcszFolderPath, LPCSTR lpcszDataFile, int iFilterType)
{
	string strFileNames;
	GetFilenamesInFolder(strFileNames, lpcszFolderPath, IMPORT_FILTER_EXTENSION_WILD, FALSE);
	if( strFileNames.IsEmpty() )
		return;

	StringArray sarrFilterFileNames;
	strFileNames.GetTokens(sarrFilterFileNames, '|');

	string strApplicability;
	if( lpcszDataFile )
		strApplicability = GetFileName(lpcszDataFile);
	
	if( strApplicability.IsEmpty() && FILTER_TYPE_IGNORE == iFilterType )
	{
		///sarrFilterFiles = sarrFilterFileNames;
		//sarrFilterFiles.Append(sarrFilterFileNames);
		for( int iFile = 0; iFile < sarrFilterFileNames.GetSize(); iFile++ )
			sarrFilterFiles.Add(sarrFilterFileNames[iFile]);
		return;
	}

	for( int iFile = 0; iFile < sarrFilterFileNames.GetSize(); iFile++ )
	{
		if( fuIsApplicable(sarrFilterFileNames[iFile], strApplicability, iFilterType) )
			sarrFilterFiles.Add(sarrFilterFileNames[iFile]);
	}
}

void fuGetFilterFiles(StringArray &saFilterFiles, int iFilterType, LPCSTR lpcszDataFile)
{
	saFilterFiles.SetSize(0);

	string strDataPath = GetFilePath(lpcszDataFile);
	if( !strDataPath.IsEmpty() )
		fuAppendFilterFiles(saFilterFiles, strDataPath, lpcszDataFile, iFilterType);

	string strUserPath;
	strUserPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
	if( strUserPath != strDataPath )
		fuAppendFilterFiles(saFilterFiles, strUserPath, lpcszDataFile, iFilterType);

	string strExePath;
	strExePath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
	if( strExePath != strDataPath && strExePath != strUserPath )
		fuAppendFilterFiles(saFilterFiles, strExePath, lpcszDataFile, iFilterType);
	
	/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	string strGroupPath;
	/// Hong 09/27/07 v8.0709 GROUP_PATH_CAN_BE_EMPTY
	//strGroupPath.Format("%s%s", okutil_get_origin_path(ORIGIN_PATH_GROUP), FILTERS_FOLDER_NAME);
	strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP);
	if ( !strGroupPath.IsEmpty() )
	{
		strGroupPath += FILTERS_FOLDER_NAME;
	/// end GROUP_PATH_CAN_BE_EMPTY
		if( strGroupPath != strDataPath && strGroupPath != strExePath && strGroupPath != strUserPath )
			fuAppendFilterFiles(saFilterFiles, strGroupPath, lpcszDataFile, iFilterType);
	}
	/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
}

void fuGetFilterList(StringArray &saFilterList, StringArray &saFilterFiles)
{
	int iPath;
	string str;
	string strLocPrefix(FILTER_LOCATION_PREFIX);
	
	string strUserPath;
	strUserPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
	
	string strOriginPath;
	strOriginPath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
	
	/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	string strGroupPath;
	strGroupPath.Format("%s%s", okutil_get_origin_path(ORIGIN_PATH_GROUP), FILTERS_FOLDER_NAME);
	/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP

	saFilterList.SetSize(0);
	for( int i = 0; i < saFilterFiles.GetSize(); i++ )
	{
		if( 0 == strOriginPath.CompareNoCase(GetFilePath(saFilterFiles[i])) )
			iPath = FILTER_PATH_ORIGIN;
		else if( 0 == strUserPath.CompareNoCase(GetFilePath(saFilterFiles[i])) )
			iPath = FILTER_PATH_USER;
		/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
		else if( 0 == strGroupPath.CompareNoCase(GetFilePath(saFilterFiles[i])) )
			iPath = FILTER_PATH_GROUP;
		/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
		else // Data
			iPath = FILTER_PATH_DATA;
		str.Format("%s: %s", strLocPrefix.GetToken(iPath, '|'), GetFileName(saFilterFiles[i], TRUE));
		saFilterList.Add(str);
	}
}

///------ Folger 04/30/09 SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL
void fuGetFilterListForImportWizard(StringArray &saFilterList, int iFilterType/* = FILTER_TYPE_IGNORE*/, LPCSTR lpcszDataFile/* = NULL*/, bool bAddPageFilter/* = false*/, vector<string>* pvsFilterFiles/* = NULL*/)
{
	StringArray saFilterFiles;
	fuGetFilterFiles(saFilterFiles, iFilterType, lpcszDataFile);
	
	fuGetFilterList(saFilterList, saFilterFiles);
	
	if( bAddPageFilter )
	{
		saFilterList.InsertAt(0, SZ_IW_PAGE_FILTER);
		saFilterFiles.InsertAt(0, SZ_IW_PAGE_FILTER);
	}
	
	saFilterList.InsertAt(0, SZ_IW_NONE);
	saFilterFiles.InsertAt(0, SZ_IW_NONE);
	
	if ( NULL != pvsFilterFiles )
		*pvsFilterFiles = saFilterFiles;
}
///------ End SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL

BOOL fuGetFilterFileNameFromListItem(LPCSTR lpcszFilterListItem, String &strFileName, LPCSTR lpcszDataPath)
{
	string str = lpcszFilterListItem;
	int i = str.Find(':');
	if( i < 1 )
		return FALSE;
	
	string strItemPrefix = str.Left(i); // everything before the colon
	string strItemName = str.Mid(i + 2); // everything after the colon and space
	
	string strPrefixes(FILTER_LOCATION_PREFIX);
	int iTokens = strPrefixes.GetNumTokens('|');
	for( i = 0; i < iTokens; i++ )
	{
		str = strPrefixes.GetToken(i, '|');
		if( 0 == str.CompareNoCase(strItemPrefix) )
			break;
	}
	if( !IS_FILTER_PATH_ID(i) )
		return FALSE;

	switch( i )
	{
	case FILTER_PATH_USER:
		str = GetAppPath() + FILTERS_FOLDER_NAME;
		break;
	case FILTER_PATH_ORIGIN:
		str = GetAppPath(TRUE) + FILTERS_FOLDER_NAME;
		break;
	/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	case FILTER_PATH_GROUP:
		str = okutil_get_origin_path(ORIGIN_PATH_GROUP) + FILTERS_FOLDER_NAME;
		break;
	/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	default: // Data path
		if( lpcszDataPath )
			str = lpcszDataPath;
		else
			str.Empty();
		break;
	}
	strFileName.Format("%s%s.%s", str, strItemName, IMPORT_FILTER_EXTENSION);
	return TRUE;
}

//--------------------------------------------------------------------------


/// EJP 2006-02-28 v8.0369 MOVE_OC_FILTER_UTILS_TO_VC
#ifdef MOVE_OC_FILTER_UTILS_TO_VC
//--------------------------------------------------------------------------
int fuGetTargetPageType(TreeNode& trFilter)
{
	/*
	int iType;
	if( trFilter.Common.TargetWindowType )
	{
		iType = trFilter.Common.TargetWindowType.nVal;
		if( EXIST_WKS != iType && EXIST_MATRIX != iType )
			iType = EXIST_WKS;
	}
	else
		iType = EXIST_WKS;
	return iType;
	*/
	///---Sim 09-04-2006 GET_FILTER_BY_ID
	//int iTargetWndType = tree_node_get_int(trFilter.Common.TargetWindowType, EXIST_NONE);
	int iTargetWndType = fuGetInt(trFilter, IDE_DISP_IMP_PAGETYPE, EXIST_NONE);
	///---END GET_FILTER_BY_ID
	if( EXIST_NONE == iTargetWndType )
	{
		int iFilterType = fuGetType(trFilter);
		if( FILTER_TYPE_ASCII == iFilterType || FILTER_TYPE_BINARY == iFilterType )
			iTargetWndType = EXIST_WKS;
	}
	return iTargetWndType;
}

BOOL fuIsTargetPageType(TreeNode& trFilter, int iPageType)
{
	return (iPageType == fuGetTargetPageType(trFilter));
}

BOOL fuGetTargetWindow(TreeNode& trFilter, int& iType, string& strTemplate)
{
	iType = fuGetTargetPageType(trFilter);

	///---Sim 09-04-2006 GET_FILTER_BY_ID
	//if( trFilter.Common.TargetWindowTemplate )
		//strTemplate = trFilter.Common.TargetWindowTemplate.strVal;
	//else
	///*
	//{
		//string strType;
		//if( EXIST_MATRIX == iType )
			//strType = "System.Matrix.DefTemplate$";
		//else
			//strType = "System.Wks.DefTemplate$";
		//char szDefTemplate[NAME_SIZE];
		//if( !LT_get_str(strType, szDefTemplate, NAME_SIZE) )
			//lstrcpy(szDefTemplate, "Origin");
		//strTemplate = szDefTemplate;
	//}
	//*/
		//strTemplate.Empty();
	strTemplate = fuGetStr(trFilter, IDE_DISP_IMP_PAGETEMPLATE, "");
	///---END GET_FILTER_BY_ID
	return TRUE;
}

BOOL fuSetTargetWindow(TreeNode& trFilter, int iType, LPCSTR lpcszTemplate)
{
	///---Sim 09-04-2006 GET_FILTER_BY_ID
	//trFilter.Common.TargetWindowType.nVal = iType;
	fuSetInt(trFilter, IDE_DISP_IMP_PAGETYPE, iType);
	string strTemplate;
	if( lpcszTemplate )
		strTemplate = lpcszTemplate;
	//trFilter.Common.TargetWindowTemplate.strVal = strTemplate;
	fuSetStr(trFilter, IDE_DISP_IMP_PAGETEMPLATE, strTemplate);
	///---END GET_FILTER_BY_ID
	return TRUE;
}
#endif // MOVE_OC_FILTER_UTILS_TO_VC
/// end MOVE_OC_FILTER_UTILS_TO_VC

Page fuCreateTargetPage(TreeNode& trFilter, int iOption)
{
	int iType;
	string strTemplate;
	iType = fuGetTargetPage(trFilter, strTemplate);
	
	Page pgTarget;
	if( EXIST_MATRIX == iType )
	{
		MatrixPage pgMat;
		if( strTemplate.IsEmpty() )
			strTemplate = LabTalk.System.Matrix.DefTemplate$;
		pgMat.Create(strTemplate, iOption);
		pgTarget = pgMat;
	}
	else if( EXIST_WKS == iType )
	{
		WorksheetPage pgWks;
		if( strTemplate.IsEmpty() )
			strTemplate = LabTalk.System.Wks.DefTemplate$;
		pgWks.Create(strTemplate, iOption);
		pgTarget = pgWks;
	}
	return pgTarget;
}

/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
BOOL fuGetAddRoot(TreeNode& trFilter, TreeNode& trAddsRoot)
{
	if(!trFilter)
		return FALSE;
	
	FILTER_ADD_NODE(trFilter, IDE_ADDIMP_ADDITIONAL_NODE, "Additional");
	trAddsRoot = tree_get_node_by_id(trFilter, IDE_ADDIMP_ADDITIONAL_NODE, true);
	
	return TRUE;
}

BOOL fuSetRenameWksVarName(TreeNode &trFilter, LPCSTR lpcszVarName)
{
	TreeNode tnAdds;
	if( !fuGetAddRoot(trFilter, tnAdds) )
		return FALSE;
	
	FILTER_ADD_NODE(tnAdds, IDE_ADDIMP_RENAMEWKSVARNAME, "RenameWksVarName");
	fuSetStr(tnAdds, IDE_ADDIMP_RENAMEWKSVARNAME, lpcszVarName);

	return TRUE;
}

BOOL fuGetRenameWksVarName(TreeNode &trFilter, string& strVarName)
{
	return fuGetRStr(trFilter, IDE_ADDIMP_RENAMEWKSVARNAME, strVarName)
}
/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
BOOL fuSetRenameWkbkVarName(TreeNode &trFilter, LPCSTR lpcszVarName)
{
	TreeNode tnAdds;
	if( !fuGetAddRoot(trFilter, tnAdds) )
		return FALSE;
	
	FILTER_ADD_NODE(tnAdds, IDE_ADDIMP_RENAMEWKBKVARNAME, "RenameWkbkVarName");
	fuSetStr(tnAdds, IDE_ADDIMP_RENAMEWKBKVARNAME, lpcszVarName);

	return TRUE;
}

BOOL fuGetRenameWkbkVarName(TreeNode &trFilter, string& strVarName)
{
	return fuGetRStr(trFilter, IDE_ADDIMP_RENAMEWKBKVARNAME, strVarName)
}
///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF

//--------------------------------------------------------------------------
///---Sim 08-30-2006 GET_FILTER_BY_ID
int fuGetDragDropGraph(TreeNode &trFilter)
{
	//if( trFilter.Common.DragAndDrop.Graph )
	//{
		//if( IS_FILTER_DDGRAPH(trFilter.Common.DragAndDrop.Graph.nVal) )
			//return trFilter.Common.DragAndDrop.Graph.nVal;
	//}
	//return FILTER_DDGRAPH_OPENONLY;
	int iMode = fuGetInt(trFilter, IDE_DNDIMP_GRAPH, FILTER_DDGRAPH_OPENONLY);
	if ( !IS_FILTER_DDGRAPH(iMode) )
		iMode = FILTER_DDGRAPH_OPENONLY;
	return iMode;
}

void fuSetDragDropGraph(TreeNode& trFilter, int iMode)
{
	if( !IS_FILTER_DDGRAPH(iMode) )
		iMode = FILTER_DDGRAPH_OPENONLY;
	//trFilter.Common.DragAndDrop.Graph.nVal = iMode;
	///---Sim 09-15-2006 ADD_DRAG_AND_DROP_NODE_INTO_FILTER
	FILTER_ADD_NODE(trFilter.GetNode(IMPORT_FILTER_DISPIMP), IDE_DNDIMP_NODE, "DragAndDrop");
	FILTER_ADD_NODE(trFilter.GetNode(IMPORT_FILTER_DISPIMP).DragAndDrop, IDE_DNDIMP_GRAPH, "Graph");
	///---END ADD_DRAG_AND_DROP_NODE_INTO_FILTER
	fuSetInt(trFilter, IDE_DNDIMP_GRAPH, iMode);
}

int fuGetDragDropWorkspace(TreeNode &trFilter)
{
	//if( trFilter.Common.DragAndDrop.Workspace )
	//{
		//if( IS_FILTER_DDWORKSPACE(trFilter.Common.DragAndDrop.Workspace.nVal) )
			//return trFilter.Common.DragAndDrop.Workspace.nVal;
	//}
	//return FILTER_DDWORKSPACE_OPENONLY;
	int iMode = fuGetInt(trFilter, IDE_DNDIMP_WORKSPACE, FILTER_DDWORKSPACE_OPENONLY);
	if ( !IS_FILTER_DDWORKSPACE(iMode) )
		iMode = FILTER_DDWORKSPACE_OPENONLY;
	return iMode;
}

void fuSetDragDropWorkspace(TreeNode& trFilter, int iMode)
{
	if( !IS_FILTER_DDWORKSPACE(iMode) )
		iMode = FILTER_DDWORKSPACE_OPENONLY;
	//trFilter.Common.DragAndDrop.Workspace.nVal = iMode;
	///---Sim 09-15-2006 ADD_DRAG_AND_DROP_NODE_INTO_FILTER
	FILTER_ADD_NODE(trFilter.GetNode(IMPORT_FILTER_DISPIMP), IDE_DNDIMP_NODE, "DragAndDrop");
	FILTER_ADD_NODE(trFilter.GetNode(IMPORT_FILTER_DISPIMP).DragAndDrop, IDE_DNDIMP_WORKSPACE, "Workspace");
	///---END ADD_DRAG_AND_DROP_NODE_INTO_FILTER
	fuSetInt(trFilter, IDE_DNDIMP_WORKSPACE, iMode);
}
///---END GET_FILTER_BY_ID


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
/// EJP 11-03-2004 v8.0159 QA70-6554 EXTRACT_VARS_FROM_FILENAME
BOOL fuGetHdrLines(TreeNode& tnFilter, StringArray& saHdrLines, LPCSTR lpcszFileName)
{
	ASCIMP ai;
	if( !fuGetASCIMP(tnFilter, ai) )
		return FALSE;
	if( 0 == ReadFileLines(saHdrLines, lpcszFileName, (ai.iHeaderLines + ai.iSubHeaderLines)) )
		return TRUE;
	return FALSE;
}
/// end EXTRACT_VARS_FROM_FILENAME

BOOL fuGetExtractVarOCFunc(TreeNode& tnFilter, String& strFileName, String& strFuncName)
{
	///---Sim 09-05-2006 GET_FILTER_BY_ID
	/*
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	if( !tnVars.OCFileName || !tnVars.OCFunctionName )
		return FALSE;
	strFileName = tnVars.OCFileName.strVal;
	strFuncName = tnVars.OCFunctionName.strVal;
	return TRUE;
	*/
	return ( fuGetRStr(tnFilter, IDE_VARIMP_OCFILENAME, strFileName) 
			&& fuGetRStr(tnFilter, IDE_VARIMP_OCFUNCNAME, strFuncName) );
	///---END GET_FILTER_BY_ID
}

BOOL fuSetExtractVarOCFunc(TreeNode& tnFilter, LPCSTR lpcszFileName, LPCSTR lpcszFuncName)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	///---Sim 09-05-2006 GET_FILTER_BY_ID
	//tnVars.OCFileName.strVal = lpcszFileName;
	//tnVars.OCFunctionName.strVal = lpcszFuncName;
	FILTER_ADD_NODE(tnVars, IDE_VARIMP_OCFILENAME, "OCFileName");
	FILTER_ADD_NODE(tnVars, IDE_VARIMP_OCFUNCNAME, "OCFunctionName");
	fuSetStr(tnVars, IDE_VARIMP_OCFILENAME, lpcszFileName);
	fuSetStr(tnVars, IDE_VARIMP_OCFUNCNAME, lpcszFuncName);
	///---END GET_FILTER_BY_ID
	return TRUE;
}

PFNHDRVARFUNC fuGetExtractVarOCFuncPtr(TreeNode& tnFilter)
{
	string strOCFunc, strOCFile;
	if( !fuGetExtractVarOCFunc(tnFilter, strOCFile, strOCFunc) )
		return NULL;
	PFNHDRVARFUNC pfn = Project.FindFunction(strOCFunc, strOCFile, TRUE);
	return pfn;
}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
BOOL fuAddHdrVar(TreeNode& tnFilter, TreeNode& tnVar)
{
	TreeNode tnVars;
	if( fuGetVars(tnFilter, tnVars) )
		return tnVars.AddNode(tnVar);
	return FALSE;
}

BOOL fuDelHdrVar(TreeNode& tnFilter, int nIndex)
{
	TreeNode tnVars;
	if( fuGetVars(tnFilter, tnVars) )
	{
		int nNode = 0;
		foreach( TreeNode tn in tnVars.Children )
		{
			if( nNode == nIndex )
				return tnVars.RemoveChild(tn);
			nNode++;
		}
	}
	return FALSE;
}

BOOL fuGetVar(TreeNode& tnFilter, TreeNode& tnVar, int nIndex)
{
	TreeNode tnVars;
	if( fuGetVars(tnFilter, tnVars) )
	{
		int nNode = 0;
		foreach( TreeNode tn in tnVars.Children )
		{
			if( nNode == nIndex )
			{
				tnVar = tn;
				return TRUE;
			}
			nNode++;
		}
	}
	return FALSE;
}

BOOL fuGetVars(TreeNode& tnFilter, TreeNode& tnVars)
{
	TreeNode tnVarsRoot;
	if( !fuGetVarsRoot(tnFilter, tnVarsRoot) )
		return FALSE;
	///---Sim 09-05-2006 GET_FILTER_BY_ID
	//if( !tnVarsRoot.Vars )
		//tnVarsRoot.AddNode("Vars");
	//tnVars = tnVarsRoot.Vars;
	FILTER_ADD_NODE(tnVarsRoot, IDE_VARIMP_VARS_NODE, "Vars");
	tnVars = tree_get_node_by_id(tnVarsRoot, IDE_VARIMP_VARS_NODE, true);
	///---END GET_FILTER_BY_ID
	return TRUE;
}

BOOL fuRemoveHeaderParams(TreeNode &trFilter)
{
	///---Sim 09-04-2006 GET_FILTER_BY_ID
	//return trFilter.Common.HeaderParameters.Remove();
	/// Hong 03/27/07 v8.0590 FIX_DUPLICATE_VARIABLE_BY_LAOD_FIILTER
	//TreeNode tn = tree_get_node_by_id(trFilter, IDE_PARAMSIMP_HEADERPARAMETERS_NODE);
	TreeNode tn = tree_get_node_by_id(trFilter, IDE_PARAMSIMP_HEADERPARAMETERS_NODE, true);
	/// end FIX_DUPLICATE_VARIABLE_BY_LAOD_FIILTER
	return tn.Remove();
	///---END GET_FILTER_BY_ID
}

void fuSetHeaderParamDefined(TreeNode &trFilter, int nVal)
{
	TreeNode trAllParams = fuGetHeaderParams(trFilter);
	if( !trAllParams )
		return;
	trAllParams.SetAttribute(FILTER_HEADERPARAM_DEFINED, nVal);
}

TreeNode fuGetHeaderParam(TreeNode &trFilter, LPCSTR lpcszName)
{
	TreeNode trParam;
	TreeNode trAllParams = fuGetHeaderParams(trFilter);
	if( !trAllParams )
		return trParam;
	string str(lpcszName);
	foreach(trParam in trAllParams.Children)
	{
		///---Sim 09-05-2006 GET_FILTER_BY_ID
		//if( trParam.Name && 0 == str.Compare(trParam.Name.strVal) )
		if( fuGetStr(trParam, IDE_PARAMSIMP_NAME, "") == str )
		///---END GET_FILTER_BY_ID
			return trParam;
	}
	return trParam;
}

bool fuGetHeaderParamNames(TreeNode &trFilter, StringArray &saNames)
{
	TreeNode trAllParams = fuGetHeaderParams(trFilter);
	if( !trAllParams )
		return false;
	TreeNode trParam;
	foreach(trParam in trAllParams.Children)
	{
		///---Sim 09-05-2006 GET_FILTER_BY_ID
		//if( trParam.Name )
			//saNames.Add(trParam.Name.strVal);
		string str;
		if ( fuGetRStr(trParam, IDE_PARAMSIMP_NAME, str) )
			saNames.Add(str);
		///---END GET_FILTER_BY_ID
	}
	return true;
}

//--------------------------------------------------------------------------
// fuAddHeaderParam
//
// Do not call this function directly.
// Use fuAddASCHeaderParam or fuAddBinHeaderParam macros.
//--------------------------------------------------------------------------
bool fuAddHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int nType, int n1, int n2, int n3)
{
	TreeNode trAllParams = fuGetHeaderParams(trFilter);
	if( !trAllParams )
		return false;
	
	string str;
	str.Format("P%d", trAllParams.GetNodeCount());
	TreeNode trParam = trAllParams.AddNode(str);
	if( !trParam )
		return false;

	///---Sim 09-05-2006 GET_FILTER_BY_ID
	//trParam.Name.strVal = lpcszName;
	//trParam.Type.nVal = nType;
	FILTER_ADD_NODE(trParam, IDE_PARAMSIMP_NAME, "Name");
	fuSetStr(trParam, IDE_PARAMSIMP_NAME, lpcszName);
	FILTER_ADD_NODE(trParam, IDE_PARAMSIMP_TYPE, "Type");
	fuSetInt(trParam, IDE_PARAMSIMP_TYPE, nType);
	//if( FILTER_TYPE_ASCII == trFilter.Type.nVal )
	/// Hong 11/16/09 QA80-14079-P5 FIX_BINARY_UINT_VARIABLE_FAIL_TO_WORK
	//if ( FILTER_TYPE_ASCII == nType )
	if ( FILTER_TYPE_ASCII == fuGetType(trFilter) )
	/// end FIX_BINARY_UINT_VARIABLE_FAIL_TO_WORK
	{
		//trParam.Line.nVal = n1;
		//trParam.Pos.nVal = n2;
		//trParam.End.nVal = n3;
		// need add structure
		FILTER_ADD_NODE(trParam, IDE_PARAMSIMP_LINE, "Line");
		FILTER_ADD_NODE(trParam, IDE_PARAMSIMP_POS, "Pos");
		FILTER_ADD_NODE(trParam, IDE_PARAMSIMP_END, "End");
		fuSetInt(trParam, IDE_PARAMSIMP_LINE, n1);
		fuSetInt(trParam, IDE_PARAMSIMP_POS, n2);
		fuSetInt(trParam, IDE_PARAMSIMP_END, n3);
	}
	else // FILTER_TYPE_BINARY
	{
		//trParam.Offset.nVal = n1;
		//trParam.Size.nVal = n2;
		// need add structure
		FILTER_ADD_NODE(trParam, IDE_PARAMSIMP_OFFSET, "Offset");
		FILTER_ADD_NODE(trParam, IDE_PARAMSIMP_SIZE, "Size");
		fuSetInt(trParam, IDE_PARAMSIMP_OFFSET, n1);
		fuSetInt(trParam, IDE_PARAMSIMP_SIZE, n2);
	}
	///---END GET_FILTER_BY_ID

	return true;
}

bool fuAddASCHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int nType, int nLine, int nPos, int nEnd)
{
	return fuAddHeaderParam(trFilter, lpcszName, nType, nLine, nPos, nEnd);
}

bool fuAddBinHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int nType, int nOffset, int nSize)
{
	return fuAddHeaderParam(trFilter, lpcszName, nType, nOffset, nSize);
}

bool fuGetHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int &nType, int &n1, int &n2, int &n3)
{
	TreeNode trParam = fuGetHeaderParam(trFilter, lpcszName);
	if( !trParam )
		return false;
	
	//nType = trParam.Type.nVal; ///---Sim 09-05-2006 NO_USE
	///---Sim 09-05-2006 GET_FILTER_BY_ID
	bool bRet = true;
	//if( FILTER_TYPE_ASCII == trFilter.Type.nVal )
	if( FILTER_TYPE_ASCII == fuGetType(trFilter) )//Hong 8/31/06 GET_FILTER_BY_ID
	{
		//if( !trParam.Line || !trParam.Pos || !trParam.End )
			//return false;
		//n1 = trParam.Line.nVal;
		//n2 = trParam.Pos.nVal;
		//n3 = trParam.End.nVal;
		bRet = fuGetRInt(trParam, IDE_PARAMSIMP_LINE, n1);
		bRet = fuGetRInt(trParam, IDE_PARAMSIMP_POS, n2) && bRet;
		bRet = fuGetRInt(trParam, IDE_PARAMSIMP_END, n3) && bRet;
	}
	else // FILTER_TYPE_BINARY
	{
		//if( !trParam.Offset || !trParam.Size )
			//return false;
		//n1 = trParam.Offset.nVal;
		//n2 = trParam.Size.nVal;
		bRet = fuGetRInt(trParam, IDE_PARAMSIMP_OFFSET, n1);
		bRet = fuGetRInt(trParam, IDE_PARAMSIMP_SIZE, n2) && bRet;
		bRet = fuGetRInt(trParam, IDE_PARAMSIMP_TYPE, nType) && bRet; // Hong 03/27/07 QA80-9542 v8.0590 FIX_BINERY_FAIL_GET_VARIBLE
		// n3 is not used
	}
	
	//return true;
	return bRet;
	///---END GET_FILTER_BY_ID
}

bool fuGetASCHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int &nType, int &nLine, int &nPos, int &nEnd)
{
	return fuGetHeaderParam(trFilter, lpcszName, nType, nLine, nPos, nEnd);
}

bool fuGetBinHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int &nType, int &nOffset, int &nSize)
{
	int n; // temp var for last arg
	return fuGetHeaderParam(trFilter, lpcszName, nType, nOffset, nSize, n);
}

bool fuGetHdrVarScan(TreeNode &trFilter, int &iFirstLine, int &iLastLine, int &iSeparator)
{
	TreeNode trParams = fuGetHeaderParams(trFilter);
	if( !trParams )
		return false;
	///---Sim 09-05-2006 GET_FILTER_BY_ID
	//if( !trParams.FirstLine || !trParams.LastLine || !trParams.Separator )
		//return false;
	//iFirstLine = trParams.FirstLine.nVal;
	//iLastLine = trParams.LastLine.nVal;
	//iSeparator = trParams.Separator.nVal;
	bool bRet = true;
	bRet = fuGetRInt(trParams, IDE_PARAMSIMP_FIRSTLINE, iFirstLine);
	bRet = fuGetRInt(trParams, IDE_PARAMSIMP_LASTLINE, iLastLine) && bRet;
	bRet = fuGetRInt(trParams, IDE_PARAMSIMP_SEPARATOR, iSeparator) && bRet;
	
	//return true;
	return bRet;
	///---END GET_FILTER_BY_ID
}

bool fuSetHdrVarScan(TreeNode &trFilter, int iFirstLine, int iLastLine, int iSeparator)
{
	TreeNode trParams = fuGetHeaderParams(trFilter);
	if( !trParams )
		return false;
	///---Sim 09-05-2006 GET_FILTER_BY_ID
	//trParams.FirstLine.nVal = iFirstLine;
	//trParams.LastLine.nVal = iLastLine;
	//trParams.Separator.nVal = iSeparator;
	// need add structure
	FILTER_ADD_NODE(trParams, IDE_PARAMSIMP_FIRSTLINE, "FirstLine");
	FILTER_ADD_NODE(trParams, IDE_PARAMSIMP_LASTLINE, "LastLine");
	FILTER_ADD_NODE(trParams, IDE_PARAMSIMP_SEPARATOR, "Separator");
	fuSetInt(trParams, IDE_PARAMSIMP_FIRSTLINE, iFirstLine);
	fuSetInt(trParams, IDE_PARAMSIMP_LASTLINE, iLastLine);
	fuSetInt(trParams, IDE_PARAMSIMP_SEPARATOR, iSeparator);
	///---END GET_FILTER_BY_ID
	return true;
}

bool fuGetHdrSave(TreeNode &trFilter, int &iFirstLine, int &iNumLines)
{
	///---Sim 09-04-2006 GET_FILTER_BY_ID
	/*
	if( !trFilter.Common.HdrSaveFirstLine || !trFilter.Common.HdrSaveNumLines )
		return false;
	iFirstLine = trFilter.Common.HdrSaveFirstLine.nVal;
	iNumLines = trFilter.Common.HdrSaveNumLines.nVal;
	return true;
	*/
	bool bRet1 = fuGetRInt(trFilter, IDE_HEADERIMP_SAVEFIRSTLINE, iFirstLine);
	bool bRet2 = fuGetRInt(trFilter, IDE_HEADERIMP_SAVENUMLINES, iNumLines);
	return ( bRet1 && bRet2 );
	///---END GET_FILTER_BY_ID
}

bool fuSetHdrSave(TreeNode &trFilter, int iFirstLine, int iNumLines)
{
	///---Sim 09-04-2006 GET_FILTER_BY_ID
	/*
	trFilter.Common.HdrSaveFirstLine.nVal = iFirstLine;
	trFilter.Common.HdrSaveNumLines.nVal = iNumLines;
	return true;
	*/
	bool bRet1 = fuSetInt(trFilter, IDE_HEADERIMP_SAVEFIRSTLINE, iFirstLine);
	bool bRet2 = fuSetInt(trFilter, IDE_HEADERIMP_SAVENUMLINES, iNumLines);
	return ( bRet1 && bRet2 );
	///---END GET_FILTER_BY_ID
}

//--------------------------------------------------------------------------
///---Sim 08-30-2006 GET_FILTER_BY_ID
bool fuGetFileSpec(TreeNode &trFilter, string &strFileSpec)
{
	//if( trFilter.Common.FileSpec )
		//strFileSpec = trFilter.Common.FileSpec.strVal;
	//else
		//strFileSpec.Empty();
	strFileSpec = fuGetStr(trFilter, IDE_DISP_IMP_FILESPEC, "");
	return true;
}
///---END GET_FILTER_BY_ID

/// Hong 9/25/06 FIX_SCRIPT_FAIL_TO_WORK_IN_IMPORTWIZARD
bool fuSetPostImportScript(TreeNode &trFilter, string strScript)
{
	///---Sim 06-06-2007 FIX_SCRIPT_MAY_CHANGE_PLACE
	/*
	if(!trFilter.GetNode(IMPORT_FILTER_DISPIMP))
		return false;
	///---Sim 03-20-2007 NEED_WAY_TO_CLEAR_SCRIPT
	/////---Sim 03-09-2007 NO_NEED_SAVE_TO_FILTER_IF_SCRIPT_IS_EMPTY
	//if ( strScript.IsEmpty() )
		//return true;
	/////---END NO_NEED_SAVE_TO_FILTER_IF_SCRIPT_IS_EMPTY
	///---END NEED_WAY_TO_CLEAR_SCRIPT
	FILTER_ADD_NODE(trFilter.GetNode(IMPORT_FILTER_DISPIMP), IDE_IMP_POSTIMPSCRIPT, "PostImportScript");
	*/
	if ( !tree_get_node_by_id(trFilter, IDE_IMP_POSTIMPSCRIPT) )
	{
		TreeNode tr = trFilter.GetNode(IMPORT_FILTER_DISPIMP);
		if ( !tr )
			tr = trFilter;
		FILTER_ADD_NODE(tr, IDE_IMP_POSTIMPSCRIPT, "PostImportScript");
	}
	///---END FIX_SCRIPT_MAY_CHANGE_PLACE
	fuSetStr(trFilter, IDE_IMP_POSTIMPSCRIPT, strScript);
	return true;
}
/// END FIX_SCRIPT_FAIL_TO_WORK_IN_IMPORTWIZARD

bool fuGetFilesOfTypeGroupName(TreeNode &trFilter, string &strName)
{
	if( trFilter.Common.GroupName )
		strName = trFilter.Common.GroupName.strVal;
	else
		strName.Empty();
	return true;
}

bool fuSetFilesOfTypeGroupName(TreeNode &trFilter, LPCSTR lpcstrName)
{
	trFilter.Common.GroupName.strVal = lpcstrName;
	return true;
}

bool fuGetFilesOfType(TreeNode &trFilter, StringArray &saFileSpecNames)
{
	if( trFilter &&	trFilter.Common && trFilter.Common.FilesOfType && trFilter.Common.FilesOfType.Names )
	{
		TreeNode trName = trFilter.Common.FilesOfType.Names.FirstNode;
		while( trName )
		{
			saFileSpecNames.Add(trName.strVal);
			trName = trName.NextNode;
		}
		return true;
	}
	return false;
}

bool fuSetFilesOfType(TreeNode &trFilter, StringArray &saFileSpecNames)
{
	trFilter.Common.FilesOfType.RemoveChild("Names");
	TreeNode trNames = trFilter.Common.FilesOfType.AddNode("Names");
	if( trNames )
	{
		string str;
		for( int i = 0; i < saFileSpecNames.GetSize(); i++ )
		{
			str.Format("Type%d", i);
			trNames.AddTextNode(saFileSpecNames[i], str);
		}
		return true;
	}
	return false;
}


//--------------------------------------------------------------------------
/// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
bool fuGetPageFilterName(string &strName, int iType)
{
	switch( iType )
	{
	case FILTER_TYPE_ASCII:
		strName += "ImportFilter_ASCII";
		break;
	case FILTER_TYPE_BINARY:
		strName += "ImportFilter_Binary";
		break;
	case FILTER_TYPE_USERDEFINED:
		strName += "ImportFilter_UserDefined";
		break;
	default:
		return false;
	}
	return true;
}

bool fuIsOneFilterInPage(Page &pgTarget, LPCSTR lpcszDataFile, int &iFilterType)
{
	int iType;
	int iCount = 0;
	
	if( fuIsFilterInPage(pgTarget, FILTER_TYPE_ASCII, lpcszDataFile) )
	{
		iType = FILTER_TYPE_ASCII;
		iCount++;
	}
	if( fuIsFilterInPage(pgTarget, FILTER_TYPE_BINARY, lpcszDataFile) )
	{
		iType = FILTER_TYPE_BINARY;
		iCount++;
	}
	if( fuIsFilterInPage(pgTarget, FILTER_TYPE_USERDEFINED, lpcszDataFile) )
	{
		iType = FILTER_TYPE_USERDEFINED;
		iCount++;
	}

	if( 1 == iCount )
	{
		iFilterType = iType;
		return true;
	}
	return false;
}

bool fuIsFilterInPage(Page &pgTarget, int iType, LPCSTR lpcszDataFile)
{
	/*
	string strName;
	if( fuGetPageFilterName(strName, iType) )
	{
		vector<byte> vb;
		if( pgTarget.GetMemory(strName, vb) )
		{
			if( !lpcszDataFile )
				return true;
			
			Tree trFilter(lpcszFilterFile);
	if( trFilter )
			return fuIsApplicable(trFilter, lpcszDataFile, iType);
		}
	}
	*/	
	if( IS_FILTER_TYPE(iType) )
	{
		Tree trFilter;
		if( fuLoadFilterFromPage(trFilter, pgTarget, iType) )
			return fuIsApplicable(trFilter, lpcszDataFile, iType);
	}
	else
	{
		if( fuIsFilterInPage(pgTarget, FILTER_TYPE_ASCII, lpcszDataFile) )
			return true;
		if( fuIsFilterInPage(pgTarget, FILTER_TYPE_BINARY, lpcszDataFile) )
			return true;
		if( fuIsFilterInPage(pgTarget, FILTER_TYPE_USERDEFINED, lpcszDataFile) )
			return true;
	}
	return false;
}

bool fuSaveFilterToPage(TreeNode &trFilter, Page &pgTarget)
{
	string strFilter = trFilter.XML;
	vector<byte> vb;
	if( strFilter.GetBytes(vb) )
	{
		string strName;
		///---Sim 09-04-2006 GET_FILTER_BY_ID
		//if( fuGetPageFilterName(strName, trFilter.Type.nVal) )
		if( fuGetPageFilterName(strName, fuGetType(trFilter)) )
		///---END GET_FILTER_BY_ID
		{
			if( pgTarget.SetMemory(strName, vb) )
				return true;
		}
	}
	return false;
}

bool fuLoadFilterFromPage(TreeNode &trFilter, Page &pgTarget, int iType)
{
	string strName;
	if( fuGetPageFilterName(strName, iType) )
	{
		vector<byte> vb;
		if( pgTarget.GetMemory(strName, vb) )
		{
			string strFilter;
			if( strFilter.SetBytes(vb) )
			{
				trFilter.XML = strFilter;
				return true;
			}
		}
	}
	return false;
}
/// end SAVE_FILTER_IN_WKS

///---Sim 08-30-2006 GET_FILTER_BY_ID
/*
bool fuGetUserDefinedFunction(TreeNode &trFilter, string &strOCFile, string &strOCFunction)
{
	if( trFilter.Common.OCFile && trFilter.Common.OCFunction )
	{
		strOCFile = trFilter.Common.OCFile.strVal;
		strOCFunction = trFilter.Common.OCFunction.strVal;
		return true;
	}
	return false;
}
*/
///---END GET_FILTER_BY_ID
bool fuSetUserDefinedFunction(TreeNode &trFilter, LPCSTR lpcszOCFile, LPCSTR lpcszOCFunction)
{
	///---Sim 09-01-2006 GET_FILTER_BY_ID
	if( lpcszOCFile && lpcszOCFunction )
	{
		//trFilter.Common.OCFile.strVal = lpcszOCFile;
		//trFilter.Common.OCFunction.strVal = lpcszOCFunction;
		//trFilter.Common.RemoveChild(FILTER_OCCLASS_NAME);
		fuSetStr(trFilter, IDE_USERDEFIMP_FILE, lpcszOCFile);
		fuSetStr(trFilter, IDE_USERDEFIMP_FUNCTION, lpcszOCFunction);
		fuSetStr(trFilter, IDE_USERDEFIMP_CLASS, "");
		//TreeNode tr = tree_get_node_by_id(trFilter, IDE_USERDEFIMP_CLASS);
		//if ( tr )
		//	tr.Remove();
		return true;
	}
	///---END GET_FILTER_BY_ID
	return false;
}

/// EJP 09-09-2003 v7.5689 QA70-4818 UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS
bool fuUpdatePageASCIMP(Page &pg, bool bUpdateInternal)
{
	Tree trFilter;
	if( !fuLoadFilterFromPage(trFilter, pg, FILTER_TYPE_ASCII) )
		return false; // page does not have an ASCII filter

	Worksheet wks(pg.GetName());
	if( !wks )
		return false; // failed to get reference to wks

	ASCIMP ascimp;
	if( bUpdateInternal ) // update internal settings from filter
	{
		if( !fuGetASCIMP(trFilter, ascimp) )
			return false; // failed to get ASCIMP from filter
		wks.SetASCIMP(ascimp);
	}
	else // update filter from internal settings
	{
		wks.GetASCIMP(ascimp);
		fuSetASCIMP(trFilter, ascimp);
		fuSaveFilterToPage(trFilter, pg);
	}
	_MSG_INT(fuUpdatePageASCIMP, ascimp.iDelimited)
	
	return true; // ascimp updated
}
/// end UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS

/// EJP 2006-06-30 v8.0436 XFUNC_FOR_MAKING_XFUNC_FILTERS
static bool _fuSaveFilter(TreeNode &trFilter, LPCSTR lpcszFile)
{
	fuSetOriginVersion(trFilter);

	Tree tr;
	tr = trFilter;
	
	return tr.Save(lpcszFile);
}

bool fuSave(TreeNode &tnFilter, LPCSTR lpcszFile)
{
	// Check arguments
	if( !tnFilter || NULL == lpcszFile || 0 == *lpcszFile )
		return false;

	// Check for a file extension
	string strName = GetFileName(lpcszFile);
	if( -1 == strName.Find('.') )
		strName += ".oif";

	// If a path is not specified then use the user's Filters folder
	string strPath = GetFilePath(lpcszFile);
	if( strPath.IsEmpty() )
		strPath = GetAppPath(FALSE) + FILTERS_FOLDER_NAME;
	
	///---Sim 11-16-2006 FIX_SAVE_FILTER_FILE_WHEN_FOLDER_NOT_EXIST
	if ( !strPath.IsPath() ) // folder not exist
	{
		if ( !CreateDirectory(strPath, NULL) )
			return false;
	}
	///---END FIX_SAVE_FILTER_FILE_WHEN_FOLDER_NOT_EXIST
	
	// Insert path before file name
	strName.Insert(0, strPath);

	// Now we can save the filter
	return _fuSaveFilter(tnFilter, strName);
}
/// end XFUNC_FOR_MAKING_XFUNC_FILTERS

/// EJP 08-10-2004 v8.0115 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
#if _OC_VER >= 0x0800

bool fuSetUserDefinedClass(TreeNode &trFilter, LPCSTR lpcszOCFile, LPCSTR lpcszOCClass)
{
	///---Sim 09-01-2006 GET_FILTER_BY_ID
	if( lpcszOCFile && lpcszOCClass )
	{
		//trFilter.Common.OCFile.strVal = lpcszOCFile;
		//trFilter.Common.OCClass.strVal = lpcszOCClass;
		//trFilter.Common.RemoveChild(FILTER_OCFUNC_NAME);
		fuSetStr(trFilter, IDE_USERDEFIMP_FILE, lpcszOCFile);
		fuSetStr(trFilter, IDE_USERDEFIMP_CLASS, lpcszOCClass);
		fuSetStr(trFilter, IDE_USERDEFIMP_FUNCTION, "");
		//TreeNode tr = tree_get_node_by_id(trFilter, IDE_USERDEFIMP_FUNCTION);
		//if ( tr )
		//	tr.Remove();
		return true;
	}
	///---END GET_FILTER_BY_ID
	return false;
}

ClassObject& fuGetImportClassRef(TreeNode& trFilter, LPCSTR lpcszOCClass, LPCSTR lpcszOCFile)
{
	/// Hong 04/28/07 QA9702 CLEARLY_NEW_OBJECT_NEEDED
	//return Project.FindClass(lpcszOCClass, lpcszOCFile);
	return Project.CreateClass(lpcszOCClass, lpcszOCFile);
	/// end CLEARLY_NEW_OBJECT_NEEDED
}
#endif // _OC_VER >= 0x0800
/// end IMPORT_INFO_STORAGE_CLEANUP

BOOL fuGetXFunctionOptions(TreeNode& tnFilter, TreeNode& tnOptions)
{
	TreeNode tnXFunc;
	if( fuGetXFunction(tnFilter, tnXFunc) )
	{
		if( tnXFunc.Options )
		{
			tnOptions = tnXFunc.Options;
			return TRUE;
		}
	}
	return FALSE;
}

BOOL fuSetXFunctionOptions(TreeNode& tnFilter, TreeNode& tnOptions)
{
	TreeNode tnXFunc;
	if( !fuGetXFunction(tnFilter, tnXFunc) )
		tnXFunc = tnFilter.AddNode("XFunction");
	if( tnXFunc )
	{
		TreeNode tnCurOptions;
		if( !tnXFunc.Options )
			tnCurOptions = tnXFunc.AddNode("Options");
		if( tnCurOptions )
		{
			return tnXFunc.Options.Replace(tnOptions, TRUE, TRUE);
		}
	}
	return FALSE;
}	
/// end IMPWIZ_SUPPORT_XFUNC
/// Hong 9/14/06 REMOVE_IMPORT_RELATED_TO_FU_UTILS
/// EJP 2006-07-07 v8.0440 QA70-8697 XFUNC_BASED_IMPORT, Move code to here from FileImport.c
#if _OC_VER >= 0x0800
/// Hong 02/12/07 MAKE_READONLY_FOR_FILE_BINARY_STORAGE
//bool impinfo_InitTree(Page& pgTarget, int nImportMode)
bool impinfo_InitTree(Page& pgTarget, int nImportMode, bool bCleanReadOnly)
/// end MAKE_READONLY_FOR_FILE_BINARY_STORAGE
{
	int nFile = 1; // first node

	Tree tr;
	if( tree_get_binary_storage(tr, pgTarget, IFI_BINARY_STORAGE_NAME) )
	{
		/// Hong 01/17/07 SHOULD_NOT_RESET_STORAGE_TREE_EVENT_WKS_CLEARED
		// as we have multi-sheet data, so this design is not correct
		/*
		if( ASCIMP_MODE_REPLACE_DATA == nImportMode )
		{
			tr.Reset(); // empty tree
		}
		else // appending data, new file node
		{
			nFile = tr.GetNodeCount() + 1;
		}
		*/
		/// Hong 02/12/07 FIX_ERROR_INDEX_WHEN_DELETE_FILE
		//nFile = tr.GetNodeCount() + 1;
		if(tr.GetNodeCount() > 0)
		{
			char szBuffer[MAXLINE];
			int nMaxIndex;
			if( nMaxIndex = string_to_prefix_end_number(szBuffer, tr.LastNode.tagName) )
				nFile = nMaxIndex + 1;
			else
				nFile = tr.GetNodeCount() + 1;
		}
		/// end FIX_ERROR_INDEX_WHEN_DELETE_FILE
		/// end SHOULD_NOT_RESET_STORAGE_TREE_EVENT_WKS_CLEARED
		/// Hong 02/12/07 MAKE_READONLY_FOR_FILE_BINARY_STORAGE
		if(bCleanReadOnly)
		{
			foreach(TreeNode tn in tr.Children)
				tn.Enable = ENABLE;
		}
		/// end MAKE_READONLY_FOR_FILE_BINARY_STORAGE
	}

	string str;
	str.Format(IFI_FILE_NODE_ENUM_NAME, nFile);
	///------ Folger 06/28/10 ORG-155 ASCII_IMPORT_SPEED_IMPROVE
	//TreeNode trFile = tr.AddNode(str);
	TreeNode trFile = fuCheckAddFileInfoNode(tr, str);
	///------ End ASCII_IMPORT_SPEED_IMPROVE
	trFile.Enable = ENABLE_READ_ONLY;/// Hong 02/12/07 MAKE_READONLY_FOR_FILE_BINARY_STORAGE
	///---Sim 03-07-2007 QA80-9435 ADD_DATA_ID_FOR_DATA_RANGE_TREE
	trFile.SetAttribute(STR_DATAID_ATTRIB, ID_FILEINFO_FILENODE);
	trFile.SetAttribute(STR_REPEAT_ID_ATTRIB, nFile);
	///---END QA80-9435 ADD_DATA_ID_FOR_DATA_RANGE_TREE
	
	if( tree_put_binary_storage(tr, pgTarget, IFI_BINARY_STORAGE_NAME) )
		return true;
	return false;
}

bool impinfo_GetLastFileNode(Page& pgSource, TreeNode& trTarget)
{
	Tree tr;
	if( tree_get_binary_storage(tr, pgSource, IFI_BINARY_STORAGE_NAME) )
	{
		trTarget = tr.LastNode;
		return true;
	}
	return false;
}

/// AW 09/28/06 QA80-9010 GET_VARIABLE_VALUE_FROM_ORGANIZER
//bool impinfo_SetLastFileNode(Page& pgTarget, TreeNode& trFile)
bool impinfo_SetLastFileNode(Page& pgTarget, TreeNode& trFile, int& findex)//=NULL
/// END GET_VARIABLE_VALUE_FROM_ORGANIZER
{
	Tree tr;
	if( tree_get_binary_storage(tr, pgTarget, IFI_BINARY_STORAGE_NAME) )
	{
		TreeNode trn;
		trn = tr.LastNode;
		if( trn && trn.Replace(trFile, TRUE) )
		/// AW 09/28/06 QA80-9010 GET_VARIABLE_VALUE_FROM_ORGANIZER
			//return tree_put_binary_storage(tr, pgTarget, IFI_BINARY_STORAGE_NAME);
		{
			if ( NULL != (&findex) )
			{
				findex = tr.GetNodeCount();	
			}
			return tree_put_binary_storage(tr, pgTarget, IFI_BINARY_STORAGE_NAME);
		}
		/// END GET_VARIABLE_VALUE_FROM_ORGANIZER
	}
	return false;
}

bool impinfo_FilterNameToLastFileNode(Page& pgTarget, LPCSTR lpcszFilterFile)
{
	Tree trFile;
	if( impinfo_GetLastFileNode(pgTarget, trFile) )
	{
		trFile.Info.FilterFile.strVal = lpcszFilterFile;
		return impinfo_SetLastFileNode(pgTarget, trFile);
	}
	return false;
}

/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
//int impinfo_HeaderVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues)
int impinfo_HeaderVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues, const StringArray* psaVarLabels/* = NULL*/)
/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
{
	/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR	
	//for( int n = 0; n < saVarNacmes.GetSize(); n++ )	
		//tnFile.Variables.Header.AddTextNode(saVarValues[n], saVarNames[n]);
	ASSERT(tnFile);
	ASSERT(saVarNames.GetSize() == saVarValues.GetSize());
	ASSERT(!psaVarLabels || psaVarLabels->GetSize() == saVarValues.GetSize());
	TreeNode	trVar = tree_check_get_node(tnFile, "Variables");
	TreeNode	trHeader = tree_check_get_node(trVar, "Header");
	TreeNode	trNode;
	for ( int n = 0; n < saVarNames.GetSize(); n++ )
	{
		trNode = trHeader.AddTextNode(saVarValues[n], saVarNames[n]);
		if ( psaVarLabels )	
		{
			StringArray&		saRefVarLabels = *psaVarLabels;
			trNode.SetAttribute(STR_LABEL_ATTRIB, saRefVarLabels[n]);
		}
	}
	/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR	
	return 0;
}

/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
//int impinfo_FileNameVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues)
int impinfo_FileNameVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues, const StringArray* psaVarLabels/* = NULL*/)
/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
{
	/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
	//for( int n = 0; n < saVarNames.GetSize(); n++ )	
		//tnFile.Variables.FileName.AddTextNode(saVarValues[n], saVarNames[n]);
	ASSERT(tnFile);
	ASSERT(saVarNames.GetSize() == saVarValues.GetSize());
	ASSERT(!psaVarLabels || psaVarLabels->GetSize() == saVarNames.GetSize());
	TreeNode	trVar = tree_check_get_node(tnFile, "Variables");
	TreeNode	trFileName = tree_check_get_node(trVar, "FileName");
	TreeNode	trNode;
	//-- bad code becuase no GetAt available for vectorbase
	StringArray		saVarLabelsCopy;
	if ( psaVarLabels )
		saVarLabelsCopy = *psaVarLabels;
	//--
	for ( int n = 0; n < saVarNames.GetSize(); n++ )
	{
		trNode = trFileName.AddTextNode(saVarValues[n], saVarNames[n]);
		if ( psaVarLabels )		
		{			
			trNode.SetAttribute(STR_LABEL_ATTRIB, saVarLabelsCopy[n]);
		}
	}
	/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
	return 0;
}

///---Sim 03-12-2007 MORE_WORK_ON_ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
/// Hong 03/12/07 QA80-9418-S1 ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
/// Hong 05/30/07 OUTPUT_ERROR_CODE
//int getFileInfoByRange(TreeNode& trFile, const DataRange& dr)
int getFileInfoByRange(TreeNode& trFile, const DataRange& dr, int* nErrCode) // = NULL
/// end OUTPUT_ERROR_CODE
{
	///Jasmine 01/23/09 PLOT_SETUP_NEED_IMPORTED_FILE_INFO_FROM_SHEET
	return get_file_info_by_range(trFile, dr, nErrCode);
	///End PLOT_SETUP_NEED_IMPORTED_FILE_INFO_FROM_SHEET
}

bool impinfo_UpdateFileNode(Page& pgTarget, TreeNode& trFile, int nIndex)
{
	Tree tr;
	if( tree_get_binary_storage(tr, pgTarget, IFI_BINARY_STORAGE_NAME) )
	{
		//int nn = 0;
		//foreach(TreeNode tn in tr.Children)
		//{			
			//if( nIndex == nn )
		string str;
		str.Format(IFI_FILE_NODE_ENUM_NAME, nIndex);
		TreeNode tn = tr.GetNode(str);
		if ( tn )
		{
			tn.Replace(trFile, TRUE);
			return tree_put_binary_storage(tr, pgTarget, IFI_BINARY_STORAGE_NAME);
		}
			//nn++
		//}
	}
	return false;
}
/// end ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
///---END MORE_WORK_ON_ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT

///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
static DWORD _get_auto_size_cntrl(int nAutoSize)
{
	DWORD dwCntrl = AS_NOWIDTH | AS_NOHEIGHT;
	switch (nAutoSize)
	{
	case FILTER_AUTO_SIZE_WIDTH:		dwCntrl = AS_NOHEIGHT;	break;
	case FILTER_AUTO_SIZE_HEIGHT:		dwCntrl = AS_NOWIDTH;	break;
	case FILTER_AUTO_SIZE_WIDTH_HEIGHT:	dwCntrl = 0;			break;
	}
	return dwCntrl;
}
///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION

///Hong 8/04/06 ADD_FILTER_INFO
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType)
/// AW 09/28/06 QA80-9010 GET_VARIABLE_VALUE_FROM_ORGANIZER
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter)
///---Sim 02-06-2007 ADD_RANGE_INFO_TO_BASE_INFO
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter, int& findex)//=NULL)
/// Hong 03/07/07 FIX_MULTI_ASC_INFINITE_LOOP
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter, int& findex, TreeNode& trRange)//=NULL, NULL, NULL)
/// Hong 03/12/07 QA80-9418-S1 ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter, int findex, TreeNode& trRange)//=NULL, 1, NULL)
/// AW 07/11/07 SHOULD_NOT_AUTO_SIZE_IN_EXCEL_IMPORT
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter, int findex, TreeNode& trRange, bool bReimport)//=NULL, 1, NULL, false)
bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter, int findex, TreeNode& trRange, bool bReimport, DWORD dwOption)//=NULL, 1, NULL, false, 0)
/// END SHOULD_NOT_AUTO_SIZE_IN_EXCEL_IMPORT
/// end ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
/// end FIX_MULTI_ASC_INFINITE_LOOP
///---END ADD_RANGE_INFO_TO_BASE_INFO
/// END GET_VARIABLE_VALUE_FROM_ORGANIZER
///edn ADD_FILTER_INFO
{
	///Cheney 2006-12-27 SHOULD_CHECK_LAYER_IF_IS_VALID
	if(!lyTarget.IsValid())
		return false;
	///end SHOULD_CHECK_LAYER_IF_IS_VALID
	
	/// AW 11/01/06 AUTO_SIZE_COL_IN_IMP_FILE
	if ( !( dwOption ^ IMP_INFO_ADDFILE_NO_AUTO_SIZE ) )
	{
		Worksheet wks(lyTarget);
		if ( wks )
		{
			///---Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
			/*
			/// Hong 06/06/08 v8.0879 AUTO_SIZE_NEED_MAXIMUM_LIMITATION
			//wks.AutoSize(AS_INVALIDATE | AS_NOHEIGHT);
			//wks.Invalidate();
			///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
			//autosize_rowcol(wks, 1.5, 50, -1, -1, AS_INVALIDATE | AS_NOHEIGHT);
			int nAutoSize = fuGetAutoSize(trFilter);
			if ( FILTER_AUTO_SIZE_NO != nAutoSize )
			{
				DWORD dw = AS_INVALIDATE | _get_auto_size_cntrl(nAutoSize);
				autosize_rowcol(wks, 1.5, 50, -1, -1, dw);
			}
			///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
			/// end AUTO_SIZE_NEED_MAXIMUM_LIMITATION
			*/
			fu_autosize_rowcol(wks, trFilter, 1.5, 50, -1, -1);
			///---END QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
		}
	}
	/// END AUTO_SIZE_COL_IN_IMP_FILE
	
	Page pgTarget;
	lyTarget.GetParent(pgTarget);
	if( pgTarget )
	{
		/// Hong 02/12/07 MAKE_READONLY_FOR_FILE_BINARY_STORAGE
		//impinfo_InitTree(pgTarget, nImportMode);
		bool bCleanReadOnly = false;
		if( NULL != (&findex) && 1 == findex )
			bCleanReadOnly = true;
		/// Hong 03/12/07 QA80-9418-S1 ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
		//impinfo_InitTree(pgTarget, nImportMode, bCleanReadOnly);
		///// end MAKE_READONLY_FOR_FILE_BINARY_STORAGE
		//Tree trFile;
		//impinfo_GetLastFileNode(pgTarget, trFile);
		Tree trFile;
		int nFNodeIndex; // which file node need to update
		if( !bReimport ) // default
		{
			impinfo_InitTree(pgTarget, nImportMode, bCleanReadOnly);
			impinfo_GetLastFileNode(pgTarget, trFile);
		}
		else //when reimport, find out the file tree, and update it
		{
			///---Sim 03-12-2007 MORE_WORK_ON_ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
			//Datasheet dsTemp;
			//int c1 = 0, c2 = -1;
			DataRange dr;
			//if( trRange && trRange.GetDataRange(dr) )
				//dr.GetRange(dsTemp, c1, c2);
			if ( trRange )
				dr = get_and_check_range(trRange, pgTarget.GetName());
			///---END MORE_WORK_ON_ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
	
			nFNodeIndex = getFileInfoByRange(trFile, dr);
			if( nFNodeIndex <= 0 )
				return false;
			
			trFile.RemoveChildrenWithPrefix();
		}
		///end ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
		///---Sim 02-06-2007 ADD_RANGE_INFO_TO_BASE_INFO
		impinfo_FileInfoToFileNode(trFile, lpcszDataFile, nImportType, trRange);
		impinfo_UpdateCovered(trFile, false); // new imported file is not
		///---END ADD_RANGE_INFO_TO_BASE_INFO
		/// Hong 01/17/07 RESET_USER_VARIABLES
		pgTarget.Info.User.RemoveSection("Variables");
		pgTarget.Info.Remove("User");
		/// end RESET_USER_VARIABLES
		okutil_SetPageInfo(pgTarget.GetName(), lpcszDataFile, FILTER_TYPE_XFUNC);  //// AW 12/28/06 MORE_SAVE_INFO_TO_SYSTEM_STORAGE

		if( tnInfo )
		{
			TreeNode trNode = tnInfo.FirstNode;
			while( trNode )
			{
				trFile.AddNode(trNode, true);
				trNode = trNode.NextNode;
			}
		}
		///Hong 8/04/06 ADD_FILTER_INFO
		///---Sim 09-15-2006 CHECK_FILTER_VALID
		//if( trFilter )
		if( trFilter && trFilter.IsValid() )
		///---END CHECK_FILTER_VALID
		{
			////  AW 08/23/06 ADD_FILTER_FILENAME
			if(trFilter.FileName)	///---Sim 09-15-2006 CHECK_FILTER_VALID
			{
				trFile.Info.FilterFileName.strVal = trFilter.FileName.strVal; 
				trFile.Info.FilterFileName.SetAttribute(STR_LABEL_ATTRIB, _L("Filter File Name"));/// Hong 11/24/09 LOCALIZE_IMPORT_INFO
			}
			if ( FILTER_TYPE_XFUNC == nImportType )
			{
				//trFile.Info.FileType.strVal = trFilter.XFunction.Name.strVal;	
				/// Hong 06/06/07 v8.0634 AVOID_HARD_CODE_BY_GET_NODE_USE_ID
				//if(trFilter.XFunction.strName)	///---Sim 09-15-2006 CHECK_FILTER_VALID
				TreeNode trXFnctionName = tree_get_node_by_id(trFilter, IDE_XFIMP_NAME, true);
				if ( trXFnctionName )
				/// end AVOID_HARD_CODE_BY_GET_NODE_USE_ID
				///---Sim 02-14-2007 CORRECT_FILE_TYPE
				{
					//trFile.Info.FileType.strVal = trFilter.XFunction.strName.strVal;//Hong 9/11/06 GET_NAME_USE_NEW_STRUCTURE	
					/// Hong 06/06/07 v8.0634 AVOID_HARD_CODE_BY_GET_NODE_USE_ID
					//string strXFName = trFilter.XFunction.strName.strVal;
					string strXFName = trXFnctionName.strVal;
					/// end AVOID_HARD_CODE_BY_GET_NODE_USE_ID
					if ( !strXFName.IsEmpty() )
					{
						if ( 0 == strXFName.Find("imp") ) // temporary code
							strXFName.Delete(0, 3);
						trFile.Info.FileType.strVal = strXFName;
					}
				}
				///---END CORRECT_FILE_TYPE
			}
			/// END ADD_FILTER_FILENAME
				
			TreeNode trFilterInfo = trFile.AddNode("FilterInfo");
			trFilterInfo.SetAttribute(STR_LABEL_ATTRIB, _L("Filter Info"));		//------ Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO
			TreeNode trNode1 = trFilter.FirstNode;
			while( trNode1 )
			{
				trFilterInfo.AddNode(trNode1, true);
				trNode1 = trNode1.NextNode;
			}
		}
		///edn ADD_FILTER_INFO
		/// AW 09/28/06 QA80-9010 GET_VARIABLE_VALUE_FROM_ORGANIZER
		//impinfo_SetLastFileNode(pgTarget, trFile);
		/// Hong 03/12/07 QA80-9418-S1 ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
		//impinfo_SetLastFileNode(pgTarget, trFile, findex);
		if( !bReimport )
		{
			impinfo_SetLastFileNode(pgTarget, trFile, findex);
		}
		else
		{
			impinfo_UpdateFileNode(pgTarget, trFile, nFNodeIndex);
		}
		/// END GET_VARIABLE_VALUE_FROM_ORGANIZER

		///---Sim 06-25-2007 UPDATE_ORGANIZER
		char szBuffer[MAXLINE];
		int nNodeIndex = string_to_prefix_end_number(szBuffer, trFile.tagName);
		///Folger 06/26/07 CHANGE_UPDATE_TO_NOTIFY
		//update_organizer_gui(pgTarget, UPDATE_FROM_IMPORT, nNodeIndex);
		notify_organizer_gui(pgTarget, UPDATE_FROM_IMPORT, nNodeIndex);
		///End CHANGE_UPDATE_TO_NOTIFY
		//refresh_organizer_gui(pgTarget); /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
		///---END UPDATE_ORGANIZER
		
		return true;
	}
	return false;
}
///---Sim 02-14-2007 ADD_INFO_FOR_COVERED_DATA
void impinfo_UpdateCovered(TreeNode& trFile, bool bCovered)
{
	trFile.Info.CoveredByAnotherImport.strVal = (bCovered) ? "Yes" : "No";
}

bool impinfo_UpdateExistingData(Page& pgTarget, DataRange& drNewImported)
{
	if ( !pgTarget )
		return false;
	
	Tree tr;
	if( tree_get_binary_storage(tr, pgTarget, IFI_BINARY_STORAGE_NAME) )
	{
		foreach( TreeNode trFile in tr.Children)
		{
			// temporary code
			TreeNode trRange = trFile.GetNode(STR_RANGE_INFO_NODE);
			if ( !trRange )
				trRange = tree_get_node_by_tagname(trFile, "DataRange", true);
			
			///---Sim 03-07-2007 QA80-9435 SUPPORT_RELATIVE_DATA_RANGE
			//if ( trRange )
			//{
				//TreeNode trRangeUID = trRange.GetNode("RangeUID");
				//if ( trRangeUID )
				//{
					//uint UID = trRangeUID.nVal;
					//DataRange dr;
					//dr = (DataRange)Project.GetObject(UID);
			DataRange dr;
			dr = get_and_check_range(trRange, pgTarget.GetName());
			if( dr.IsValid() && dr.GetNumData() )
			{
				if ( is_relative_range(dr, drNewImported) )
				{
					impinfo_UpdateCovered(trFile, true);
				}
			}
			else
			{
				impinfo_UpdateCovered(trFile, true);
				
				//string strMsg;
				//strMsg.Format("Invalid Data Range UID : %d", UID);
				//error_report(strMsg);
				////return false;
			}			
				//}
			//}
			///---END QA80-9435 SUPPORT_RELATIVE_DATA_RANGE
		}
		
		return tree_put_binary_storage(tr, pgTarget, IFI_BINARY_STORAGE_NAME);
	}
	return false;
}
///---END ADD_INFO_FOR_COVERED_DATA
#endif // _OC_VER >= 0x0800
/// end XFUNC_BASED_IMPORT
/// end REMOVE_IMPORT_RELATED_TO_FU_UTILS
///Hong 9/26/06 MOVE_TO_FU_UTILS_AS_UTIL_FUNCTION
int GetFilterClassName(TreeNode& trFilter, string& strClassName)
{
	StringArray	saFilterClassName ={"IWASCII","IWBINARY", "IWUser","IWXF"};
	
	int nFilterType = fuGetType(trFilter);
	if ( nFilterType >= saFilterClassName.GetSize() )
		return IMPERR_FILTER_TYPE;
	strClassName = saFilterClassName[nFilterType];
	return IMPERR_NONE;
}
/// END MOVE_TO_FU_UTILS_AS_UTIL_FUNCTION

///---Sim 01-29-2007 MORE_UTILS_FUNCTION
int getRangeInfo(TreeNode& trRange, Datasheet& ds, int nC1, int nC2, int nR1, int nR2) // = -1, 0, -1
{
	if ( nC2 < 0 )
		nC2 = nC1;
	//if ( nR2 < 0 )
		//nR2 = nR1;
	
	DataRange dr;
	//Worksheet wks = ds;
	//dr.Add("X", wks, 0, nC1, -1, nC1); 
	dr.Add(ds, nC1, STR_RANGE_STR, nC2, nR1, nR2);
	
	return getRangeInfo(trRange, dr);
	//uint UID = dr.GetUID(TRUE);
	//Project.AddDataRange(dr);
	//
	//// just for test
	////string str = dr.GetDescription();
	////DataRange dr2;
	////dr2 = (DataRange)Project.GetObject(UID);
	////if(!dr2.IsValid())
		////error_report("Data Range UID invalid!");
	//
	////TreeNode trRange = trFileInfo.AddNode(STR_RANGE_INFO_NODE);
	//
	//// set range UID
	//TreeNode trRangeUID = trRange.AddNode(STR_RANGE_UID);
	//trRangeUID.nVal = UID;
	//trRangeUID.Show = 0;
	//
	//// set range string
	//TreeNode trRangeStr = trRange.AddNode(STR_RANGE_STR);
	//trRangeStr.strVal = dr.GetDescription(GETLC_PAGE_SHORT_NAME|GETLC_COL_SHORT_NAME);
	//trRangeStr.ID = TRGP_MULTILINE_TEXT;
	//
	//return UID;
}

int getRangeInfo(TreeNode& trRange, DataRange& dr)
{
	// creat new data range for new range UID
	DataRange drPrj;
	dr.Clone(drPrj);
	
	uint UID = drPrj.GetUID(TRUE);
	
	///---Sim 03-11-2007 QA80-9435 CENTRALIZE_RANGE_TREE_BOTH_ON_VC_AND_OC
	//Project.AddDataRange(drPrj);
	//
	////trRange.SetName(STR_RANGE_INFO_NODE);
	//// set range UID
	//TreeNode trRangeUID = trRange.AddNode(STR_RANGE_UID);
	//trRangeUID.nVal = UID;
	//trRangeUID.Show = 0;
	//
	//// set range string
	//TreeNode trRangeStr = trRange.AddNode(STR_RANGE_STR);
	//trRangeStr.strVal = drPrj.GetDescription(GETLC_PAGE_NAME_NONE|GETLC_COL_SHORT_NAME|GETLC_NO_DESIGNATIONS);
	//trRangeStr.ID = TRGP_MULTILINE_TEXT;
					//CPY 3/11/07 CHANGE_SET_DATA_RANGE_TO_USE_SAME_BITS_AS_GET_DESC
	trRange.SetDataRange(drPrj, TSDR_FILE_IMPORT_DEFAULTS);//TNR_NO_BOOK);
	///---END QA80-9435 CENTRALIZE_RANGE_TREE_BOTH_ON_VC_AND_OC
	
	return UID;	
}

///---Sim 11-01-2007 CLEAN_RANGE_ID_CODE
/*
//void getImportedRangeStringArray(vector<string>& saRange, Page& pg)
void getImportedRanges(vector<uint>& vuRanges, Page& pg)
{
	Tree tr;
	tree_get_binary_storage(tr, pg, IFI_BINARY_STORAGE_NAME);

	foreach( TreeNode trFile in tr.Children)
	{
		// temporary code
		TreeNode trRange = trFile.GetNode(STR_RANGE_INFO_NODE);
		if ( !trRange )
			trRange = tree_get_node_by_tagname(trFile, "DataRange", true);
		
		if ( trRange )
		{
			// temporary code
			//TreeNode trRangeStr = trRange.GetNode(STR_RANGE_STR_NAME);
			//if ( !trRangeStr )
				//trRangeStr = trRange.GetNode("Range");
			
			//if ( trRangeStr )
				//saRange.Add(trRangeStr.strVal);
			TreeNode trRangeUID = trRange.GetNode(STR_RANGE_UID);
			if ( trRangeUID)
				vuRanges.Add(trRangeUID.nVal);
		}
	}
}
*/
///---END CLEAN_RANGE_ID_CODE

bool isImported(Layer& ly)
{
	if ( !ly )
		return false;
	
	Page pg;
	ly.GetParent(pg);
	
	///---Sim 03-07-2007 QA80-9435 SUPPORT_RELATIVE_DATA_RANGE
	// get range string array
	//vector<string> saRange;
	//getImportedRangeStringArray(saRange, pg);
	//vector<uint> vuRangeUID;
	//getImportedRanges(vuRangeUID, pg);
	
	// get sheet name string array from range string array
	vector<string> saSheet;
	//string strBookName, strSheetName;
	//for (int ii = 0; ii < vuRangeUID.GetSize(); ii++ )
	//{
	Tree tr;
	if( tree_get_binary_storage(tr, pg, IFI_BINARY_STORAGE_NAME) )
	{
		foreach( TreeNode trFile in tr.Children)
		{
			// temporary code
			TreeNode trRange = trFile.GetNode(STR_RANGE_INFO_NODE);
			if ( !trRange )
				trRange = tree_get_node_by_tagname(trFile, "DataRange", true);
			
			//get_book_sheet_info(strBookName, strSheetName, saRange[ii]);
			//saSheet.Add(strSheetName);
			DataRange dr;
			//dr = (DataRange)Project.GetObject(vuRangeUID[ii]);
			dr = get_and_check_range(trRange, pg.GetName());
			if( dr.IsValid() && dr.GetNumData() )
			{
				Datasheet ds;
				int r1,r2,c1,c2;
				dr.GetRange(0, r1, c1, r2, c2, ds);
				if(ds)
					saSheet.Add(ds.GetName());
			}
			//else
			//{
				//string strMsg;
				//strMsg.Format("Invalid Data Range UID : %d", vuRangeUID[ii]);
				//error_report(strMsg);
			//}
		}
	}
	///---END QA80-9435 SUPPORT_RELATIVE_DATA_RANGE

	string strSheetName = ly.GetName();
	
	return ( saSheet.Find(strSheetName) >= 0 );
}

bool fuDisableAllRename(TreeNode& trFilter, bool* pbRenameWks, bool* pbRenameWkBk, bool* pbAppendWkBkComm, bool* pbAppendColComm, bool* pbRenameWksWithVar, bool* pbRenameWkbkWithVar)// = NULL, NULL, NULL, NULL, NULL, NULL
{
	// hold last value
	///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	//if ( !getRenameMode(trFilter, pbRenameWks, NULL, pbRenameWkBk, NULL, pbAppendWkBkComm, pbAppendColComm, pbRenameWksWithVar, pbRenameWkbkWithVar) )
	if ( !getRenameMode(trFilter, pbRenameWks, NULL, NULL, pbRenameWkBk, NULL, pbAppendWkBkComm, pbAppendColComm, pbRenameWksWithVar, pbRenameWkbkWithVar) )
	///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		return false;
	
	// disable rename
	bool bValue = false;
	return fuSetAllRename(trFilter, &bValue, &bValue, &bValue, &bValue, &bValue, &bValue);
}
bool fuSetAllRename(TreeNode& trFilter, bool* pbRenameWks, bool* pbRenameWkBk, bool* pbAppendWkBkComm, bool* pbAppendColComm, bool* pbRenameWksWithVar, bool* pbRenameWkbkWithVar)// = NULL, NULL, NULL, NULL, NULL, NULL
{
	string strClassName;
	int nRet = GetFilterClassName(trFilter, strClassName);
	if ( nRet )
		return false;
	
	if ( "IWASCII" == strClassName || "IWBINARY" == strClassName )
	{
		if ( pbRenameWks )
			fuSetRenameWks(trFilter, *pbRenameWks);
		
		if ( pbRenameWkBk )
			fuSetRenameWorkbook(trFilter, *pbRenameWkBk);
		
		if ( pbAppendWkBkComm )
			fuSetAppendFileNameToWorkBookComments(trFilter, *pbAppendWkBkComm);
		
		if ( pbAppendColComm )
			fuSetAppendFileNameToColumnComments(trFilter, *pbAppendColComm);
		
		if ( pbRenameWksWithVar )
			fuSetRenameWksWithVar(trFilter, *pbRenameWksWithVar);
		
		if ( pbRenameWkbkWithVar )
			fuSetRenameWkbkWithVar(trFilter, *pbRenameWkbkWithVar);
		
		return true;
	}
	else if ( "IWXF" == strClassName )
	{
		if ( pbRenameWks )
			fuSetRenameWks(trFilter, *pbRenameWks);
		
		if ( pbRenameWkBk )
			fuXFSetRenameWorkbook(trFilter, *pbRenameWkBk);
		
		if ( pbAppendWkBkComm )
			fuXFSetAppendFileNameToWorkBookComments(trFilter, *pbAppendWkBkComm);
		
		if ( pbAppendColComm )
			fuXFSetAppendFileNameToColumnComments(trFilter, *pbAppendColComm);

		return true;
	}
	return false;
}

///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
//bool getRenameMode(const TreeNode& trFilter, bool* pbRenameWks, bool* pbIncludePathWhenRenameBook, bool* pbRenameWkBk, bool* pbIncludePath, bool* pbAppendWkBkComm, bool* pbAppendColComm, bool* pbRenameWksWithVar, bool* pbRenameWkbkWithVar) // = NULL, NULL, NULL, NULL, NULL, NULL, NULL
bool getRenameMode(const TreeNode& trFilter, bool* pbRenameWks, bool* pbRenameWkBkLongNameOnly, bool* pbIncludePathWhenRenameBook, bool* pbRenameWkBk, bool* pbIncludePath, bool* pbAppendWkBkComm, bool* pbAppendColComm, bool* pbRenameWksWithVar, bool* pbRenameWkbkWithVar) // = NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
{
	string strClassName;
	int nRet = GetFilterClassName(trFilter, strClassName);
	if ( nRet )
		return false;
	
	if ( "IWASCII" == strClassName || "IWBINARY" == strClassName )
	{
		if ( pbRenameWks )
			*pbRenameWks = fuIsRenameWks(trFilter);
		
		///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		if ( pbRenameWkBkLongNameOnly )
			*pbRenameWkBkLongNameOnly = fuIsRenameBookLongNameOnly(trFilter);
		///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		
		if ( pbIncludePathWhenRenameBook )
			*pbIncludePathWhenRenameBook = !fuIsRenameBookWithoutPath(trFilter);
		
		if ( pbRenameWkBk )
			*pbRenameWkBk = fuIsRenameWorkbook(trFilter);
		
		if ( pbIncludePath )
			*pbIncludePath = !fuIsAppendFileNameWithoutPath(trFilter);
		
		if ( pbAppendWkBkComm )
			*pbAppendWkBkComm = fuIsAppendFileNameToWorkBookComments(trFilter);
		
		if ( pbAppendColComm )
			*pbAppendColComm = fuIsAppendFileNameToColumnComments(trFilter);
		
		if ( pbRenameWksWithVar )
			*pbRenameWksWithVar = fuIsRenameWksWithVar(trFilter);
		
		if ( pbRenameWkbkWithVar )
			*pbRenameWkbkWithVar = fuIsRenameWkbkWithVar(trFilter);
		
		return true;
	}
	else if ( "IWXF" == strClassName )
	{
		if ( pbRenameWks )
			*pbRenameWks = fuIsRenameWks(trFilter);
		
		///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		if ( pbRenameWkBkLongNameOnly )
			*pbRenameWkBkLongNameOnly = fuXFIsRenameBookLongNameOnly(trFilter);
		///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		
		if ( pbIncludePathWhenRenameBook )
			*pbIncludePathWhenRenameBook = fuXFIsRenameBookIncludePath(trFilter);
		
		if ( pbRenameWkBk )
			*pbRenameWkBk = fuXFIsRenameWorkbook(trFilter);
		
		if ( pbIncludePath )
			*pbIncludePath = fuXFIsAppendFileNameIncludePath(trFilter);

		if ( pbAppendWkBkComm )
			*pbAppendWkBkComm = fuXFIsAppendFileNameToWorkBookComments(trFilter);
		
		if ( pbAppendColComm )
			*pbAppendColComm = fuXFIsAppendFileNameToColumnComments(trFilter);
		
		return true;
	}
	return false;
}
///---END MORE_UTILS_FUNCTION

///---Sim 01-31-2007 ADD_AUTO_RENAME
//void updataImportFileRangeInfo(Page& pg)
//{
	//if ( !pg )
		//return;
	//
	//Tree tr;
	//tree_get_binary_storage(tr, pg, IFI_BINARY_STORAGE_NAME);
//
	//foreach( TreeNode trFile in tr.Children)
	//{
		//// temporary code
		//TreeNode trRange = trFile.GetNode(STR_RANGE_INFO_NODE);
		//if ( !trRange )
			//trRange = tree_get_node_by_tagname(trFile, "DataRange", true);
		//
		//if ( trRange )
		//{
			//TreeNode trRangeUID = trRange.GetNode("RangeUID");
			//TreeNode trRangeStr = trRange.GetNode("Range");
			//if ( trRangeUID && trRangeStr)
			//{
				//uint UID = trRangeUID.nVal;
				//DataRange dr;
				//dr = (DataRange)Project.GetObject(UID);
				//if(dr.IsValid())
				//{
					//trRangeStr.strVal = dr.GetDescription(GETLC_PAGE_SHORT_NAME|GETLC_COL_SHORT_NAME);
				//}
				//else
				//{
					//string strMsg;
					//strMsg.Format("Invalid Data Range UID : %d", UID);
					//error_report(strMsg);
				//}			
			//}
		//}
	//}	
//}

static void _getTrimFileName(string& strFileName, int nFrom, int nTo)
{
	/// Hong 03/06/07 CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE
	//if( nTo > -1 && nFrom <= nTo )
		//strFileName = strFileName.Left(nTo+1);
	//if( nFrom > 0 )
		//strFileName = strFileName.Right(strFileName.GetLength() - nFrom);
	if( nTo > 0 && nFrom <= nTo )
		strFileName = strFileName.Left(nTo);
	if( nFrom > 1 )
		strFileName = strFileName.Right(strFileName.GetLength() - nFrom + 1);
	/// end CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE
}

///---Sim 03-20-2007 FIX_APPEND_COMMENT_WHEN_REIMPORT
void remove_last_added_filename_comment(string& strComments, const string& strFullFileName)
{
	StringArray vsComments;
	str_separate(strComments, "\r\n", vsComments);
	
	int nSize = vsComments.GetSize();
	if ( nSize > 0 )
	{
		if ( vsComments[nSize - 1] == strFullFileName || vsComments[nSize - 1] == GetFileName(strFullFileName, FALSE) )
			vsComments.RemoveAt(nSize - 1);
		
		strComments = str_combine(vsComments, "\r\n");
	}
}
///---END FIX_APPEND_COMMENT_WHEN_REIMPORT

/// Hong 08/26/09 QA80-13839 FIX_ORIGIN_CRASH_DUE_TO_BUFFER_OVERFLOW_WHEN_OPJ_CONTAIN_HUGE_PAGE_COMMENT
static bool _is_comment_size_exceed_limitation(int nSize)
{
	/// ML 9/30/3009 QA70-13839 NEED_EVEN_LARGER_TEMP_STRING_SIZE
	//// see buffer size char SYSTEM_STRING::szTemp[TEMP_STRING_SIZE] which is define to 24k used as buffer to read origin object comments
	//return nSize > 24575/*24k-1*/ ? true : false;
	return nSize >= TEMP_STRING_SIZE ? true : false;
	///// end NEED_EVEN_LARGER_TEMP_STRING_SIZE
}
/// end FIX_ORIGIN_CRASH_DUE_TO_BUFFER_OVERFLOW_WHEN_OPJ_CONTAIN_HUGE_PAGE_COMMENT

bool setPageAndLayerName(DataRange& drTarget, const string& strFullFileName, const TreeNode& trFilter, DWORD dwCtrl)// = 0
{
	if ( !drTarget )
		return false;
	
	string strNewName = GetFileName(strFullFileName, TRUE);
	if( !strNewName.IsEmpty() )
	{
		int nImportMode = fuGetImportMode(trFilter);
		
		// get rename mode
		bool bRenameWks = false, bRenameWkBk = false, bAppendWkBkComm = false, bAppendColComm = false;
		bool bIncludePathWhenRenameBook = true, bIncludePath = true;
		bool bRenameWkBkLongNameOnly = false; ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		
		///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		//if ( !getRenameMode(trFilter, &bRenameWks, &bIncludePathWhenRenameBook, &bRenameWkBk, &bIncludePath, &bAppendWkBkComm, &bAppendColComm) )
		if ( !getRenameMode(trFilter, &bRenameWks, &bRenameWkBkLongNameOnly, &bIncludePathWhenRenameBook, &bRenameWkBk, &bIncludePath, &bAppendWkBkComm, &bAppendColComm) )
		///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
			return false;
		
		bool bAutoRename = fuIsAutoRename(trFilter);
		//if ( fuIsAutoRename(trFilter) ) 	// auto rename
		//{
			//// get rename sheet mode
			//bRenameWks = false;
			////if ( ASCIMP_MODE_APPEND_COLS == nImportMode || ASCIMP_MODE_APPEND_ROWS == nImportMode )
			//if ( ASCIMP_MODE_NEW_BOOKS == nImportMode )
			//{
				//// separate handle the file contain multi-sheet data
				//if (dwCtrl & RENAME_WKS_WHEN_NEW_BOOKS_FOR_AUTO)
					//bRenameWks = true;
			//}
			//else
			//{
				//if ( !isImported(ly) )
					//bRenameWks = true;
			//}
			//
			//// get rename book mode
			//bRenameWkBk = false;
			//string strLongName = pg.GetLongName();
			//if ( strLongName.IsEmpty() || strLongName == pg.GetName() )
				//bRenameWkBk = true;
			//
			//// get rename book comment mode
			////bAppendWkBkComm = true;
		//}
		
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		//string strSheetName = GetFileName(strFullFileName, TRUE);
		string strSheetName = GetFileName(strFullFileName, TRUE);
		if ( !bAutoRename && bRenameWks )
		{
			TreeNode trWksTrimFNameFrom		= tree_get_node_by_id(trFilter, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, true);
			TreeNode trWksTrimFNameTo		= tree_get_node_by_id(trFilter, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, true);
			if(trWksTrimFNameFrom && trWksTrimFNameTo)
			{
				//int nFrom = trWksTrimFNameFrom.dVal;
				//int nTo = trWksTrimFNameTo.dVal;
				//if( nTo > -1 && nFrom <= nTo )
					//strSheetName = strSheetName.Left(nTo+1);
				//if( nFrom > 0 )
					//strSheetName = strSheetName.Right(strSheetName.GetLength() - nFrom);					
				_getTrimFileName(strSheetName, trWksTrimFNameFrom.nVal, trWksTrimFNameTo.nVal);
			}
		}
		/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF

		string strBookName = GetFileName(strFullFileName, FALSE);
		string strBookShortName = GetFileName(strFullFileName, TRUE); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		if ( !bAutoRename && bRenameWkBk )
		{
			TreeNode trWkBkTrimFNameFrom	= tree_get_node_by_id(trFilter, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, true);
			TreeNode trWkBkTrimFNameTo		= tree_get_node_by_id(trFilter, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, true);
			if(trWkBkTrimFNameFrom && trWkBkTrimFNameTo)
			{
				_getTrimFileName(strBookName, trWkBkTrimFNameFrom.nVal, trWkBkTrimFNameTo.nVal);
				_getTrimFileName(strBookShortName, trWkBkTrimFNameFrom.nVal, trWkBkTrimFNameTo.nVal); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
			}
		}
		if ( bIncludePathWhenRenameBook )
			strBookName = GetFilePath(strFullFileName) + strBookName;
		
		Page pg;
		//Layer ly;
		Datasheet ds;
		int nC1, nC2;
		
		int nRanges = drTarget.GetNumData();
		for ( int nIndexSubRange = 0; nIndexSubRange < nRanges; nIndexSubRange++ )
		{
			// get target sheet and page
			Page pgOld;
			if ( pg )
				pgOld = pg;
			Datasheet dsOld;
			if ( ds )
				dsOld = ds;
			
			if ( !drTarget.GetRange(ds, nC1, nC2, nIndexSubRange) )
				continue;
			if ( !ds )
				continue;
			
			ds.GetParent(pg);
			
			bool bSameBook = ( (nIndexSubRange > 0) && pgOld.GetName() == pg.GetName() );
			bool bSameSheet = ( (nIndexSubRange > 0) && bSameBook && (dsOld.GetName() == ds.GetName()) );
			
			//*********** rename sheet ************
			if ( !bSameSheet )
			{
				//strNewName = GetFileName(strFullFileName, TRUE);
				//if ( bRenameWks )
				if ( (!bAutoRename && bRenameWks) || (bAutoRename && !isImported((Layer)ds)) )
				{
					//if ( ASCIMP_MODE_NEW_BOOKS == nImportMode )
					//{
						//foreach( Layer ly in pg.Layers )
							//ly.SetName(strNewName, OCD_ENUM_NEXT);
					//}
					//else
						//ly.SetName(strNewName, OCD_ENUM_NEXT);
					/// need trim space as sheet name not allow space at each end
					strSheetName.TrimLeft();
					strSheetName.TrimRight();
					//------ CPY 5/17/07 QA70-9793 ADD_UNDERSCORE_BEFORE_ENUM_IF_END_WITH_NUMBERS 
					//ds.SetName(strSheetName, OCD_ENUM_NEXT);
					ds.SetName(strSheetName, OCD_ENUM_NEXT | OCD_ENUM_ADD_SEPARATOR);
					//------
				}
			}
	
			//*********** rename book ************
			if ( !bSameBook )
			{
				//strNewName = GetFileName(strFullFileName, FALSE);
				
				// book short name
				//if( bRenameWkBk )
					//pgTarget.Rename(strNewName);
					
				//if ( bIncludePathWhenRenameBook )
					//strNewName = strFullFileName;
				
				string strLongName = pg.GetLongName();
				bool bEmptyBookLongName = ( strLongName.IsEmpty() || strLongName == pg.GetName() );
					
				// book long name
				if( (!bAutoRename && bRenameWkBk) || (bAutoRename && bEmptyBookLongName) )
				///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
				{
				///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
					pg.SetLongName(strBookName);
				///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
					if ( !bRenameWkBkLongNameOnly )
					{
						//strBookShortName.MakeValidCName();
						pg.SetName(strBookShortName, OCD_ENUM_NEXT);
					}
				}
				///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
			}
			
			//*********** append to comment ************
			strNewName = GetFileName(strFullFileName, FALSE);
			if ( bIncludePath )
				strNewName = strFullFileName;
			
			// add book comment
			if ( !bSameBook )
			{
				///---Sim 03-20-2007 FIX_APPEND_COMMENT_WHEN_REIMPORT
				//if( bAppendWkBkComm )
				//{
				string strComments;
				strComments = pg.GetComments();
				
				if ( dwCtrl & COVER_LAST_ADDED_COMMENT )
					remove_last_added_filename_comment(strComments, strFullFileName);

				/// Hong 08/26/09 QA80-13839 FIX_ORIGIN_CRASH_DUE_TO_BUFFER_OVERFLOW_WHEN_OPJ_CONTAIN_HUGE_PAGE_COMMENT
				//if ( bAppendWkBkComm )
				if ( bAppendWkBkComm && !_is_comment_size_exceed_limitation(strComments.GetLength() + strNewName.GetLength() + 2/*"\r\n"*/) )
				/// end FIX_ORIGIN_CRASH_DUE_TO_BUFFER_OVERFLOW_WHEN_OPJ_CONTAIN_HUGE_PAGE_COMMENT
				{
					if( !strComments.IsEmpty() )
						strComments += "\r\n";
					strComments += strNewName;
				}
				
				pg.SetComments(strComments);
				//}
				///---END FIX_APPEND_COMMENT_WHEN_REIMPORT
			}
			
			// add column comment
			///---Sim 03-20-2007 FIX_APPEND_COMMENT_WHEN_REIMPORT
			//if( bAppendColComm )
			//{
			Worksheet wks = ds;
			if ( wks )
			{
				///---Sim 09-02-2009 QA81-14236 FIX_SHOULD_NOT_CHANGE_COMMENT_FORMAT
				// Test #9476-P2 work fine if remove this fix. Maybe sb. fix it on low level.
				/////---Sim 05-09-2007 QA80-9476-P2 FIX_SET_FULL_PATH_TO_COL_COMM
				//if ( !wks_set_label_text_control(wks, RCLT_COMMENT, WKS_LABEL_TEXT_CONTROL_EDIT) )
					//error_report(_L("Failed to change wks label text style control!"));
				/////---END QA80-9476-P2 FIX_SET_FULL_PATH_TO_COL_COMM
				///---END QA81-14236 FIX_SHOULD_NOT_CHANGE_COMMENT_FORMAT
				
				/// Hong 12/27/07 QA80-10541 FIX_NONNUMERIC_FAIL_WORK_BY_RUNTIME_ERROR
				//if ( -1 == nC2 )
				if ( -1 == nC2 || nC2 >= wks.GetNumCols() )
				/// end FIX_NONNUMERIC_FAIL_WORK_BY_RUNTIME_ERROR
					nC2 = wks.GetNumCols() - 1;
				
				string strComments;
				for ( int ii = nC1; ii <= nC2; ii++ )
				{
					Column col(wks, ii);
					strComments = col.GetComments();
					
					if ( dwCtrl & COVER_LAST_ADDED_COMMENT )
						remove_last_added_filename_comment(strComments, strFullFileName);
					/// Hong 08/26/09 QA80-13839 FIX_ORIGIN_CRASH_DUE_TO_BUFFER_OVERFLOW_WHEN_OPJ_CONTAIN_HUGE_PAGE_COMMENT
					//if ( bAppendColComm )
					if ( bAppendColComm && !_is_comment_size_exceed_limitation(strComments.GetLength() + strNewName.GetLength() + 2/*"\r\n"*/) )
					/// end FIX_ORIGIN_CRASH_DUE_TO_BUFFER_OVERFLOW_WHEN_OPJ_CONTAIN_HUGE_PAGE_COMMENT
					{
						if( !strComments.IsEmpty() )
							strComments += "\r\n";
						strComments += strNewName;
					}
					
					col.SetComments(strComments);
				}
				/// Hong 03/17/08 QA80-11162 ALLOW_OC_AUTO_SIZE_COMMENT_HEIGHT
				//--- CPY 7/22/08 QA70-11868 SHOW_COMMENTS_SAMPLE_INTERVAL_SHOULD_AUTO_SIZE_ROW_HEIGHT
				//wks.AutoHeightComment();
				wks.AutoSizeRow(RCLT_COMMENT, 1);
				//---
				/// end ALLOW_OC_AUTO_SIZE_COMMENT_HEIGHT
			}
			///Sophy 6/11/2010 ORG-220-S3 ADD_IMPORT_OPTIONS_TO_CONTROL_RENAME_RESULT_BOOKSHEET
			MatrixLayer ml(ds);
			if ( ml )
			{
				if ( nC2 == -1 || nC2 >= ml.MatrixObjects.Count() )
					nC2 = ml.MatrixObjects.Count() - 1;
				string strComments;
				for ( int ii = nC1; ii <= nC2; ii++ )
				{
					MatrixObject mo(ml, ii);
					strComments = mo.GetComments();
					if ( dwCtrl & COVER_LAST_ADDED_COMMENT )
						remove_last_added_filename_comment(strComments, strFullFileName);
					if ( bAppendColComm && !_is_comment_size_exceed_limitation(strComments.GetLength() + strNewName.GetLength() + 2/*"\r\n"*/) )
					{
						if( !strComments.IsEmpty() )
							strComments += "\r\n";
						strComments += strNewName;
					}
					mo.SetComments(strComments)
				}
			}
			///end ADD_IMPORT_OPTIONS_TO_CONTROL_RENAME_RESULT_BOOKSHEET
			//}
			///---END FIX_APPEND_COMMENT_WHEN_REIMPORT
		}
		
		//if ( bRenameWks && bRenameWkBk )// && bAppendWkBkComm)
			//updataImportFileRangeInfo(pg);
	}
	return true;
}
///---END ADD_AUTO_RENAME

//// AW 09/29/06 QA80-9015 MORE_ON_IMPORT_SINGLE_ASCII_FILE
BOOL GetRangeInfo(Range& orng, Datasheet& lyTarget, Page& pgTarget, int& c1,int& c2)
{
	///---Sim 03-17-2007 CHECK_ERROR_FOR_INVALID_RANGE
	if ( !orng || 0 == orng.GetNumData() )
		return false;
	///---END CHECK_ERROR_FOR_INVALID_RANGE
	orng.GetRange(lyTarget, c1, c2);
	if ( lyTarget )
	{
		lyTarget.GetParent(pgTarget);
		return true;
	}
	return false;
}
//// END MORE_ON_IMPORT_SINGLE_ASCII_FILE

///---Sim 10-30-2006 ERROR_MESSAGE
bool is_valid_filename(const string &strFileName, int &nFileIdx)
{
	int nRet;
	nFileIdx = 0; // meaning of no invalid file name
	
	StringArray vsFileNames;
	nRet = separate_multiline_files(strFileName, vsFileNames, &nFileIdx); 
	
	// invalid file name;
	if ( 0 != nFileIdx )
		return false;
	
	// not found invalid file name, and also no valid file name. (All file names are empty!)
	if ( 0 == nRet )
	{
		nFileIdx = -1; // file name empty
		return false;
	}
	
	return true; // no invalid file name;
}
///---END ERROR_MESSAGE

///---Sim 11-20-2006 SUPPORT_DND_OPEN_DIALOG
bool check_imported_file_name(const string& strFileName, string& strErr)
{
	int nErrCode = CER_NO_ERROR;
	int nInvalidFileIdx = 0;
	if( strFileName.IsEmpty())
	{
		nErrCode = IMPERR_EMPTY_FILENAME_TIPS;
	}
	else if( !is_valid_filename(strFileName, nInvalidFileIdx) )
	{
		if ( 0 < nInvalidFileIdx )
			nErrCode = CER_INVALID_FILENAME_INDEX;
		else
			nErrCode = IMPERR_EMPTY_FILENAME_TIPS;
	}
	
	if(CER_NO_ERROR != nErrCode)
	{
		strErr = nErrCode;
		
		if ( CER_INVALID_FILENAME_INDEX == nErrCode )
		{
			strErr += ":";
			strErr += nInvalidFileIdx;
		}
		
		return false;
	}
	
	return true;
}
///---END SUPPORT_DND_OPEN_DIALOG

///---Sim 11-30-2006 CHECK_EXPORTED_FILE_NAME
bool check_exported_file_name(const string& strFileName, string& strErr)
{
	if( strFileName.IsEmpty())
	{
		strErr = IMPERR_EMPTY_FILENAME_TIPS;
		return false;
	}
	
	/// Iris 07/13/2007 v8.0659 SHARE_CHECK_PATH_CODES_FOR_ALL_EXPORT_XFS
	/*
	if( !is_str_valid_for_filename(GetFileName(strFileName)) )
	{
		strErr = CER_INVALID_FILENAME;
		return false;
	}
	
	if( !GetFilePath(strFileName).IsPath() )
	{
		/// Iris 07/04/2007 v8.0655 CREATE_PATH_IF_SPECIFIED_PATH_IS_NOT_EXISTED
		// this function only used  in expImage and expPDF now, so change the logic by new design
		//strErr = CER_INVALID_FILEPATH;
		//return false;
		strErr = XFWARN_WILL_CREATE_NONEXISTING_PATH;
		return true;
		///end CREATE_PATH_IF_SPECIFIED_PATH_IS_NOT_EXISTED
	}
	*/
	bool bOK = true;
	check_relative_path(strFileName, false, &strErr, &bOK);
	if( !bOK )
		return false;
	///end SHARE_CHECK_PATH_CODES_FOR_ALL_EXPORT_XFS
	
	///---Sim 06-05-2007 WARNING_EXPORT_TO_EXISTING_FILE
	if ( strFileName.IsFile() )
	{
		strErr = EXPWARN_FILE_EXIST;
		strErr += ":";
		strErr += GetFileName(strFileName);
	}
	///---END WARNING_EXPORT_TO_EXISTING_FILE
	
	return true;
}
///---END CHECK_EXPORTED_FILE_NAME

///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
#define STR_FILTER_GUI_TREE "guitree"

bool is_filter_gui_tree(TreeNode &trFilter)
{
	TreeNode tr = trFilter.GetNode(STR_FILTER_GUI_TREE);
	if ( tr && tr.nVal > 0 )
		return true;
	return false;
}

static void add_filter_gui_tree_tag(TreeNode &trFilter)
{
	if ( !is_filter_gui_tree(trFilter) )
	{
		TreeNode tr = trFilter.AddNode(STR_FILTER_GUI_TREE);
		tr.nVal = 1;
	}
}

//#define GETN_NUM_L(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) _tmpSubNode = _tmpNode.AddNumericNode(_DEFAULT_VAL, cvt_str_to_tag_name(_NODE_NAME), TRGP_DOUBLE);TREE_ADD_LABEL(_NODE_LABEL);
//#define GETN_CHECK_L(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, cvt_str_to_tag_name(_NODE_NAME), TRGP_CHECK);TREE_ADD_LABEL(_NODE_LABEL);
//#define GETN_STR_L(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)	_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, cvt_str_to_tag_name(_NODE_NAME), TRGP_STR);TREE_ADD_LABEL(_NODE_LABEL);
#define GETN_BEGIN_BRANCH_L(_NODE_NAME, _NODE_LABEL) 	_tmpSubNode = _tmpNode.AddNode(cvt_str_to_tag_name(_NODE_NAME), TRGP_BRANCH);TREE_ADD_LABEL(_NODE_LABEL);\
TreeNode _tmSave_##_NODE_NAME = _tmpNode; _tmpNode = _tmpSubNode;
#define GETN_END_BRANCH_L(_NODE_NAME)					_tmpNode = _tmSave_##_NODE_NAME;

#define GETN_VEC_INT_L(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) _tmpSubNode = _tmpNode.AddNode(cvt_str_to_tag_name(#_NODE_NAME)); _tmpSubNode.nVals = _DEFAULT_VAL; TREE_ADD_LABEL(_NODE_LABEL);


void fuPrepareDefaultFilterGUITree(TreeNode& trFilterGUI, int nFilterType)
{
	/*
	trFilterGUI.Reset();

	GETN_USE(trFilterGUI)
		GETN_NUM(guitree, _L("Is guitree"), 1)
	
		GETN_NUM(OriginVersion, _L("OriginVersion"), 0) GETN_ID(IDE_DISP_IMP_ORIGINVER)
		GETN_NUM(Type, _L("Type"), 0) GETN_ID(IDE_DISP_IMP_TYPE)
		
		GETN_BEGIN_BRANCH_L(IMPORT_FILTER_DISPIMP, _L(IMPORT_FILTER_DISPIMP))
			GETN_NUM(ApplyRangeToGraph, _L("ApplyRangeToGraph"), 0) GETN_ID(IDE_DISP_IMP_RANGETOGRAPH)
			GETN_NUM(LinkWks, _L("LinkWks"), 0) GETN_ID(IDE_DISP_IMP_LINKWKS)
			GETN_STR(ColDesignations, _L("ColDesignations"), "") GETN_ID(IDE_DISP_IMP_COLDESIGN)
			GETN_NUM(ColDesignationsRepetitive, _L("ColDesignationsRepetitive"), 0) GETN_ID(IDE_DISP_IMP_COLDESIGNREP)
			GETN_STR(ColFormats, _L("ColFormats"), "") GETN_ID(IDE_DISP_IMP_COLFORMATS)
			GETN_NUM(PlotType, _L("PlotType"), 0) GETN_ID(IDE_DISP_IMP_PLOTTYPE)
			GETN_STR(PlotTemplate, _L("PlotTemplate"), "") GETN_ID(IDE_DISP_IMP_PLOTTEMPLATE)
			GETN_NUM(TargetWindowType, _L("TargetWindowType"), 0) GETN_ID(IDE_DISP_IMP_PAGETYPE)
			GETN_STR(TargetWindowTemplate, _L("TargetWindowTemplate"), "") GETN_ID(IDE_DISP_IMP_PAGETEMPLATE)
			GETN_STR(FilenameToWksLabel, _L("FilenameToWksLabel"), "") GETN_ID(IDE_DISP_IMP_FNAMETOWKSLAB)
			GETN_STR(FileSpec, _L("FileSpec"), "") GETN_ID(IDE_DISP_IMP_FILESPEC)
			GETN_STR(Description, _L("Description"), "") GETN_ID(IDE_DISP_IMP_DESCRIPTION)
			GETN_CHECK(Sparklines, _L("Sparklines"), 0) GETN_ID(IDE_DISP_IMP_SPARKLINES)
			GETN_CHECK(AutoRename, _L("AutoRename"), 0) GETN_ID(IDE_DISP_IMP_AUTO_RENAME)
			GETN_NUM(WksTrimFNameFrom, _L("WksTrimFNameFrom"), 0) GETN_ID(IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM)
			GETN_NUM(WksTrimFNameTo, _L("WksTrimFNameTo"), 0) GETN_ID(IDE_DISPIMP_RENAMEWKSTRIMFNAMETO)
			GETN_NUM(WkBkTrimFNameFrom, _L("WkBkTrimFNameFrom"), 0) GETN_ID(IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM)
			GETN_NUM(WkBkTrimFNameTo, _L("WkBkTrimFNameTo"), 0) GETN_ID(IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO)
			GETN_CHECK(AddToFileOpen, _L("AddToFileOpen"), 0) GETN_ID(IDE_DISPIMP_SHOWFILTERINOPENLIST)
			GETN_NUM(FirstMode, _L("FirstMode"), 0) GETN_ID(IDE_DISPIMP_1STMODE)
		GETN_END_BRANCH_L(IMPORT_FILTER_DISPIMP)
		
	switch(nFilterType)
	{
	case FILTER_TYPE_ASCII:
		GETN_BEGIN_BRANCH_L(IMPORT_FILTER_ASCIMP, _L(IMPORT_FILTER_ASCIMP))
			GETN_NUM(Delimited, _L("Delimited"), 0) GETN_ID(IDE_ASCIMP_DELIMITED)
			GETN_NUM(Delimiter, _L("Delimiter"), 0) GETN_ID(IDE_ASCIMP_DELIMCODE)
			GETN_STR(Char, _L("Char"), "") GETN_ID(IDE_ASCIMP_DELIMCHAR)
			GETN_STR(FixedWidth, _L("FixedWidth"), "") GETN_ID(IDE_ASCIMP_COLWIDTHS)
			GETN_NUM(HeaderLines, _L("HeaderLines"), 0) GETN_ID(IDE_ASCIMP_HEADLINES)
			GETN_NUM(SubHeaderLines, _L("SubHeaderLines"), 0) GETN_ID(IDE_ASCIMP_SUBHEADLINES)
			GETN_NUM(AutoSubHeaderLines, _L("AutoSubHeaderLines"), 0) GETN_ID(IDE_ASCIMP_AUTOSUBHEAD)
			GETN_NUM(AutoColTypes, _L("AutoColTypes"), 0) GETN_ID(IDE_ASCIMP_AUTOCOLTYPES)
			GETN_NUM(TestLines, _L("TestLines"), 0) GETN_ID(IDE_ASCIMP_TESTLINES)
			GETN_NUM(Mode, _L("Mode"), 0) GETN_ID(IDE_ASCIMP_IMPORTMODE)
			GETN_NUM(NumColumns, _L("NumColumns"), 0) GETN_ID(IDE_ASCIMP_NUMCOLUMNS)
			GETN_NUM(Partial, _L("Partial"), 0) GETN_ID(IDE_ASCIMP_PARTIAL)
			GETN_NUM(PartialC1, _L("PartialC1"), 0) GETN_ID(IDE_ASCIMP_PARTIALC1)
			GETN_NUM(PartialC2, _L("PartialC2"), 0) GETN_ID(IDE_ASCIMP_PARTIALC2)
			GETN_NUM(PartialR1, _L("PartialR1"), 0) GETN_ID(IDE_ASCIMP_PARTIALR1)
			GETN_NUM(PartialR2, _L("PartialR2"), 0) GETN_ID(IDE_ASCIMP_PARTIALR2)
			GETN_NUM(RenameWks, _L("RenameWks"), 0) GETN_ID(IDE_ASCIMP_RENAMEWKS)
			GETN_NUM(ApplyRange, _L("ApplyRange"), 0) GETN_ID(IDE_ASCIMP_APPLYRANGE)
			GETN_NUM(RenameCols, _L("RenameCols"), 0) GETN_ID(IDE_ASCIMP_RENAMECOLS)
			GETN_NUM(Labels, _L("Labels"), 0) GETN_ID(IDE_ASCIMP_LABEL)
			GETN_NUM(MaxLabels, _L("MaxLabels"), 0) GETN_ID(IDE_ASCIMP_MAXLABELS)
			GETN_NUM(LeadingZeroes, _L("LeadingZeroes"), 0) GETN_ID(IDE_ASCIMP_LEADZERO)
			GETN_NUM(Nonnumeric, _L("Nonnumeric"), 0) GETN_ID(IDE_ASCIMP_NONNUMERIC)
			GETN_NUM(MaxTestLines, _L("MaxTestLines"), 0) GETN_ID(IDE_ASCIMP_MAXTESTLINES)
			GETN_NUM(SkipRows, _L("SkipRows"), 0) GETN_ID(IDE_ASCIMP_SKIPROWS)
			GETN_NUM(ReadRows, _L("ReadRows"), 0) GETN_ID(IDE_ASCIMP_READROWS)
			GETN_STR(DateFormat, _L("DateFormat"), "") GETN_ID(IDE_ASCIMP_DATEFORMAT)
			GETN_NUM(LabelSkipChars, _L("LabelSkipChars"), 0) GETN_ID(IDE_ASCIMP_SKIPCHARS)
			GETN_NUM(LongNames, _L("LongNames"), 0) GETN_ID(IDE_ASCIMP_LONGNAMES)
			GETN_NUM(Units, _L("Units"), 0) GETN_ID(IDE_ASCIMP_UNITS)
			GETN_NUM(FirstParams, _L("FirstParams"), 0) GETN_ID(IDE_ASCIMP_FIRSTPARAMS)
			GETN_NUM(NumParams, _L("NumParams"), 0) GETN_ID(IDE_ASCIMP_NUMPARAMS)
			GETN_NUM(FirstUserParams, _L("FirstUserParams"), 0) GETN_ID(IDE_ASCIMP_FIRSTUSERPARAMS)
			GETN_NUM(NumUserParams, _L("NumUserParams"), 0) GETN_ID(IDE_ASCIMP_NUMUSERPARAMS)
			GETN_NUM(FirstSave, _L("FirstSave"), 0) GETN_ID(IDE_ASCIMP_FIRSTSAVE)
			GETN_NUM(NumSave, _L("NumSave"), 0) GETN_ID(IDE_ASCIMP_NUMSAVE)
			GETN_NUM(flags, _L("flags"), 0) GETN_ID(IDE_ASCIMP_FLAGS)
			GETN_NUM(NumSep, _L("NumSep"), 0) GETN_ID(IDE_ASCIMP_NUMSEP)
			GETN_NUM(SpeFmt, _L("SpeFmt"), 0) GETN_ID(IDE_ASCIMP_SPECIALFORMAT)
			GETN_STR(Delimiters, _L("Delimiters"), "") GETN_ID(IDE_ASCIMP_DELIMITERS)
			GETN_STR(DelimitersArray, _L("DelimitersArray"), "") GETN_ID(IDE_ASCIMP_DELIMITERSARRAY)
			GETN_STR(Quote, _L("Quote"), "") GETN_ID(IDE_ASCIMP_QUOTECHAR)
			GETN_STR(Version, _L("Version"), "") GETN_ID(IDE_ASCIMP_VERSION)
		GETN_END_BRANCH_L(IMPORT_FILTER_ASCIMP)
		break;
	case FILTER_TYPE_BINARY:
		GETN_BEGIN_BRANCH_L(IMPORT_FILTER_BINIMP, _L(IMPORT_FILTER_BINIMP))
			GETN_NUM(HeaderBytes, _L("HeaderBytes"), 0) GETN_ID(IDE_BINIMP_HEADERBYTES)
			GETN_NUM(AutoColTypes, _L("AutoColTypes"), 0) GETN_ID(IDE_BINIMP_HEADERBYTES)
			GETN_NUM(NumColumns, _L("NumColumns"), 0) GETN_ID(IDE_BINIMP_NUMCOLUMNS)
			GETN_NUM(Partial, _L("Partial"), 0) GETN_ID(IDE_BINIMP_PARTIAL)
			GETN_NUM(PartialC1, _L("PartialC1"), 0) GETN_ID(IDE_BINIMP_PARTIALC1)
			GETN_NUM(PartialC2, _L("PartialC2"), 0) GETN_ID(IDE_BINIMP_PARTIALC2)
			GETN_NUM(PartialR1, _L("PartialR1"), 0) GETN_ID(IDE_BINIMP_PARTIALR1)
			GETN_NUM(PartialR2, _L("PartialR2"), 0) GETN_ID(IDE_BINIMP_PARTIALR2)
			GETN_NUM(RenameWks, _L("RenameWks"), 0) GETN_ID(IDE_BINIMP_RENAMEWKS)
			GETN_NUM(BigEndian, _L("BigEndian"), 0) GETN_ID(IDE_BINIMP_BIGENDIAN)
			GETN_NUM(ApplyRange, _L("ApplyRange"), 0) GETN_ID(IDE_BINIMP_APPLYRANGE)
			GETN_NUM(Mode, _L("Mode"), 0) GETN_ID(IDE_BINIMP_MODE)
			GETN_NUM(SkipRows, _L("SkipRows"), 0) GETN_ID(IDE_BINIMP_SKIPROWS)
			GETN_NUM(ReadRows, _L("ReadRows"), 0) GETN_ID(IDE_BINIMP_READROWS)
			vector<byte> vbEmpty;
			vector<DWORD> vdwEmpty;
			GETN_VEC_INT_L(ParamType, _L("ParamType"), vbEmpty); GETN_ID(IDE_BINIMP_PARAMTYPE)
			GETN_VEC_INT_L(ParamSize, _L("ParamSize"), vdwEmpty); GETN_ID(IDE_BINIMP_PARAMSIZE)
			GETN_VEC_INT_L(ParamCount, _L("ParamCount"), vdwEmpty); GETN_ID(IDE_BINIMP_PARAMCOUNT)
			GETN_NUM(flags, _L("flags"), 0) GETN_ID(IDE_BINIMP_FLAGS)
		GETN_END_BRANCH_L(IMPORT_FILTER_BINIMP)
		break;
	case FILTER_TYPE_USERDEFINED:
		GETN_BEGIN_BRANCH_L(IMPORT_FILTER_USERDEFIMP, _L(IMPORT_FILTER_USERDEFIMP))
			GETN_STR(PostImportScript, _L("PostImportScript"), "") GETN_ID(IDE_USERDEFIMP_POSTIMPSCRIPT)
			GETN_STR(OCFile, _L("OCFile"), "") GETN_ID(IDE_USERDEFIMP_FILE)
			GETN_STR(OCFunction, _L("OCFunction"), "") GETN_ID(IDE_USERDEFIMP_FUNCTION)
			GETN_STR(OCClass, _L("OCClass"), "") GETN_ID(IDE_USERDEFIMP_CLASS)
		GETN_END_BRANCH(IMPORT_FILTER_USERDEFIMP)
		break;
	case FILTER_TYPE_XFUNC:
		GETN_BEGIN_BRANCH_L(IMPORT_FILTER_XFIMP, _L(IMPORT_FILTER_XFIMP))
			GETN_NUM(RenameWks, _L("RenameWks"), 0) GETN_ID(IDE_XFIMP_RENAMEWKS)
			GETN_NUM(RenameWkBk, _L("RenameWkBk"), 0) GETN_ID(IDE_XFIMP_FILENAME2WKBK)
			GETN_NUM(IncludePathForWkBk, _L("IncludePathForWkBk"), 0) GETN_ID(IDE_XFIMP_ADDPATH4WKBK)
			GETN_NUM(AppendWkBkComm, _L("AppendWkBkComm"), 0) GETN_ID(IDE_XFIMP_FILENAME2WKBKCOMMENT)
			GETN_NUM(AppendColComm, _L("AppendColComm"), 0) GETN_ID(IDE_XFIMP_FILENAME2COLCOMMENT)
			GETN_NUM(IncludePath, _L("IncludePath"), 0) GETN_ID(IDE_XFIMP_ADDPATH)
			GETN_NUM(RemoveQuotes, _L("RemoveQuotes"), 0) GETN_ID(IDE_XFIMP_REMOVE_QUOTES)
			GETN_NUM(flags, _L("flags"), 0) GETN_ID(IDE_XFIMP_FLAGS)
			GETN_STR(Name, _L("Name"), "") GETN_ID(IDE_XFIMP_NAME)
			GETN_CHECK(OpenSetting, _L("OpenSetting"), 0) GETN_ID(IDE_XFIMP_OPENSETTING)
			GETN_NUM(Mode, _L("Mode"), 0) GETN_ID(IDE_XFIMP_IMPORTMODE)
			GETN_CHECK(ShowTime, _L("ShowTime"), 0) GETN_ID(IDE_XFIMP_OPSHOWTIME)
			GETN_NUM(PartialImport, _L("PartialImport"), 0) GETN_ID(IDE_XFIMP_PARTIAL_IMPORT)
			GETN_NUM(ReadPoint, _L("ReadPoint"), 0) GETN_ID(IDE_XFIMP_READ_POINT)
			GETN_NUM(SkipPoint, _L("SkipPoint"), 0) GETN_ID(IDE_XFIMP_SKIP_POINT)
			GETN_NUM(StartPoint, _L("StartPoint"), 0) GETN_ID(IDE_XFIMP_START_POINT)
			GETN_NUM(EndPoint, _L("EndPoint"), 0) GETN_ID(IDE_XFIMP_END_POINT)
			GETN_NUM(ColStartPoint, _L("ColStartPoint"), 0) GETN_ID(IDE_XFIMP_COL_START_POINT)
			GETN_NUM(ColEndPoint, _L("ColEndPoint"), 0) GETN_ID(IDE_XFIMP_COL_END_POINT)
			GETN_NUM(StartTime, _L("StartTime"), 0) GETN_ID(IDE_XFIMP_START_TIME)
			GETN_NUM(EndTime, _L("EndTime"), 0) GETN_ID(IDE_XFIMP_END_TIME)
		GETN_END_BRANCH_L(IMPORT_FILTER_XFIMP)
		break;
	default:
		error_report("Failed to contruct filter gui tree");
		break;
	}	
	
	Tree trFilter;
	fuPrepareDefault(trFilter, nFilterType);
	tree_copy_values_by_id(trFilter, trFilterGUI);
	*/
	
	fuPrepareDefault(trFilterGUI, nFilterType);
	
	// set tagname for user, they will be used on script window
	StringArray saOld;
	StringArray saNew;
	_generate_filter_gui_tree_tagname(saOld, saNew);
	tree_rename_tags(trFilterGUI, saOld, saNew);
	
	add_filter_gui_tree_tag(trFilterGUI);
}

static void _generate_filter_gui_tree_tagname(StringArray& saOld, StringArray& saNew)
{
	saOld.RemoveAll();
	saNew.RemoveAll();
	
	//saOld.Add();
	//saNew.Add("OriginVersion");
	
	//saOld.Add();
	//saNew.Add("Type");
	
	// display
	saOld.Add("iApplyRangeToGraph");
	saNew.Add("ApplyRangeToGraph");
	
	saOld.Add("iLinkWks");
	saNew.Add("LinkWks");
	
	saOld.Add("strColDesignations");
	saNew.Add("ColDesignations");
	
	saOld.Add("iColDesignationsRepetitive");
	saNew.Add("ColDesignationsRepetitive");
	
	saOld.Add("strColFormats");
	saNew.Add("ColFormats");
	
	saOld.Add("iPlotType");
	saNew.Add("PlotType");
	
	saOld.Add("strPlotTemplate");
	saNew.Add("PlotTemplate");
	
	saOld.Add("iTargetWindowType");
	saNew.Add("WinType");  //saNew.Add("TargetWindowType");
	
	saOld.Add("strTargetWindowTemplate");
	saNew.Add("WinTemplate"); //saNew.Add("TargetWindowTemplate");
	
	saOld.Add("strFilenameToWksLabel");
	saNew.Add("FilenameToWksLabel");
	
	saOld.Add("strFileSpec");
	saNew.Add("FNameFilter");//saNew.Add("FileSpec");
	
	saOld.Add("strDescription");
	saNew.Add("Description");
	
	///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
	//saOld.Add("bSparklines");
	saOld.Add("nSparklines");
	saNew.Add("Sparklines");
	///---END SUPPORT_SMART_SPARKLINE
	
	saOld.Add("bAutoRename");
	saNew.Add("AutoNames"); //saNew.Add("AutoRename");
	
	saOld.Add("iWksTrimFNameFrom");
	saNew.Add("FNameToShtFrom");  	//saNew.Add("WksTrimFNameFrom");
	
	saOld.Add("iWksTrimFNameTo");
	saNew.Add("FNameToShtTo");  //saNew.Add("WksTrimFNameTo");
	
	saOld.Add("iWkBkTrimFNameFrom");
	saNew.Add("FNameToBkFrom"); //saNew.Add("WkBkTrimFNameFrom");
	
	saOld.Add("iWkBkTrimFNameTo");
	saNew.Add("FNameToBkTo"); //saNew.Add("WkBkTrimFNameTo");
	
	saOld.Add("bAddToFileOpen");
	saNew.Add("AddToFileOpen");
	
	saOld.Add("i1stMode");
	saNew.Add("FirstMode");
	
	// ASCII
	saOld.Add("iDelimited");
	saNew.Add("DataStruct"); //saNew.Add("Delimited");
	
	saOld.Add("iDelimiter");
	saNew.Add("Delimiter");
	
	saOld.Add("cChar");
	saNew.Add("OtherDelimiter"); //saNew.Add("Char");
	
	saOld.Add("szFixedWidth");
	saNew.Add("FixedWidth");
	
	saOld.Add("iHeaderLines");
	saNew.Add("HdrLns");  //saNew.Add("HeaderLines");
	
	saOld.Add("iSubHeaderLines");
	saNew.Add("SubHdrLns"); //saNew.Add("SubHeaderLines");
	
	saOld.Add("iAutoSubHeaderLines");
	saNew.Add("AutoSubHdr"); //saNew.Add("AutoSubHeaderLines");
	
	saOld.Add("iAutoColTypes");
	saNew.Add("AutoColTypes");
	
	saOld.Add("iTestLines");
	saNew.Add("MinTestLns");
	
	saOld.Add("iMode");
	saNew.Add("Mode");
	
	saOld.Add("iNumColumns");
	saNew.Add("NumCols"); //saNew.Add("NumColumns");
	
	saOld.Add("iPartial");
	saNew.Add("Partial");
	
	saOld.Add("iPartialC1");
	saNew.Add("FirstCol"); //saNew.Add("PartialC1");
	
	saOld.Add("iPartialC2");
	saNew.Add("LastCol"); //saNew.Add("PartialC2");
	
	saOld.Add("iPartialR1");
	saNew.Add("FirstRow"); //saNew.Add("PartialR1");
	
	saOld.Add("iPartialR2");
	saNew.Add("LastRow"); //saNew.Add("PartialR2");
	
	saOld.Add("iRenameWks");
	saNew.Add("FNameToSht");
	
	saOld.Add("iApplyRange");
	saNew.Add("ApplyRange");
	
	saOld.Add("iRenameCols");
	saNew.Add("SNames");
	
	saOld.Add("iLabels");
	saNew.Add("Labels");
	
	saOld.Add("iMaxLabels");
	saNew.Add("MaxLabels");
	
	saOld.Add("iLeadingZeroes");
	saNew.Add("LeadingZeroes");
	
	saOld.Add("iNonnumeric");
	saNew.Add("NonNum"); //saNew.Add("Nonnumeric");
	
	saOld.Add("iMaxTestLines");
	saNew.Add("MaxTestLns");
	
	saOld.Add("iSkipRows");
	saNew.Add("SkipRows");
	
	saOld.Add("iReadRows");
	saNew.Add("ReadRows");
	
	saOld.Add("szDateFormat");
	saNew.Add("DateFormat");
	
	saOld.Add("iLabelSkipChars");
	saNew.Add("LabelSkipChars");
	
	saOld.Add("nLongNames");
	saNew.Add("LNames"); //saNew.Add("LongNames");
	
	saOld.Add("nUnits");
	saNew.Add("Units");
	
	saOld.Add("nFirstParams");
	saNew.Add("ParamsFrom"); //saNew.Add("FirstParams");
	
	saOld.Add("nNumParams");
	saNew.Add("ParamsTo"); //saNew.Add("NumParams");
	
	saOld.Add("nFirstUserParams");
	saNew.Add("UParamsFrom"); //saNew.Add("FirstUserParams");
	
	saOld.Add("nNumUserParams");
	saNew.Add("UParamsTo"); //saNew.Add("NumUserParams");
	
	saOld.Add("nFirstSave");
	saNew.Add("SaveLnsFrom");
	
	saOld.Add("nNumSave");
	saNew.Add("SaveLnsTo");
	
	//saOld.Add("flags");
	//saNew.Add("flags");
	
	saOld.Add("nNumSep");
	saNew.Add("NumSep");
	
	saOld.Add("nSpeFmt");
	saNew.Add("SpeFmt");
	
	saOld.Add("cDelimiters");
	saNew.Add("Delimiters");
	
	saOld.Add("cDelimitersArray");
	saNew.Add("DelimitersArray");
	
	saOld.Add("cQuote");
	saNew.Add("Quote");
	
	saOld.Add("cVersion");
	saNew.Add("Version");

	// BINARY
	saOld.Add("iHeaderBytes");
	saNew.Add("HdrBytes"); //saNew.Add("HeaderBytes");
	
	//saOld.Add("iAutoColTypes");
	//saNew.Add("AutoColTypes");
	
	//saOld.Add("iNumColumns");
	//saNew.Add("NumColumns");
	
	//saOld.Add("iPartial");
	//saNew.Add("Partial");
	//
	//saOld.Add("iPartialC1");
	//saNew.Add("PartialC1");
	//
	//saOld.Add("iPartialC2");
	//saNew.Add("PartialC2");
	//
	//saOld.Add("iPartialR1");
	//saNew.Add("PartialR1");
	//
	//saOld.Add("iPartialR2");
	//saNew.Add("PartialR2");
	//
	//saOld.Add("iRenameWks");
	//saNew.Add("RenameWks");
	
	saOld.Add("iBigEndian");
	saNew.Add("BigEndian");
	
	saOld.Add("iApplyRange");
	saNew.Add("ApplyRange");
	
	saOld.Add("iMode");
	saNew.Add("ImpMode");
	
	saOld.Add("iSkipRows");
	saNew.Add("SkipRows");
	
	saOld.Add("iReadRows");
	saNew.Add("ReadRows");
	
	saOld.Add("vParamType");
	saNew.Add("ParamType");
	
	saOld.Add("vParamSize");
	saNew.Add("ParamSize");
	
	saOld.Add("vParamCount");
	saNew.Add("ParamCount");
	
	//saOld.Add("flags");
	//saNew.Add("flags");
	
	// user defined
	//saOld.Add("PostImportScript");
	//saNew.Add("PostImportScript");
	
	//saOld.Add("OCFile");
	//saNew.Add("OCFile");
	
	//saOld.Add("OCFunction");
	//saNew.Add("OCFunction");
	
	//saOld.Add("OCClass");
	//saNew.Add("OCClass");
	
	// xfunction
	saOld.Add("iRenameWks");
	saNew.Add("FNameToSht"); //saNew.Add("RenameWks");
	
	saOld.Add("iRenameWkBk");
	saNew.Add("FNameToBk"); //saNew.Add("RenameWkbk");
	
	///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	saOld.Add("iRenameWkBkLongNameOnly");
	saNew.Add("FNameToBkLnOnly");
	///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	
	saOld.Add("iIncludePathForWkBk");
	saNew.Add("FPathToBk"); //saNew.Add("IncludePathForWkBk");
	
	saOld.Add("iAppendWkBkComm");
	saNew.Add("FNameToBkComm"); //saNew.Add("AppendWkBkComm");
	
	saOld.Add("iAppendColComm");
	saNew.Add("FNameToColComm"); //saNew.Add("AppdToColComm");
	
	saOld.Add("iIncludePath");
	saNew.Add("FPathToComm"); //saNew.Add("IncludePath");
	
	saOld.Add("iRemoveQuotes");
	saNew.Add("RemoveQuotes");
	
	//saOld.Add("flags");
	//saNew.Add("flags");
	
	saOld.Add("strName"); 
	saNew.Add("Name");
	
	saOld.Add("bOpenSetting");
	saNew.Add("OpenSetting");
	
	saOld.Add("iMode");
	saNew.Add("ImpMode"); //saNew.Add("Mode");
	
	saOld.Add("bShowTime");
	saNew.Add("ShowTime");
	
	saOld.Add("iPartialImport");
	saNew.Add("Partial");   //saNew.Add("PartialImport");  
	
	saOld.Add("iReadPoint");
	saNew.Add("ReadSamples"); //saNew.Add("ReadPoint");
	
	saOld.Add("iSkipPoint");
	saNew.Add("SkipSamples"); //saNew.Add("SkipPoint");
	
	saOld.Add("iStartPoint");
	saNew.Add("FirstSample"); //saNew.Add("StartPoint");
	
	saOld.Add("iEndPoint");
	saNew.Add("LastSample"); //saNew.Add("EndPoint");
	
	saOld.Add("iColStartPoint");
	saNew.Add("FirstCol"); //saNew.Add("ColStartPoint");
	
	saOld.Add("iColEndPoint");
	saNew.Add("LastCol"); //saNew.Add("ColEndPoint");
	
	saOld.Add("iStartTime");
	saNew.Add("StartTime");
	
	saOld.Add("iEndTime");
	saNew.Add("EndTime");
}
///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE

///---Sim 01-30-2007 GENERAL_IMPORT_MODE_LIST
string getImportModeListString(string &strMapping, DWORD dwCtrl)
	// = NULL,
	// 	IW_FLAG_IMPMODE_AUTO | IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS
	//	 | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS | IW_FLAG_IMPMODE_NEW_ROWS)
{
	StringArray saList;
	vector vTempMapping;
	
	if ( dwCtrl & IW_FLAG_IMPMODE_AUTO)
	{
		saList.Add(_L("Auto"));
		vTempMapping.Add(ASCIMP_MODE_AUTO);
	}
		
	if ( dwCtrl & IW_FLAG_IMPMODE_REPLACE)
	{
		saList.Add(_L("Replace Existing Data"));
		vTempMapping.Add(ASCIMP_MODE_REPLACE_DATA);
	}
	
	if ( dwCtrl & IW_FLAG_IMPMODE_NEW_BOOKS)
	{
		saList.Add(_L("Start New Books"));
		vTempMapping.Add(ASCIMP_MODE_NEW_BOOKS);
	}

	if ( dwCtrl & IW_FLAG_IMPMODE_NEW_SHEETS)
	{
		saList.Add(_L("Start New Sheets"));
		vTempMapping.Add(ASCIMP_MODE_NEW_SHEETS);
	}

	///Sophy 6/4/2010 ORG-220 IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
	if ( dwCtrl & IW_FLAG_IMPMODE_NEW_OBJECTS )
	{
		saList.Add(_L("Start New Objects"));
		vTempMapping.Add(ASCIMP_MODE_NEW_OBJECTS);
	}
	///end IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
	
	if ( dwCtrl & IW_FLAG_IMPMODE_NEW_COLS)
	{
		saList.Add(_L("Start New Columns"));
		vTempMapping.Add(ASCIMP_MODE_APPEND_COLS);
	}

	if ( dwCtrl & IW_FLAG_IMPMODE_NEW_ROWS)
	{
		saList.Add(_L("Start New Rows"));
		vTempMapping.Add(ASCIMP_MODE_APPEND_ROWS);
	}

	if ( NULL != strMapping )
	{
		//StringArray saMapping;
		//saMapping = vTempMapping;
		//for ( int ii = 0; ii < vTempMapping.GetSize(); ii++ )
			//saMapping.Add(vTempMapping[ii]);
		//strMapping.SetTokens(saMapping, '|');
		vector_to_str_list(vTempMapping, strMapping, false, false, '|');
	}
	
	string strList;
	strList.SetTokens(saList, '|');

	return strList;
}

//static string getTemplateComboStr()
//{
	//string strCombo;
	//strCombo = "...File: ImportFileTemplates";
	//return strCombo;	
//}
///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
//void getEnableValueForFileNameOptions(int nAutoRename, int nRenameWks, int nRenameWkbk, int nAppendComm, int nAppendCol, \
		bool& bRenameWks, bool& bRenameWksPartial, \
		bool& bRenameWkbk, bool& bRenameWkbkPartial, bool& bRenameWkbkIncludePath, \
		bool& bAppendIncludePath)
void getEnableValueForFileNameOptions(int nAutoRename, int nRenameWks, int nRenameWkbk, int nAppendComm, int nAppendCol, \
		bool& bRenameWks, bool& bRenameWksPartial, \
		bool& bRenameWkbk, bool& bRenameWkbkPartial, bool& bRenameWkBkLnOnly, bool& bRenameWkbkIncludePath, \
		bool& bAppendIncludePath)
///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
{
	bRenameWks = (0 == nAutoRename);
	bRenameWksPartial = ( bRenameWks && ( 0 != nRenameWks ) );
	
	bRenameWkbk = (0 == nAutoRename);
	bRenameWkbkPartial = ( bRenameWkbk && ( 0 != nRenameWkbk ) );
	bRenameWkBkLnOnly = ( 0 != nAutoRename || 0 != nRenameWkbk); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	bRenameWkbkIncludePath = ( 0 != nAutoRename || 0 != nRenameWkbk);
	
	bAppendIncludePath = ( 0 != nAppendComm || 0 != nAppendCol );
}

/// Hong 03/24/08 v8.0830 FIX_EXCEL_RUNTIME_BY_NOT_CONTAIN_FILLNODES_OF_RENAME_BRANCH
/*
static void _enable_file_name_options(TreeNode& trFileNameOptions)
{
	TreeNode trAutoRename 	= tree_get_node_by_id(trFileNameOptions, IDE_DISP_IMP_AUTO_RENAME, true);
	
	TreeNode trRenameWks	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_RENAMEWKS, true);
	TreeNode trRenameWkbk 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2WKBK, true);
	TreeNode trAppendComm	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2WKBKCOMMENT, true);
	TreeNode trAppendCol	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2COLCOMMENT, true);
	
	//int nEnable = (1 == trAutoRename.nVal) ? 0 : 1;
		//
	//if ( trRenameWks )
		//trRenameWks.Enable = nEnable;
	///// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//int nWksTrimEnable = (nEnable && (1 == trRenameWks.nVal)) ? 1 : 0;
	//if( trWksTrimFNameFrom )
		//trWksTrimFNameFrom.Enable = nWksTrimEnable;
	//if( trWksTrimFNameTo )
		//trWksTrimFNameTo.Enable = nWksTrimEnable;
	///// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//
	//if ( trRenameWkBk )
		//trRenameWkBk.Enable = nEnable;
	//int nWkBkTrimEnable = (nEnable && (1 == trRenameWkBk.nVal)) ? 1 : 0;
	//if( trWkBkTrimFNameFrom )
		//trWkBkTrimFNameFrom.Enable = nWkBkTrimEnable;
	//if( trWkBkTrimFNameTo )
		//trWkBkTrimFNameTo.Enable = nWkBkTrimEnable;
	////if ( trRenameIncludePath )
		////trRenameIncludePath.Enable = nEnable;
	
	bool bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkbkIncludePath, bAppendIncludePath;
	///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	//getEnableValueForFileNameOptions(trAutoRename.nVal, trRenameWks.nVal, trRenameWkbk.nVal, trAppendComm.nVal, trAppendCol.nVal,
		//bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkbkIncludePath, bAppendIncludePath);
	bool bRenameWkBkLnOnly;
	getEnableValueForFileNameOptions(trAutoRename.nVal, trRenameWks.nVal, trRenameWkbk.nVal, trAppendComm.nVal, trAppendCol.nVal,
		bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkBkLnOnly, bRenameWkbkIncludePath, bAppendIncludePath);
	///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		
	/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	TreeNode trWksTrimFNameFrom		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, true);
	TreeNode trWksTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, true);
	/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	TreeNode trWkbkTrimFNameFrom	= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, true);
	TreeNode trWkbkTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, true);
	TreeNode trRenameWkBkLnOnly 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_WKBKLNONLY, true); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	TreeNode trRenameIncludePath 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_ADDPATH4WKBK, true);
	TreeNode trAppendIncludePath 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_ADDPATH, true);
	
	trRenameWks.Enable 			= bRenameWks;
	trWksTrimFNameFrom.Enable 	= bRenameWksPartial;
	trWksTrimFNameTo.Enable 	= bRenameWksPartial;
	
	trRenameWkbk.Enable = bRenameWkbk;
	trWkbkTrimFNameFrom.Enable 	= bRenameWkbkPartial;
	trWkbkTrimFNameTo.Enable 	= bRenameWkbkPartial;
	trRenameWkBkLnOnly.Enable	= bRenameWkBkLnOnly; ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	trRenameIncludePath.Enable	= bRenameWkbkIncludePath;
	
	trAppendIncludePath.Enable	= bAppendIncludePath;	
}
*/
#define _SET_NODE_ENABLE_IF_VALID(_tn, _bVal) \
	if ( _tn.IsValid() ) \
		_tn.Enable = _bVal;
	
static void _enable_file_name_options(TreeNode& trFileNameOptions)
{
	TreeNode	trAutoRename 	= tree_get_node_by_id(trFileNameOptions, IDE_DISP_IMP_AUTO_RENAME, true);	
	TreeNode	trRenameWks		= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_RENAMEWKS, true);
	TreeNode	trRenameWkbk 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2WKBK, true);
	TreeNode	trAppendComm	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2WKBKCOMMENT, true);
	TreeNode	trAppendCol		= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2COLCOMMENT, true);
	
	bool	bRenameWks = false, bRenameWksPartial = false, bRenameWkbk = false, bRenameWkbkPartial = false,
			bRenameWkbkIncludePath = false, bAppendIncludePath = false, bRenameWkBkLnOnly = false;
	bool	bAutoRename = false, bAppendComm = false, bAppendCOl = false;
	
	bAutoRename 	= tree_node_get_int(trAutoRename, bAutoRename);
	bRenameWks 		= tree_node_get_int(trRenameWks, bRenameWks);
	bRenameWkbk 	= tree_node_get_int(trRenameWkbk, bRenameWkbk);
	bAppendComm 	= tree_node_get_int(trAppendComm, bAppendComm);	
	bAppendCOl 		= tree_node_get_int(trAppendCol, bAppendCOl);
	
	getEnableValueForFileNameOptions( bAutoRename, bRenameWks, bRenameWkbk, bAppendComm, bAppendCOl,
		bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkBkLnOnly, bRenameWkbkIncludePath, bAppendIncludePath );
		
	TreeNode 	trWksTrimFNameFrom		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, true);
	TreeNode 	trWksTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, true);
	TreeNode 	trWkbkTrimFNameFrom	= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, true);
	TreeNode 	trWkbkTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, true);
	TreeNode 	trRenameWkBkLnOnly 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_WKBKLNONLY, true);
	TreeNode 	trRenameIncludePath 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_ADDPATH4WKBK, true);
	TreeNode 	trAppendIncludePath 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_ADDPATH, true);
	
	_SET_NODE_ENABLE_IF_VALID(trRenameWks, bRenameWks);
	_SET_NODE_ENABLE_IF_VALID(trWksTrimFNameFrom, bRenameWksPartial);
	_SET_NODE_ENABLE_IF_VALID(trWksTrimFNameTo, bRenameWksPartial);
	_SET_NODE_ENABLE_IF_VALID(trRenameWkbk, bRenameWkbk);
	_SET_NODE_ENABLE_IF_VALID(trWkbkTrimFNameFrom, bRenameWkbkPartial);
	_SET_NODE_ENABLE_IF_VALID(trWkbkTrimFNameTo, bRenameWkbkPartial);
	_SET_NODE_ENABLE_IF_VALID(trRenameWkBkLnOnly, bRenameWkBkLnOnly);
	_SET_NODE_ENABLE_IF_VALID(trRenameIncludePath, bRenameWkbkIncludePath);
	_SET_NODE_ENABLE_IF_VALID(trAppendIncludePath, bAppendIncludePath);
}
/// end FIX_EXCEL_RUNTIME_BY_NOT_CONTAIN_FILLNODES_OF_RENAME_BRANCH
///---END CENTRALIZE_FILE_NAME_OPTIONS_ENABLE

static bool OnChangeRenameOptions(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{

	_enable_file_name_options(trNode.Parent());
	
	return true;
}

///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
static void _enable_partial_import_options(TreeNode& trPartialImportOptions)
{
	TreeNode trPartialImport	= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_PARTIAL_IMPORT, true);
	TreeNode trStartPoint		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_START_POINT, true);
	TreeNode trEndPoint 		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_END_POINT, true);
	TreeNode trColStartPoint	= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_COL_START_POINT, true);
	TreeNode trColEndPoint		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_COL_END_POINT, true);
	TreeNode trSkipPoint 		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_SKIP_POINT, true);
	TreeNode trReadPoint 		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_READ_POINT, true);
	
	/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
	TreeNode trStartTime		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_START_TIME, true);
	TreeNode trEndTime 			= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_END_TIME, true);
	/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT

	
	//TreeNode trSubRange			= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_SUB_RANGE, true);
	
	trColStartPoint.Enable = ( 1 == trPartialImport.nVal );
	trColEndPoint.Enable = ( 1 == trPartialImport.nVal );
	trSkipPoint.Enable = ( 1 == trPartialImport.nVal );
	///---Sim 05-30-2007 CHECK_VALID_SETTING
	//trReadPoint.Enable = ( 1 == trPartialImport.nVal && trSkipPoint.nVal >= 0);
	trReadPoint.Enable = ( 1 == trPartialImport.nVal && trSkipPoint.nVal > 0);
	///---END CHECK_VALID_SETTING
	///---Sim 05-30-2007 QA80-9476-P8 DEFAULT_NOT_OPEN_TIME_PARTIAL
	trStartPoint.Enable = ( 1 == trPartialImport.nVal );
	trEndPoint.Enable = ( 1 == trPartialImport.nVal );
	trStartTime.Enable = 0;
	trEndTime.Enable = 0;
	
	if ( trStartTime.Show && trEndTime.Show )
	{
		/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		trStartTime.Enable = ( 1 == trPartialImport.nVal );
		trEndTime.Enable = ( 1 == trPartialImport.nVal );
		///---Sim 05-30-2007 CHECK_VALID_SETTING
		//if ( trReadPoint.Enable )
		if ( 1 == trPartialImport.nVal )
		///---END CHECK_VALID_SETTING
		{
			double dDuration, dInterval;
			//string strLabel; ///---Sim 05-30-2007 NO_USE
			
			///---Sim 05-30-2007 CHECK_VALID_SETTING
			//trPartialImportOptions.GetAttribute(STR_PARTIAL_DURATION_TIME, dDuration);
			//trPartialImportOptions.GetAttribute(STR_PARTIAL_IMPORT_INTERVAL, dInterval);
			if ( !trPartialImportOptions.GetAttribute(STR_PARTIAL_DURATION_TIME, dDuration) )
				dDuration = 0;
			if ( !trPartialImportOptions.GetAttribute(STR_PARTIAL_IMPORT_INTERVAL, dInterval) )
				dInterval = 1;
			///---END CHECK_VALID_SETTING
			///---Sim 05-30-2007 NO_USE
			/*
			if ( trSkipPoint.nVal < 0 )
				trSkipPoint.nVal = 0;
			int nTotal = dDuration/dInterval;
			if ( trSkipPoint.nVal > nTotal )
				trSkipPoint.nVal = nTotal;
			double dCurrentInterval = dInterval * (trSkipPoint.nVal + 1 );
			int nSize = dDuration/dInterval;
			*/
			///---END NO_USE
			/// Hong 05/14/07 v8.0617 MOVE_FOR_REMOVE_EXTRA_INFO
			//strLabel.Format("Partial Import: interval is %f ms ", dInterval);
			//strLabel.Format("Partial Import: duransion(s) %sms, Samples %d, current interval %sms", ftoa(dDuration), nSize, ftoa(dCurrentInterval));
			
			//trPartialImportOptions.SetAttribute(STR_LABEL_ATTRIB, strLabel);
			/// END MOVE_FOR_REMOVE_EXTRA_INFO
			
			trStartPoint.nVal = trStartTime.dVal  / dInterval + 1; 
			trEndPoint.nVal = trEndTime.dVal / dInterval; 
	
			//out_str(strLabel); ///---Sim 05-30-2007 NO_USE
		}
		///--- Hong 05/09/07 change to read-only mode
		//trStartPoint.Enable = 0;
		//trEndPoint.Enable = 0;
		trStartPoint.Enable = 2;
		trEndPoint.Enable = 2;
		///---
		/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
	}	
	///---END QA80-9476-P8 DEFAULT_NOT_OPEN_TIME_PARTIAL

	
	//trSubRange.Enable = ( 1 == trPartialImport.nVal );
	//trStartPoint.Enable = ( trSubRange.Enable && 1 == trSubRange.nVal );
	//trEndPoint.Enable = ( trSubRange.Enable && 1 == trSubRange.nVal );
}

static bool OnChangePartialImportOptions(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{

	_enable_partial_import_options(trNode.Parent());
	
	return true;
}
///---END ADD_OPTION_TO_DISABLE_PARTIAL_RANGE

/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
static bool  OnChangePartialImportTime(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	/// Hong 01/08/08 V8.0780 FIX_SKIP_POINT_FAIL_APPLY_THEME_VALUE_IN_IMPWAV
	if ( !(trNode.Show) ) // if hidden, no need process even of it
		return false;
	/// end FIX_SKIP_POINT_FAIL_APPLY_THEME_VALUE_IN_IMPWAV
	TreeNode trPartialImportOptions = trNode.Parent();
	TreeNode trStartPoint		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_START_POINT, true);
	TreeNode trEndPoint 		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_END_POINT, true);
	TreeNode trStartTime		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_START_TIME, true);
	TreeNode trEndTime 			= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_END_TIME, true);
	TreeNode trSkipPoint 		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_SKIP_POINT, true);
	
	double dDuration, dInterval; 
	///---Sim 05-30-2007 CHECK_VALID_SETTING
	//trPartialImportOptions.GetAttribute(STR_PARTIAL_DURATION_TIME, dDuration);
	//trPartialImportOptions.GetAttribute(STR_PARTIAL_IMPORT_INTERVAL, dInterval);
	if ( !trPartialImportOptions.GetAttribute(STR_PARTIAL_DURATION_TIME, dDuration) )
		dDuration = 0;
	if ( !trPartialImportOptions.GetAttribute(STR_PARTIAL_IMPORT_INTERVAL, dInterval) )
		dInterval = 1;
	///---END CHECK_VALID_SETTING
	//trPartialImportOptions.GetAttribute(STR_PARTIAL_START_TIME, dStartTime); // Hong 05/09/07 v8.0614 FIX_AUTO_FAIL_WORKS_AFTER_EDIT
	
	///---Sim 05-30-2007 CHECK_VALID_SETTING
	/*
	if ( trStartTime.dVal > dDuration )
		trStartPoint.nVal = dDuration;
	if ( trEndPoint.dVal > dDuration )
		trStartPoint.nVal = dDuration;
	if ( trStartTime.dVal < 0 )
		trStartPoint.nVal = 0;
	if ( trEndPoint.dVal < 0 )
		trStartPoint.nVal = 0;
	*/
	if ( trStartTime.dVal < 0 )
		trStartTime.dVal = 0;
	if ( trStartTime.dVal > dDuration )
		trStartTime.dVal = dDuration;
	
	if ( trEndTime.dVal < 0 )
		trEndTime.dVal = 0;
	if ( trEndTime.dVal > dDuration )
		trEndTime.dVal = dDuration;
	///---END CHECK_VALID_SETTING
	
	/// Hong 05/09/07 v8.0614 FIX_AUTO_FAIL_WORKS_AFTER_EDIT
	bool bAutoST =octree_get_auto_support(&trStartTime)==1?true:false;
	bool bAutoET =octree_get_auto_support(&trEndTime)==1?true:false;
	
	if ( bAutoST )
		//trStartTime.dVal = dStartTime;
		trStartTime.dVal = 0; // should use relative time with ZERO offset, but not absolute time
	
	if (bAutoET)
		trEndTime.dVal = dDuration;
	/// end FIX_AUTO_FAIL_WORKS_AFTER_EDIT
	
	//dInterval *=(trSkipPoint.nVal + 1 ); 
	
	trStartPoint.nVal = trStartTime.dVal  / dInterval + 1; 
	trEndPoint.nVal = trEndTime.dVal / dInterval; 

	return TRUE;
}
/*
static bool  OnChangePartialImportPoints(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	TreeNode trPartialImportOptions = trNode.Parent();
	TreeNode trStartPoint		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_START_POINT, true);
	TreeNode trEndPoint 		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_END_POINT, true);
	TreeNode trStartTime		= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_START_TIME, true);
	TreeNode trEndTime 			= tree_get_node_by_id(trPartialImportOptions, IDE_XFIMP_END_TIME, true);
	
	double dDuration, dInterval;
	trPartialImportOptions.GetAttribute(STR_PARTIAL_DURATION_TIME, dDuration);
	trPartialImportOptions.GetAttribute(STR_PARTIAL_IMPORT_INTERVAL, dInterval);
	
	trStartTime.dVal = dInterval * (trStartPoint.nVal - 1);
	trEndTime.dVal = dInterval * trEndPoint.nVal;
	return TRUE;
}
*/
/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT


//static bool OnChangeAutoRename(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
//{
	//int nEnable = (1 == trNode.nVal) ? 0 : 1;
	//
	//TreeNode trFileNameOptions = trNode.Parent();
	//
	//TreeNode trRenameWks	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_RENAMEWKS, true);
	//TreeNode trRenameWkBk 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2WKBK, true);
	////TreeNode trRenameIncludePath 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_ADDPATH4WKBK, true);
	///// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//TreeNode trWksTrimFNameFrom		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, true);
	//TreeNode trWksTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, true);
	///// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//TreeNode trTrimFNameFrom		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, true);
	//TreeNode trTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, true);
		//
	//if ( trRenameWks )
		//trRenameWks.Enable = nEnable;
	///// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//int nWksTrimEnable = (nEnable && (1 == trRenameWks.nVal)) ? 1 : 0;
	//if( trWksTrimFNameFrom )
	//{
		//trWksTrimFNameFrom.Enable = nWksTrimEnable;
	//}
	//
	//if( trWksTrimFNameTo )
	//{
		//trWksTrimFNameTo.Enable = nWksTrimEnable;
	//}
	///// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//if ( trRenameWkBk )
		//trRenameWkBk.Enable = nEnable;
	////if ( trRenameIncludePath )
		////trRenameIncludePath.Enable = nEnable;
		//
	//return true;
//}
//
///// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
//static bool OnChangeRenameWks(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
//{
	//TreeNode trFileNameOptions = trNode.Parent();
	//
	//TreeNode trTrimFNameFrom		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, true);
	//TreeNode trTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, true);
	//
	//trTrimFNameFrom.Enable = trNode.Enable && trNode.nVal;
	//trTrimFNameTo.Enable = trNode.Enable && trNode.nVal;
	//
	//return true;
//}
///// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
//
//static bool OnChangeRenameWkBk(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
//{
	//TreeNode trFileNameOptions = trNode.Parent();
	//
	//TreeNode trTrimFNameFrom		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, true);
	//TreeNode trTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, true);
	//
	//trTrimFNameFrom.Enable = trNode.Enable && trNode.nVal;
	//trTrimFNameTo.Enable = trNode.Enable && trNode.nVal;
	//
	//return true;
//}


static bool OnChangeImportMode(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	int nImportMode = trNode.nVal;
	
	bool bTemplEnable = (ASCIMP_MODE_NEW_SHEETS == nImportMode || ASCIMP_MODE_NEW_BOOKS == nImportMode);
	
	TreeNode trOptions = trNode.Parent();
	
	TreeNode trTemplate = tree_get_node_by_id(trOptions, IDE_DISP_IMP_PAGETEMPLATE, true);
	///---Sim 10-29-2008 v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
	if ( trTemplate && trTemplate.Show )
	///---END v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
		trTemplate.Enable = bTemplEnable;
	
	return true;
}

void constructOptionsForXF(TreeNode& trOptions, bool bAutoRename, bool bImportMode, bool bSparkLine, bool bTimeCol, bool bTemplate, bool bSkipPoints, bool bColPartial, bool bReadRow, bool bTimePartial)// = true, true, false, false, true, false, false, false, false
{
///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	constructOptionsForXF(trOptions,
	(DWORD)	(bAutoRename ? FILTER_OPTIONS_AUTO_RENAME : 0)
		|	(bImportMode ? FILTER_OPTIONS_IMPORT_MODE : 0)
		|	(bSparkLine ? FILTER_OPTIONS_SPARKLINE : 0)
		|	(bTimeCol ? FILTER_OPTIONS_TIME_COL : 0)
		|	(bTemplate ? FILTER_OPTIONS_TEMPLATE : 0)
		|	(bSkipPoints ? FILTER_OPTIONS_SKIP_POINTS : 0)
		|	(bColPartial ? FILTER_OPTIONS_COL_PARTIAL : 0)
		|	(bReadRow ? FILTER_OPTIONS_READ_ROW : 0)
		|	(bTimePartial ? FILTER_OPTIONS_TIME_PARTIAL : 0)
	);
}

///---Sim 11-21-2008 FIX_OVERLOAD_PROTOTYPE_CAUSE_IMP_XF_BROKEN
//void constructOptionsForXF(TreeNode& trOptions, DWORD dwCntrl) // = FILTER_OPTIONS_AUTO_RENAME | FILTER_OPTIONS_IMPORT_MODE | FILTER_OPTIONS_TEMPLATE
void constructOptionsForXF(TreeNode& trOptions, DWORD dwCntrl)
///---END FIX_OVERLOAD_PROTOTYPE_CAUSE_IMP_XF_BROKEN
{
///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION

	///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
	//fuPrepareDefault(trOptions, FILTER_TYPE_XFUNC);
	fuPrepareDefaultFilterGUITree(trOptions, FILTER_TYPE_XFUNC);
	///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE
	
	///---Sim 03-23-2007 FIX_LT_SCRIPT_PASS_TO_XF
	//FILTER_ADD_NODE(trOptions.GetNode(IMPORT_FILTER_DISPIMP), IDE_IMP_POSTIMPSCRIPT, "PostImportScript");
	fuSetPostImportScript(trOptions, "");
	///---END FIX_LT_SCRIPT_PASS_TO_XF
	
	// show most important options on top level
	tree_set_attribute_to_all_nodes(trOptions, "Show", "0");
	trOptions.Show = 1;

	///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	//if ( bImportMode )
	if ( dwCntrl & FILTER_OPTIONS_IMPORT_MODE )
	///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	{
		///---Sim 05-08-2007 ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
		TreeNode tr1stImportMode;
		TreeNode trImportMode;
		
		// change place where useful options are
		tr1stImportMode		= tree_get_node_by_id(trOptions, IDE_DISPIMP_1STMODE, true);
		trImportMode		= tree_get_node_by_id(trOptions, IDE_IMP_IMPORTMODE, true);
		// put to new place
		trOptions.AddNode(tr1stImportMode);
		trOptions.AddNode(trImportMode);
		// remove out from old place
		tr1stImportMode.Remove();
		trImportMode.Remove();
		
		// set treenode attribute for XF GUI
		// attribute - show
		tr1stImportMode		= tree_get_node_by_id(trOptions, IDE_DISPIMP_1STMODE, true);
		tr1stImportMode.Show = 1;
		trImportMode		= tree_get_node_by_id(trOptions, IDE_IMP_IMPORTMODE, true);
		trImportMode.Show = 1;
		
		// attribute - node type
		string strMapping;
		string strCombo;
		int nMode = LIST_IMPORT_MODE_ALL;
		
		nMode &= ~IW_FLAG_IMPMODE_AUTO;
		strCombo = getImportModeListString(strMapping, nMode);
		tr1stImportMode.ID = TRGP_ENUM_LIST;
		tr1stImportMode.SetAttribute(STR_COMBO_ATTRIB, strCombo);
		tr1stImportMode.SetAttribute(STR_INTMAP_ATTRIB, strMapping);
		
		nMode &= ~IW_FLAG_IMPMODE_REPLACE;
		strCombo = getImportModeListString(strMapping, nMode);
		trImportMode.ID = TRGP_ENUM_LIST;
		trImportMode.SetAttribute(STR_COMBO_ATTRIB, strCombo);
		trImportMode.SetAttribute(STR_INTMAP_ATTRIB, strMapping);

		// attribute - extra
		tr1stImportMode.SetAttribute(STR_LABEL_ATTRIB, _L("1st File Import Mode"));
		trImportMode.SetAttribute(STR_LABEL_ATTRIB, _L("Multi-File (except 1st) Import Mode"));
		
		// attribute - event
		GETN_SET_EVENT_EX_HANDLER(tr1stImportMode, OnChangeImportMode)
		GETN_SET_EVENT_EX_HANDLER(trImportMode, OnChangeImportMode)
		///---END ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
	}

	///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	//if ( bTemplate )
	if ( dwCntrl & FILTER_OPTIONS_TEMPLATE )
	///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	{
		TreeNode trTemplate;
		
		// change place where useful options are
		trTemplate			= tree_get_node_by_id(trOptions, IDE_DISP_IMP_PAGETEMPLATE, true);
		// put to new place
		trOptions.AddNode(trTemplate);
		// remove out from old place
		trTemplate.Remove();
		
		// set treenode attribute for XF GUI
		// attribute - show
		trTemplate			= tree_get_node_by_id(trOptions, IDE_DISP_IMP_PAGETEMPLATE, true);
		trTemplate.Show = 1;
		
		// attribute - node type
		trTemplate.ID = TRGP_STR_BUTTON;
		trTemplate.SetAttribute(STR_COMBO_ATTRIB, "...File: ImportFileTemplates");
		
		// attribute - extra
		trTemplate.SetAttribute(STR_LABEL_ATTRIB, _L("Template Name"));
	}
	
	///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	//if ( bSparkLine )
	if ( dwCntrl & FILTER_OPTIONS_SPARKLINE )
	///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	{
		TreeNode trSparkLine;
		
		// change place where useful options are
		trSparkLine			= tree_get_node_by_id(trOptions, IDE_DISP_IMP_SPARKLINES, true);
		// put to new place
		trOptions.AddNode(trSparkLine);
		// remove out from old place
		trSparkLine.Remove();
		
		// set treenode attribute for XF GUI
		// attribute - show
		trSparkLine			= tree_get_node_by_id(trOptions, IDE_DISP_IMP_SPARKLINES, true);
		trSparkLine.Show = 1;
		
		// attribute - node type
		///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
		//trSparkLine.ID = TRGP_CHECK;
		trSparkLine.ID = TRGP_ENUM_LIST;
		trSparkLine.SetAttribute(STR_COMBO_ATTRIB, STR_COMBO_SPARKLINE); 
		//trSparkLine.SetAttribute(STR_INTMAP_ATTRIB, SPARKLINE_NO_CHANGE+"|"+SPARKLINE_ADD+"|"+SPARKLINE_ADD_IF_LESS_THEN_50_COLS);
		///---END SUPPORT_SMART_SPARKLINE
	
		// attribute - extra
		trSparkLine.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_ADD_SPARKLINES); ///---Sim 08-09-2007 CHANGE_LABLE
	}
	
	///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	//if ( bTimeCol )
	if ( dwCntrl & FILTER_OPTIONS_TIME_COL )
	///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	{
		TreeNode trTimeCol;
		
		// change place where useful options are
		trTimeCol			= tree_get_node_by_id(trOptions, IDE_XFIMP_OPSHOWTIME, true);
		// put to new place
		trOptions.AddNode(trTimeCol);
		// remove out from old place
		trTimeCol.Remove();
		
		// set treenode attribute for XF GUI
		// attribute - show
		trTimeCol			= tree_get_node_by_id(trOptions, IDE_XFIMP_OPSHOWTIME, true);
		trTimeCol.Show = 1;
		
		// attribute - node type
		trTimeCol.ID = TRGP_CHECK;
	
		// attribute - extra
		trTimeCol.SetAttribute(STR_LABEL_ATTRIB, _L("Show Time Column"));
	}
	
	///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	if ( (dwCntrl & FILTER_OPTIONS_AUTO_SIZE) )
	{
		TreeNode trAutoSize;
		
		// change place where useful options are
		trAutoSize		= tree_get_node_by_id(trOptions, IDE_DISP_IMP_AUTOSIZE, true);
		// put to new place
		trOptions.AddNode(trAutoSize);
		// remove out from old place
		trAutoSize.Remove();
		
		// set treenode attribute for XF GUI
		// attribute - show
		trAutoSize		= tree_get_node_by_id(trOptions, IDE_DISP_IMP_AUTOSIZE, true);
		trAutoSize.Show = 1;
		
		// attribute - node type
		trAutoSize.ID = TRGP_ENUM_LIST;
		trAutoSize.SetAttribute(STR_COMBO_ATTRIB, STR_COMBO_AUTO_SIZE); 
	
		// attribute - extra
		trAutoSize.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_AUTO_SIZE);
	}
	///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	
	///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	//if ( bAutoRename )
	if ( dwCntrl & FILTER_OPTIONS_AUTO_RENAME )
	///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	{
		TreeNode trAutoRename;
		TreeNode trRenameWks;
		TreeNode trWksTrimFNameFrom, trWksTrimFNameTo; // Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		TreeNode trRenameWkBk;
		TreeNode trWkBkTrimFNameFrom, trWkBkTrimFNameTo;
		TreeNode trRenameWkBkLnOnly; ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		TreeNode trRenameIncludePath;
		TreeNode trAppendWkBkComm;
		TreeNode trAppendColComm;
		TreeNode trAppendIncludePath;
		
		// change place where useful options are
		trAutoRename		= tree_get_node_by_id(trOptions, IDE_DISP_IMP_AUTO_RENAME, true);
		trRenameWks 		= tree_get_node_by_id(trOptions, IDE_XFIMP_RENAMEWKS, true);
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trWksTrimFNameFrom		= tree_get_node_by_id(trOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, true);
		trWksTrimFNameTo		= tree_get_node_by_id(trOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, true);
		/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trRenameWkBk 		= tree_get_node_by_id(trOptions, IDE_XFIMP_FILENAME2WKBK, true);
		trWkBkTrimFNameFrom		= tree_get_node_by_id(trOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, true);
		trWkBkTrimFNameTo		= tree_get_node_by_id(trOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, true);
		trRenameWkBkLnOnly	= tree_get_node_by_id(trOptions, IDE_XFIMP_WKBKLNONLY, true); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		trRenameIncludePath = tree_get_node_by_id(trOptions, IDE_XFIMP_ADDPATH4WKBK, true);
		trAppendWkBkComm 	= tree_get_node_by_id(trOptions, IDE_XFIMP_FILENAME2WKBKCOMMENT, true);
		trAppendColComm 	= tree_get_node_by_id(trOptions, IDE_XFIMP_FILENAME2COLCOMMENT, true);
		trAppendIncludePath = tree_get_node_by_id(trOptions, IDE_XFIMP_ADDPATH, true);
		// put to new place
		//TreeNode trFileNameOptions = trOptions.AddNode("FileNameOptions");
		/// Hong 06/04/07 v8.0623 USE_MACRO_FOR_MORE_FRIENDLY_NAME
		//TreeNode trFileNameOptions = trOptions.AddNode("names"); ///---Sim 06-04-2007 MORE_FRIENDLY_NAME
		TreeNode trFileNameOptions = trOptions.AddNode(STR_FILTER_FILENAME_NODE);
		/// end USE_MACRO_FOR_MORE_FRIENDLY_NAME
		trFileNameOptions.AddNode(trAutoRename);
		trFileNameOptions.AddNode(trRenameWks);
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trFileNameOptions.AddNode(trWksTrimFNameFrom);
		trFileNameOptions.AddNode(trWksTrimFNameTo);
		/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trFileNameOptions.AddNode(trRenameWkBk);
		trFileNameOptions.AddNode(trWkBkTrimFNameFrom);
		trFileNameOptions.AddNode(trWkBkTrimFNameTo);
		trFileNameOptions.AddNode(trRenameWkBkLnOnly); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		trFileNameOptions.AddNode(trRenameIncludePath);
		trFileNameOptions.AddNode(trAppendWkBkComm);
		trFileNameOptions.AddNode(trAppendColComm);
		trFileNameOptions.AddNode(trAppendIncludePath);
		// remove out from old place
		trAutoRename.Remove();
		trRenameWks.Remove();
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trWksTrimFNameFrom.Remove();
		trWksTrimFNameTo.Remove();
		/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trRenameWkBk.Remove();
		trWkBkTrimFNameFrom.Remove();
		trWkBkTrimFNameTo.Remove();
		trRenameWkBkLnOnly.Remove(); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		trRenameIncludePath.Remove();
		trAppendWkBkComm.Remove();
		trAppendColComm.Remove();
		trAppendIncludePath.Remove();
		
		// set treenode attribute for XF GUI
		// attribute - show
		tree_set_attribute_to_all_nodes(trFileNameOptions, STR_SHOW_ATTRIB, "1");
		trAutoRename		= tree_get_node_by_id(trFileNameOptions, IDE_DISP_IMP_AUTO_RENAME, true);
		trRenameWks 		= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_RENAMEWKS, true);
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trWksTrimFNameFrom		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, true);
		trWksTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, true);
		/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trRenameWkBk 		= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2WKBK, true);
		trWkBkTrimFNameFrom		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, true);
		trWkBkTrimFNameTo		= tree_get_node_by_id(trFileNameOptions, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, true);
		trRenameWkBkLnOnly	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_WKBKLNONLY, true); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		trRenameIncludePath = tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_ADDPATH4WKBK, true);
		trAppendWkBkComm 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2WKBKCOMMENT, true);
		trAppendColComm 	= tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_FILENAME2COLCOMMENT, true);
		trAppendIncludePath = tree_get_node_by_id(trFileNameOptions, IDE_XFIMP_ADDPATH, true);
		
		//trAppendColComm.Show = 0; // this option is unuse, default hide it.
		
		// attribute - node type
		trAutoRename.ID = TRGP_CHECK;
		trRenameWks.ID = TRGP_CHECK;
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trWksTrimFNameFrom.ID = TRGP_DOUBLE;
		trWksTrimFNameTo.ID = TRGP_DOUBLE;
		/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trRenameWkBk.ID = TRGP_CHECK;
		trWkBkTrimFNameFrom.ID = TRGP_DOUBLE;
		trWkBkTrimFNameTo.ID = TRGP_DOUBLE;
		trRenameWkBkLnOnly.ID = TRGP_CHECK; ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		trRenameIncludePath.ID = TRGP_CHECK;
		trAppendWkBkComm.ID = TRGP_CHECK;
		trAppendColComm.ID = TRGP_CHECK;
		trAppendIncludePath.ID = TRGP_CHECK;
	
		// attribute - extra
		trFileNameOptions.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_RENAME_OPTIONS);
		trAutoRename.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_AUTO_RENAME);
		trRenameWks.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_RENAME_SHEET);
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trWksTrimFNameFrom.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_TRIM_FROM);
		trWksTrimFNameTo.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_TRIM_TO);
		/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		trRenameWkBk.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_RENAME_BOOK);
		trWkBkTrimFNameFrom.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_TRIM_FROM);
		trWkBkTrimFNameTo.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_TRIM_TO);
		trRenameWkBkLnOnly.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_LONG_NAME_ONLY); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		trRenameIncludePath.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_BOOK_INCLUDE_PATH);
		trAppendWkBkComm.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_APPEND_FNAME_TO_BKCMT);
		trAppendColComm.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_APPEND_FNAME_TO_COLCMT);
		trAppendIncludePath.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_APPEND_PATH_TO_FNAME);
		
		// attribute - event
		/// ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES
		//PEVENT_NODE_FUNC dfn = OnChangeAutoRename;
		//DWORD dwfn = (DWORD)dfn;
		//string strfn = dwfn;
		//trAutoRename.SetAttribute(STR_ATTRIB_HANDLER_RC, strfn);
		GETN_SET_EVENT_EX_HANDLER(trAutoRename, OnChangeRenameOptions)
		/// end BAD_EVENT_HANDLER_DWORDS_IN_TREENODES
		GETN_SET_EVENT_EX_HANDLER(trRenameWks, OnChangeRenameOptions) // Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
		GETN_SET_EVENT_EX_HANDLER(trRenameWkBk, OnChangeRenameOptions)
		GETN_SET_EVENT_EX_HANDLER(trAppendWkBkComm, OnChangeRenameOptions)
		GETN_SET_EVENT_EX_HANDLER(trAppendColComm, OnChangeRenameOptions)
	}

	///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	//if ( bSkipPoints )
	if ( dwCntrl & FILTER_OPTIONS_SKIP_POINTS )
	///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
	{
		///---Sim 03-19-2007 ADD_OPTION_TO_PARTIAL_COLUMN
		TreeNode trPartialImport; ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		TreeNode trColStartPoint;
		TreeNode trColEndPoint;
		TreeNode trStartPoint;
		TreeNode trReadPoint;
		TreeNode trSkipPoint;
		TreeNode trEndPoint;
		
		/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		TreeNode trStartTime;
		TreeNode trEndTime;
		/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		
		//TreeNode trSubRange; ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		
		// change place where useful options are
		trPartialImport		= tree_get_node_by_id(trOptions, IDE_XFIMP_PARTIAL_IMPORT, true); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		trColStartPoint		= tree_get_node_by_id(trOptions, IDE_XFIMP_COL_START_POINT, true);
		trColEndPoint		= tree_get_node_by_id(trOptions, IDE_XFIMP_COL_END_POINT, true);
		trStartPoint		= tree_get_node_by_id(trOptions, IDE_XFIMP_START_POINT, true);
		trReadPoint 		= tree_get_node_by_id(trOptions, IDE_XFIMP_READ_POINT, true);
		trSkipPoint 		= tree_get_node_by_id(trOptions, IDE_XFIMP_SKIP_POINT, true);
		trEndPoint 			= tree_get_node_by_id(trOptions, IDE_XFIMP_END_POINT, true);
		
		/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		trStartTime			= tree_get_node_by_id(trOptions, IDE_XFIMP_START_TIME, true);
		trEndTime 			= tree_get_node_by_id(trOptions, IDE_XFIMP_END_TIME, true);
		/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		

		//trSubRange			= tree_get_node_by_id(trOptions, IDE_XFIMP_SUB_RANGE, true); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		// put to new place
		//TreeNode trSkipPointsOptions = trOptions.AddNode("SkipPointsOptions");
		/// Hong 06/04/07 v8.0623 USE_MACRO_FOR_MORE_FRIENDLY_NAME
		//TreeNode trSkipPointsOptions = trOptions.AddNode("partial"); ///---Sim 06-04-2007 MORE_FRIENDLY_NAME
		TreeNode trSkipPointsOptions = trOptions.AddNode(STR_FILTER_PARTIAL_NODE);
		/// end USE_MACRO_FOR_MORE_FRIENDLY_NAME
		///---AW 05/11/08 CHANGE_PARTIAL_INFO_DISPLAY
		/// Hong 11/12/07 v8.745 FIX_INFO_NODE_ERROR_IN_J_VERSION
		//TreeNode trInfo = trSkipPointsOptions.AddTextNode("",_L("Info")); 
		TreeNode trInfo = trSkipPointsOptions.AddTextNode("","Info"); 
		trInfo.SetAttribute(STR_LABEL_ATTRIB, _L("Info"));
		/// end FIX_INFO_NODE_ERROR_IN_J_VERSION
		/// Hong 05/14/07 v8.0617 CHANGE_TEXT_INFO_NODE_TO_READONLY
		//trInfo.Enable = 0;
		trInfo.Enable = ENABLE_READ_ONLY;
		/// END CHANGE_TEXT_INFO_NODE_TO_READONLY
		///---END CHANGE_PARTIAL_INFO_DISPLAY
		trSkipPointsOptions.AddNode(trPartialImport); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		trSkipPointsOptions.AddNode(trColStartPoint);
		trSkipPointsOptions.AddNode(trColEndPoint);
		
		/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		trStartTime.SetAttribute(STR_ATTRIB_AUTO, "1");
		trEndTime.SetAttribute(STR_ATTRIB_AUTO, "1");
		trSkipPointsOptions.AddNode(trSkipPoint);
		trSkipPointsOptions.AddNode(trStartTime);
		trSkipPointsOptions.AddNode(trEndTime);
		{
		//GETN_USE(trSkipPointsOptions)
		//GETN_NUM(trStartTime, "Start Time", trStartTime.dVal) GETN_ADD_AUTO(1)
   		//GETN_NUM(trEndTime, "Stop Time", trEndTime.dVal) GETN_ADD_AUTO(1)
		}



		/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT

		trSkipPointsOptions.AddNode(trStartPoint);
		trSkipPointsOptions.AddNode(trReadPoint);
		trSkipPointsOptions.AddNode(trEndPoint);
		
		//trSkipPointsOptions.AddNode(trSubRange); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		// remove out from old place
		trPartialImport.Remove(); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		trColStartPoint.Remove();
		trColEndPoint.Remove();
		trStartPoint.Remove();
		trReadPoint.Remove();
		trSkipPoint.Remove();
		trEndPoint.Remove();
		
		/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		trStartTime.Remove();
		trEndTime.Remove();
		/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT

		//trSubRange.Remove(); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		
		// set treenode attribute for XF GUI
		// attribute - show
		tree_set_attribute_to_all_nodes(trSkipPointsOptions, STR_SHOW_ATTRIB, "1");
		trPartialImport		= tree_get_node_by_id(trOptions, IDE_XFIMP_PARTIAL_IMPORT, true); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		trColStartPoint		= tree_get_node_by_id(trOptions, IDE_XFIMP_COL_START_POINT, true);
		trColEndPoint		= tree_get_node_by_id(trOptions, IDE_XFIMP_COL_END_POINT, true);
		trStartPoint		= tree_get_node_by_id(trOptions, IDE_XFIMP_START_POINT, true);
		trReadPoint 		= tree_get_node_by_id(trOptions, IDE_XFIMP_READ_POINT, true);
		trSkipPoint 		= tree_get_node_by_id(trOptions, IDE_XFIMP_SKIP_POINT, true);
		trEndPoint 			= tree_get_node_by_id(trOptions, IDE_XFIMP_END_POINT, true);
		
		/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		trStartTime			= tree_get_node_by_id(trOptions, IDE_XFIMP_START_TIME, true);
		trEndTime 			= tree_get_node_by_id(trOptions, IDE_XFIMP_END_TIME, true);
		/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT

		
		//trSubRange			= tree_get_node_by_id(trOptions, IDE_XFIMP_SUB_RANGE, true); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		
		//trReadPoint.Show = 0; // default of read point always is 1
		//trReadPoint.Enable = 0; // default of read point always is 1
		
		// attribute - node type
		trPartialImport.ID = TRGP_CHECK;
		//trSubRange.ID = TRGP_CHECK;
		
		// attribute - extra
		trSkipPointsOptions.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_PARTIAL_IMPORT);
		trPartialImport.SetAttribute(STR_LABEL_ATTRIB, STR_LBL_PARTIAL_IMPORT); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		trColStartPoint.SetAttribute(STR_LABEL_ATTRIB, _L("Start Col"));
		trColEndPoint.SetAttribute(STR_LABEL_ATTRIB, _L("End Col"));
		trStartPoint.SetAttribute(STR_LABEL_ATTRIB, _L("Start Point"));
		trReadPoint.SetAttribute(STR_LABEL_ATTRIB, _L("Read Point"));
		trSkipPoint.SetAttribute(STR_LABEL_ATTRIB, _L("Skip Points"));
		trEndPoint.SetAttribute(STR_LABEL_ATTRIB, _L("End Point"));
		/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		trStartTime.SetAttribute(STR_LABEL_ATTRIB, _L("Start time"));
		trEndTime.SetAttribute(STR_LABEL_ATTRIB, _L("End time"));
		/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT

		//trSubRange.SetAttribute(STR_LABEL_ATTRIB, "Sub Range"); ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		
		// attribute - event
		GETN_SET_EVENT_EX_HANDLER(trPartialImport, OnChangePartialImportOptions) ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		//GETN_SET_EVENT_EX_HANDLER(trSubRange, OnChangePartialImportOptions)  ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
		GETN_SET_EVENT_EX_HANDLER(trSkipPoint, OnChangePartialImportOptions) 
		
		
		/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		GETN_SET_EVENT_EX_HANDLER(trStartTime, OnChangePartialImportTime) 
		GETN_SET_EVENT_EX_HANDLER(trEndTime, OnChangePartialImportTime) 
//		GETN_SET_EVENT_EX_HANDLER(trStartPoint, OnChangePartialImportPoints) 
//		GETN_SET_EVENT_EX_HANDLER(trEndPoint, OnChangePartialImportPoints) 
		/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
		
		
		///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
		//if ( !bColPartial )
		if ( !(dwCntrl & FILTER_OPTIONS_COL_PARTIAL) )
		///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
		{
			trColStartPoint.Show = 0;
			trColEndPoint.Show = 0;
		}
		///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
		//if ( !bReadRow )
		if ( !(dwCntrl & FILTER_OPTIONS_READ_ROW) )
		///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
		{
			trReadPoint.Show = 0;
		}
		///---Sim 05-30-2007 QA80-9476-P8 DEFAULT_NOT_OPEN_TIME_PARTIAL
		///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
		//if ( !bTimePartial )
		if ( !(dwCntrl & FILTER_OPTIONS_TIME_PARTIAL) )
		///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
		{
			trInfo.Show = 0;
			trStartTime.Show = 0;
			trEndTime.Show = 0;
		}
		///---END QA80-9476-P8 DEFAULT_NOT_OPEN_TIME_PARTIAL
		///---END ADD_OPTION_TO_PARTIAL_COLUMN
	}
}
///---END GET_MOST_GENERAL_OPTIONS_FOR_XF

///---Sim 02-27-2007 QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
//int reduce_data(vectorbase& vb, int nSkip, int nBlockSize, int nStart, int nEnd) // = 1, 0, -1
//{
	//if ( nStart < 0 )
		//nStart = 0;
	//if ( nEnd <= -1 || nEnd > vb.GetSize() - 1 )
		//nEnd = vb.GetSize() - 1;
	//
	//if ( nSkip < 0 )
		//nSkip = 0;
	//if ( nBlockSize < 1 )
		//nBlockSize = 1;
	//
	//int nOffset = 0;
	//
	//int nIndex = nStart;
	//while ( nIndex <= nEnd)
	//{
		//int nLen = nBlockSize;
		//if ( nEnd - nIndex + 1 < nLen )
			//nLen = nEnd - nIndex + 1;
		//
		//for ( int ii = 0; ii < nLen; ii++ )
		//{
			//vb[nOffset + ii] = vb[nIndex + ii];
		//}
		//
		//nOffset += nLen;
		//nIndex += nLen + nSkip;		
	//}
	//
	//vb.SetSize(nOffset);
	//
	//return nOffset;
//}

void reduce_data(Worksheet& wks, int nC1, int nC2, int nSkip, int nStart, int nEnd, int nBlockSize) // = 0, -1, 1
{
	if ( 0 == nSkip && 0 == nStart && -1 == nEnd )
		return;
	
	///---Sim 05-30-2007 CHECK_VALID_SETTING
	if ( 0 == nSkip )
		nBlockSize = 1;
	///---END CHECK_VALID_SETTING
	
	///---Sim 03-23-2007 QA80-P10-L3 FIX_LACK_OF_ONE_ROW
	// Shulin has fixed Column.ReduceSize(), not need the following temporary fix.
	//temporary fix
	//if ( nEnd >= 0 )
		//nEnd++;
	///---END QA80-P10-L3 FIX_LACK_OF_ONE_ROW
	
	int nRet;
	for ( int ii = nC1; ii <= nC2; ii++ )
	{
		Column col = wks.Columns(ii);
		
		//vectorbase& vb = col.GetDataObject();
		//reduce_data(vb, nSkip, nBlockSize, nStart, nEnd);
		//
		//double dX0, dxInc;
		//if ( col.IsEvenSampling(&dX0, &dxInc) )
		//{
			//dX0 += dxInc * nStart;
			//if ( 1 == nBlockSize )
				//dxInc *= (nBlockSize + nSkip);
			//else
			//{
				//string strMsg;
				//strMsg.Format("Sampling Interval error when reduce column(%s) data! The size of data block can't be more than one.", col.GetLongName());
				//warning_msg_box(strMsg, false);
			//}
			//wks.SetEvenSampling(dX0, dxInc, col);
		//}
		///---Sim 04-11-2007 FIX_SKIP_DATA_POINTS
		DWORD dwCtrl = DORS_DEL_BEFORE_AFTER;
		if ( col.IsEvenSampling() )
			dwCtrl |= DORS_UPDATE_SAMPLE_INTERVAL;
		//nRet = col.ReduceSize(nSkip, DORS_UPDATE_SAMPLE_INTERVAL | DORS_DEL_BEFORE_AFTER, nStart, nEnd, nBlockSize);
		nRet = col.ReduceSize(nSkip, dwCtrl, nStart, nEnd, nBlockSize);
		///---END FIX_SKIP_DATA_POINTS
		if ( nRet < 0 )
			warning_msg_box(_L("Reduce column data error: %d"), nRet, false);
	}
	
	int nR1, nR2;
    wks.GetBounds(nR1, 0, nR2, -1);
    wks.SetSize(nR2+1, -1);	
}

void reduce_data(Worksheet& wks, int nC1, int nC2, TreeNode& trFilter)
{
	///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
	if ( fuGetPartialImport(trFilter) )
	{
		int nSkip = fuGetSkipPoint(trFilter);
		int nBlockSize = fuGetReadPoint(trFilter);
		
		int nStart = 0, nEnd = -1;
		//if ( fuGetSubRange(trFilter) )
		//{
		nStart = fuGetStartPoint(trFilter) - 1;
		nEnd = fuGetEndPoint(trFilter) - 1;
		//}
		
		reduce_data(wks, nC1, nC2, nSkip, nStart, nEnd, nBlockSize);
	}
	///---END ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
}
///---END QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS

///---Sim 04-06-2007 MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT
void initASCIMP(ASCIMP& ascimp)
{
	okoc_init_ASCIMP(&ascimp);
	
	ascimp.iMode = ASCIMP_MODE_NEW_SHEETS; ///---Sim 05-08-2007 REMOVE_REPLACE_OUT_OF_MULTI_FILE_IMPORT_MODE
	
	ascimp.iDelimited = 1;
	ascimp.iApplyRange = 0;
	
	ascimp.iRenameCols = 0; ///---Sim 01-18-2007 SHORT_NAME_IS_NOT_CHANGED_BY_DEFAULT
	ascimp.iRenameWks = 1; // rename sheet
	ascimp.flags |= AI_FLAG_FNAME_TO_WKBK_NAME; // rename book
	ascimp.flags |= AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME;  // include path when rename book default is off
	ascimp.flags |= AI_FLAG_FNAME_TO_WKBK_COMMENTS; // append file name to book comment

	/// Hong 07/30/08 QA80-11915 ASCII_DEFAULT_TURN_OFF_FORCE_SAME_SIZE_SUGGEST_CP_MAX
	//ascimp.flags |= AI_FLAG_ADD_NANUM_MAKE_SAME_LENGTH; // set force same size
	/// end ASCII_DEFAULT_TURN_OFF_FORCE_SAME_SIZE_SUGGEST_CP_MAX
	
	/// Hong 08/05/08 QA80-11945 DEFAULT_TURN_ON_ALLOW_ALL_TEXT_IN_OC_CONSISTENT_WITH_75
	// see AFCH_OC_ACCESS in VC of ascii import
	ascimp.iAllowAllText = 1;
	/// end DEFAULT_TURN_ON_ALLOW_ALL_TEXT_IN_OC_CONSISTENT_WITH_75
	
	ascimp.flags |= AI_FLAG_REMOVE_QUOTES; // remove quotes ///---Sim 05-29-2007 CHANGE_DEFAULT_VALUE
	
	/// Hong 04/14/09 FIX_IMPASC_THEME_RESET_FAIL_RESET_PARTIAL_OPTIONS
	// Hong, set partial default to full range and turn off
	if ( 0 == ascimp.iPartial )
	{
		ascimp.iPartialC2 = -1;
		ascimp.iPartialR2 = -1;
	}
	/// end FIX_IMPASC_THEME_RESET_FAIL_RESET_PARTIAL_OPTIONS
}
///---END MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT

///---Sim 06-08-2007 DEFAULT_VALUE_FOR_BIN_IMPORT
void initBINIMP(BINIMP& binimp)	
{
	BINIMP bi = {0};
	binimp = bi; // clear to 0
	
	binimp.iPartialC2 = -1;
	binimp.iPartialR2 = -1;
	binimp.iSkipRows = 0;
	binimp.iReadRows = 1;
	
	binimp.iMode = ASCIMP_MODE_NEW_SHEETS; ///---Sim 05-08-2007 REMOVE_REPLACE_OUT_OF_MULTI_FILE_IMPORT_MODE
	
	binimp.iApplyRange = 0;
	
	binimp.iRenameWks = 1; // rename sheet
	binimp.flags |= AI_FLAG_FNAME_TO_WKBK_NAME; // rename book
	binimp.flags |= AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME;  // include path when rename book default is off
	binimp.flags |= AI_FLAG_FNAME_TO_WKBK_COMMENTS; // append file name to book comment
	
}
///---END DEFAULT_VALUE_FOR_BIN_IMPORT


///---Sim 04-30-2007 TEMP_FIX_IMPORT_MODE_FOR_SINGLE_FILE
int get_first_file_import_mode(int nFileType)// = FILE_TYPE_NONE
{
	int nMode = ASCIMP_MODE_REPLACE_DATA;
	switch ( nFileType )
	{
	case FILE_TYPE_MDF:
	case FILE_TYPE_JNB:
	case FILE_TYPE_TDM:
	case FILE_TYPE_NETCDF:
	case FILE_TYPE_MNTB:
		nMode = ASCIMP_MODE_NEW_BOOKS;
		break;
	default:
		break;
	}
	
	return nMode;
}
///---END TEMP_FIX_IMPORT_MODE_FOR_SINGLE_FILE

///---Sim 05-31-2007 IMPROVE_REIMPORT_CONTEXT_MENUE
/// Hong 06/08/07 QA80-9890 IMPORT_ALL_DATA_TO_ONE_SHEET
//#define STR_REIMPORT_FILE_TYPE "impAsc,impCSV,imppClamp,impSPC,impWAV,impNIDiaDem"
///---Sim 03-03-2009 QA80-13209 IMPORT_IMG_SUPPORT_REIMPORT
//#define STR_REIMPORT_FILE_TYPE "impAsc,impCSV,imppClamp,impSPC,impWAV,impNIDiaDem,impMDF"
///---Sim 04-27-2010 ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
//#define STR_REIMPORT_FILE_TYPE "impAsc,impCSV,imppClamp,impSPC,impWAV,impNIDiaDem,impMDF,impImage"
#define STR_REIMPORT_FILE_TYPE "impAsc,impCSV,imppClamp,impSPC,impWAV,impNIDiaDem,impMDF,impImage,impBin2d"
///---END ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
///---END QA80-13209 IMPORT_IMG_SUPPORT_REIMPORT
/// end /// Hong 06/08/07 QA80-9890 IMPORT_ALL_DATA_TO_ONE_SHEET

bool isReimportable(TreeNode& trFileNode, string* pstrXFName) // = NULL
{
	string strXFName;
	
	if ( !trFileNode.Info.FileType )
		return false;
	
	if(0 == trFileNode.Info.FileType.strVal.Compare(STR_FILTER_TYPE_ASCII)) // if ascii type
	{
		strXFName = "impAsc";	
	}
	else
	{
		if ( !trFileNode.FilterInfo )
			return false;
		fuGetXFunctionName(trFileNode.FilterInfo, strXFName);
	}
	
	vector<string> vsReimportXF;
	string strXFs(STR_REIMPORT_FILE_TYPE);
	strXFs.GetTokens(vsReimportXF, ',');
	
	if ( -1 == vsReimportXF.Find(strXFName) )
		return false;
	
	if ( NULL != pstrXFName )
		*pstrXFName = strXFName;
	
	return true;
}
///---END IMPROVE_REIMPORT_CONTEXT_MENUE

///---Sim 06-06-2007 CHANGE_FILTER_TAGNAME_ISSUE
/*
void _add_node_by_id(const TreeNode& trSrc, TreeNode& trDest)
{
	if ( !trSrc )
		return;
	
	int nDataID;
	if ( trSrc.GetAttribute(STR_DATAID_ATTRIB, nDataID) )
	{
		TreeNode trTemp = tree_get_node_by_id(trDest, nDataID, true);
		if ( !trTemp )
		{
			TreeNode tr = trDest.AddNode(trSrc.tagName);
			tr.SetAttribute(STR_DATAID_ATTRIB, nDataID);
		}
	}	
	
	foreach( TreeNode tr in trSrc.Children )
		_add_node_by_id(tr, trDest);
}
*/

int tree_whole_copy_values_by_id(const TreeNode& trSrc, TreeNode& trDest)
{
	//_add_node_by_id(trSrc, trDest);
	
	//return tree_copy_values_by_id(trSrc, trDest);
	return octree_whole_copy_values_by_id(&trSrc, &trDest);
}
///---END CHANGE_FILTER_TAGNAME_ISSUE

///---Sim 06-07-2007 FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES
bool isMultiFilesXF(LPCSTR lpcszXFName)
{
	string strXFName(lpcszXFName);
	
	if ( 	0 == strXFName.CompareNoCase(STR_XF_NAME_WAV)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_CSV)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_IMAGE)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_EXCEL)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_MATLAB)
		//||	0 == strXFName.CompareNoCase(STR_XF_NAME_PCLAMP)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_PCLAMP) ///---Sim 10-31-2008 v9.963d FIX_DRAG_AND_DROP_PCLAMP_IMPORT_MODE_FAILED
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_MDF)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_SPE)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_SPC)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_TDM)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_DIADEM)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_NETCDF)
		///Sophy 8/24/2009 ADD_FILTERS_FOR_CDF_NETCDFEX_HDF5
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_NETCDFEX)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_CDF)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_HDF5)
		///end ADD_FILTERS_FOR_CDF_NETCDFEX_HDF5
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_MNTB)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_KG)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_JNB)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_JCAMP)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_FAMOS)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_EP)
		||	0 == strXFName.CompareNoCase(STR_XF_NAME_DT)
		)
	{
		return true;
	}
	else
	{
		return false;
	}
}
///---END FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES

//---Jake 07/12/07 CHECK_SUPPORT_D&D
/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
//bool is_drag_n_drop_supported(LPCSTR lpcszFilterName, bool bSystemFolder)
bool is_drag_n_drop_supported(LPCSTR lpcszFilterName, int nLocation)
/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
{
	bool bValue;	
	//if ( !get_filter_setting(lpcszFilterName, bValue, bSystemFolder))
	if ( !get_filter_setting(lpcszFilterName, bValue, nLocation)) /// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
		bValue = true;
	return bValue;
}
//---end CHECK_SUPPORT_D&D

///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
bool update_sparkline(int nSparklineType, Worksheet& wks, int nC1, int nC2) // = 0, -1
{
	if ( nC2 < 0 )
		nC2 = wks.GetNumCols() - 1;
	//----- CPY 9/24/07 UNINIT_VAR_AND_SHOULD_NOT_ASSUME_0_MEANS_NO
	//bool bSparkline;
	//---Sim 09-25-2007 UNINIT_VAR_AND_SHOULD_NOT_ASSUME_0_MEANS_NO
	//bool bSparkline = SPARKLINE_NO_CHANGE;
	bool bSparkline = false;
	//---END UNINIT_VAR_AND_SHOULD_NOT_ASSUME_0_MEANS_NO
	//-----
	
	switch (nSparklineType)
	{
	case SPARKLINE_NO_CHANGE:
		bSparkline = false;
		break;
	case SPARKLINE_ADD:
		bSparkline = true;
		break;
	case SPARKLINE_ADD_IF_LESS_THAN_50_COLS:
		bSparkline = false;
		if ( nC2 - nC1 + 1 < 50 )
			bSparkline = true;		
		break;
	}	
	
	if ( bSparkline )
	{
		XFBase xfSparkLine("sparklines");
		if( !xfSparkLine )
		{
			return false;
		}
		else
		{
			//----- CPY 9/16/2007 QA70-10383 SPARKLINE_LAST_USED_THEME
			xfSparkLine.ApplyTheme(STR_LAST_USED);
			//-----
			xfSparkLine.SetArg("sel", 0);
			xfSparkLine.SetArg("c1", nC1+1);
			xfSparkLine.SetArg("c2", nC2+1);
			xfSparkLine.SetArg("iw", wks);
			
			if ( !xfSparkLine.Evaluate() )
				return false;
		}
	}
	
	return true;
}
///---END SUPPORT_SMART_SPARKLINE


void update_sparkline_ex(int nSparklines, WorksheetPage pg)
{
	if(!pg)
		return;
	
	if(SPARKLINE_NO_CHANGE == nSparklines)
		return;
	
	
	bool bAborted = false;
	int nCols=0, iWks=-1;
	Worksheet wks;	
	while(1)
	{
		wks = pg.Layers(++iWks);
		if(!wks)break;
		
		nCols += wks.GetNumCols();
	}
	
	if(nCols > 50 && SPARKLINE_ADD_IF_LESS_THAN_50_COLS == nSparklines)
		return;
	
	/// Kenny 12/24/2009 QA81-14875-P2 PROGRESS_BAR_IN_BUILTIN_TOOL_SHOULD_NOT_KEEP_TOPMOST
	//progressBox aa("Adding sparklines, please wait:", PBOX_TOPMOST, false);
	progressBox aa("Adding sparklines, please wait:", PBOX_DEFAULT_STYLE, false);
	/// End QA81-14875-P2 PROGRESS_BAR_IN_BUILTIN_TOOL_SHOULD_NOT_KEEP_TOPMOST
	aa.SetRange(0, nCols);
	
	DWORD dwCntrl = EMBEDGRAPH_IN_LABELS | EMBEDGRAPH_HIDE_AXES | EMBEDGRAPH_HIDE_LEGENDS | EMBEDGRAPH_HIDE_SPECTRUMS | EMBEDGRAPH_HIDE_TEXT_OBJS;
	int cc=0;
		
	iWks=-1;
	while(1)
	{
		wks = pg.Layers(++iWks);
		if(!wks)break;
		
		wks_set_col_label_heights(wks, RCLT_SPARKLINE, 200, false);
		
		for(int nC = 0; nC < wks.GetNumCols(); ++nC)
		{
			string str;
			str.Format("Current at %s:%s", wks.GetName(), wks.Columns(nC).GetName());
			if(aa.Set(cc++))
			{
				aa.SetText(str, PBOXT_TITLE);
			}
			else
			{
				if(!bAborted){
					bAborted = true;				
					printf("User abort!");
				}
				break;
			}
			SetStatusBarText(str);
			
			GraphPage gp;
			DataPlot dp = plot_col(wks, nC, gp, IDM_PLOT_LINE, true, "sparkline_label", true, 0);
			wks.EmbedGraph(RCLT_SPARKLINE, nC, gp, dwCntrl);
		}
	}
	
}

/// Hong 09/08/07 v8.0698b FIX_FAIL_DUMP_OUTPUT_RANGE_ORNG
bool reset_range_to_first_obj(DataRange& dr, Datasheet& ds)
{
	if ( !dr || !ds )
		return false;
	
	/// ML 9/11/2007 RUNTIME_ERROR_WHEN_IMPORTING_INTO_MATRIX
	//Worksheet wks(ds);
	//
	//return dr.SetRange(0, wks, 0, 0, -1, 0);
	return dr.SetRange(0, ds, 0, 0, -1, 0);
	/// end RUNTIME_ERROR_WHEN_IMPORTING_INTO_MATRIX
}
/// end FIX_FAIL_DUMP_OUTPUT_RANGE_ORNG

///Sophy 10/23/2008 QA80-12422 SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
string fu_get_filter_path(int nLocalization /*= FILTER_LOCATION_SYSTEM_FOLDER */ )
{
	string strPath;
	switch (nLocalization)
	{
	case FILTER_LOCATION_SYSTEM_FOLDER:
		strPath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
		break;
	case FILTER_LOCATION_USER_FOLDER:
		strPath.Format("%s%s", GetAppPath(FALSE), FILTERS_FOLDER_NAME);
		break;
	/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	case FILTER_LOCATION_GROUP_FOLDER:
		/// Hong 09/30/07 v8.0711c GROUP_PATH_CAN_BE_EMPTY
		//strPath.Format("%s%s", okutil_get_origin_path(ORIGIN_PATH_GROUP), FILTERS_FOLDER_NAME);
		strPath = okutil_get_origin_path(ORIGIN_PATH_GROUP);
		if ( !strPath.IsEmpty() )		
			strPath.Format("%s%s", strPath, FILTERS_FOLDER_NAME);
		/// end GROUP_PATH_CAN_BE_EMPTY
		break;
	/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	}
	
	return strPath;
}

bool	fuIsSysFilter( LPCSTR lpcszFilterFileName )
{
	ASSERT( lpcszFilterFileName );
	if( NULL == lpcszFilterFileName )
		return false;
	
	string strFileName(lpcszFilterFileName);
	string strFilePath = GetFilePath( strFileName );
	string strSysPath = GetOriginPath( ORIGIN_PATH_SYSTEM );
	
	string strSysFilterPath = fu_get_filter_path();
	//strSysFilterPath.Format("%s%s", strSysPath, FILTERS_FOLDER_NAME );
	
	return ( strSysFilterPath.CompareNoCase( strFilePath ) == 0 );
	
}
///end SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER

///---Sim 10-29-2008 v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
TreeNode check_add_getn_LT_to_filter_options(TreeNode& trOptions)
{
	TreeNode trGetNLT;
	TreeNode trNode = trOptions.FirstNode;
	if ( trNode )
		trGetNLT = trOptions.InsertNode(trNode, STR_NODE_NAME_GETN_LT);
	else
		trGetNLT = trOptions.AddNode(STR_NODE_NAME_GETN_LT);
	
	trGetNLT.Show = false;
	return trGetNLT;
}

#define STR_XF_IMP_EXCEL_FIRST_IMP_MODE "firstmode"
#define STR_XF_IMP_EXCEL_IMP_MODE "impmode"
// hard code, copy from impExcel.oxf
enum{
	impmode_book,
	impmode_sheet,
};

static int _get_excel_maped_import_mode(int nMode, bool bExcelToFilter)
{
	if ( bExcelToFilter )
	{
		switch ( nMode )
		{
		case impmode_book: return ASCIMP_MODE_NEW_BOOKS;
		case impmode_sheet: return ASCIMP_MODE_NEW_SHEETS;
		}
		return ASCIMP_MODE_NEW_BOOKS;
	}
	else
	{
		switch ( nMode )
		{
		case ASCIMP_MODE_NEW_BOOKS: return impmode_book;
		case ASCIMP_MODE_NEW_SHEETS: return impmode_sheet;
		}
		return impmode_book;
	}
}

void	update_getn_LT_variables(TreeNode& trGetN, LPCSTR lpcszXFName, bool bGetN2FilterOptions)
{
	string strXFName(lpcszXFName);
	///---Sim 04-27-2010 ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
	//if ( 0 == strXFName.CompareNoCase(STR_XF_NAME_EXCEL) )
	///---END ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
	{
		TreeNode trGetNLT = tree_get_node_by_tagname(trGetN, STR_NODE_NAME_GETN_LT, true);
		if ( trGetNLT )
		{
			foreach (TreeNode tr in trGetNLT.Children)
			{
				string strTagName = tr.tagName;
				//TreeNode trNodeInGetN = tree_get_node_by_tagname(trGetN, strTagName, false);
				TreeNode trNodeInGetN = trGetN.GetNode(strTagName);
				if ( !trNodeInGetN )
					continue;
				
				///---Sim 04-27-2010 ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
				if ( 0 == strXFName.CompareNoCase(STR_XF_NAME_EXCEL) )
				{
				///---END ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
					if ( 0 == strTagName.CompareNoCase(STR_XF_IMP_EXCEL_FIRST_IMP_MODE) || 0 == strTagName.CompareNoCase(STR_XF_IMP_EXCEL_IMP_MODE) )
					{
						if ( bGetN2FilterOptions )
							tr.nVal = _get_excel_maped_import_mode(trNodeInGetN.nVal, true);
						else
							trNodeInGetN.nVal = _get_excel_maped_import_mode(tr.nVal, false);
						continue;
					}
				///---Sim 04-27-2010 ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
				}
				///---END ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
				
				if ( bGetN2FilterOptions )
					tr.strVal = trNodeInGetN.strVal;
				else
					trNodeInGetN.strVal = tr.strVal;					
			}
		}		
	}
}
///---END v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
///---Sim 04-27-2010 ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
void	generate_using_filter_tree_by_getn_tree(TreeNode& trUsingFilter, const TreeNode& trGetNOptions)
{
	if ( trGetNOptions )
	{
		trUsingFilter.Replace(trGetNOptions, true, true, true);
		
		TreeNode trGetNLT = trUsingFilter.GetNode(STR_NODE_NAME_GETN_LT);
		if ( trGetNLT )
			trGetNLT.Show = true;
	}
	else
	{
		fuPrepareDefault(trUsingFilter, FILTER_TYPE_XFUNC);
	}	
}
///---END ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK

///Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
void update_custom_date_format_combo_attrib(TreeNode& trDateFormat)
{
	if(!trDateFormat)
		return;
	vector<string> vsList;
	get_custom_date_format_list(vsList);
	vsList.InsertAt(0, STR_NONE);
	string strComboList;
	strComboList.SetTokens(vsList, '|');
	strComboList = "|" + strComboList;
	trDateFormat.SetAttribute(STR_COMBO_ATTRIB, strComboList);
	trDateFormat.SetAttribute(STR_OCNTRL_OPTNS ,OCNTRLPARAM1_NOT_LOCALIZED);
}
///End CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT


/// Hong 11/10/09 QA80-11771 IMPORT_MODE_SUPPORT_SKIP_EMPTY_BOOK_SHEET
bool	fuIsSkipEmptyBookSheet(int nImpMode)
{
	if ( ASCIMP_MODE_NEW_BOOKS != nImpMode && ASCIMP_MODE_NEW_SHEETS != nImpMode )
		return false;
	double		dVal = 0.0;
	LT_get_var("@ISE", &dVal);
	return (0 != dVal);
}
/// end IMPORT_MODE_SUPPORT_SKIP_EMPTY_BOOK_SHEET

///---Sim 01-05-2010 QA81-14895 ADD_LT_VAR_FOR_DEFAULT_COUNTS_OF_AUTOSIZE_COLS
int		fuGetDefaultAutoSizeCols()
{
	double		dVal = 0.0;
	if ( !LT_get_var("@ISC", &dVal) )
		return 0;
	return dVal;
}
///---END QA81-14895 ADD_LT_VAR_FOR_DEFAULT_COUNTS_OF_AUTOSIZE_COLS

///---Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
void fu_autosize_rowcol(Worksheet wks, TreeNode& trFilter, double dminCol, double dmaxCol, double dminRow, double dmaxRow, int nColCounts, DWORD dwCntrlCol, DWORD dwCntrlRow)
{
	if ( wks )
	{
		int nAutoSize = fuGetAutoSize(trFilter);
		if ( FILTER_AUTO_SIZE_NO != nAutoSize )
		{
			///---Sim 01-05-2010 QA81-14895 ADD_LT_VAR_FOR_DEFAULT_COUNTS_OF_AUTOSIZE_COLS
			if ( 0 == nColCounts )
				nColCounts = fuGetDefaultAutoSizeCols();
			///---END QA81-14895 ADD_LT_VAR_FOR_DEFAULT_COUNTS_OF_AUTOSIZE_COLS
			
			DWORD dw = AS_INVALIDATE | _get_auto_size_cntrl(nAutoSize);
			vector<int>		vnLabelTypesToSkip = {
				RCLT_SPARKLINE
			};
			autosize_rowcol(wks, dminCol, dmaxCol, dminRow, dmaxRow, dw, 0, 0, nColCounts, dwCntrlCol, dwCntrlRow, vnLabelTypesToSkip, true);
			///---Sim 12-29-2009 QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL
			// auto resize height of comment label only
			if ( dw & AS_NOHEIGHT )
			{
				dw &= ~AS_NOHEIGHT;
				dw |= AS_NOWIDTH;
				vector<int>		vnLabelTypes = {
					RCLT_COMMENT
				};
				autosize_rowcol(wks, dminCol, dmaxCol, dminRow, dmaxRow, dw, 0, 0, nColCounts, dwCntrlCol, dwCntrlRow, vnLabelTypes, false, true);
			}
			///---END QA81-14148 REDO_AUTOSIZE_BETTER_HEIGHT_FOR_LABEL
		}
	}
}
///---END QA81-14895 SPEED_UP_81_IMP_WIZ_ASC

///---Sim 02-04-2010 QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE
#define STR_IMPORT_FILE_NAME_INFO		"ImportFile"
bool fu_set_import_file_name_info(OriginObject& obj, LPCSTR lpcszFileName, DWORD dwCtrl)// = 0
{
	Tree tree;
	TreeNode trFileName = tree.AddTextNode(lpcszFileName, STR_IMPORT_FILE_NAME_INFO);
	trFileName.Enable = ENABLE_READ_ONLY;
	
	if ( IMPORT_INFO_TO_USER_TREE & dwCtrl )
	{
		tree.Enable = ENABLE_READ_ONLY;
		tree.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
		///---Sim 02-05-2010 QA81-15063 ROLL_BACK_MOVE_COL_INFO_OUT_OF_USER_TREE
		// roll back move column info out of user tree, as CP said
		//tree.Show = 0; // only for user's old version code
		///---END QA81-15063 ROLL_BACK_MOVE_COL_INFO_OUT_OF_USER_TREE
		return set_user_info(obj, (string)"ColumnInfo", tree);
	}

	return set_import_file_info(obj, trFileName, STR_IMPORT_FILE_NAME_INFO);
}
bool fu_set_import_file_info(OriginObject& obj, TreeNode& trInfo, LPCSTR lpcszSectionName, DWORD dwCtrl) // = 0
{
	if ( IMPORT_INFO_TO_USER_TREE & dwCtrl )
	{
		return set_user_info(obj, (string)lpcszSectionName, trInfo);
	}

	Tree trInfoCopy;
	trInfoCopy = trInfo;
	TreeNode trFileName = trInfoCopy.GetNode(STR_IMPORT_FILE_NAME_INFO);
	if ( trFileName )
	{
		set_import_file_info(obj, trFileName, STR_IMPORT_FILE_NAME_INFO);
		trInfoCopy.RemoveChild("ImportFile");
	}
	return set_import_file_info(obj, trInfoCopy, lpcszSectionName);	
}
///---END QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE

///------ Folger 06/28/10 ORG-155 ASCII_IMPORT_SPEED_IMPROVE
TreeNode	fuCheckAddFileInfoNode(TreeNode& trFile, LPCSTR lpcszFile)
{
	double	rNPI = 0.0;
	LT_get_var("@NPI", &rNPI);
	int		nn = rNPI;
	int		nCount = trFile.Children.Count();
	if ( nn > 0 )
	{
		while ( nCount-- >= nn )
		{
			trFile.FirstNode.Remove();
		}
	}
	
	return trFile.AddNode(lpcszFile);
}
///------ End ASCII_IMPORT_SPEED_IMPROVE